/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.message.header;

import java.net.URI;
import org.fourthline.cling.model.message.header.InvalidHeaderException;
import org.fourthline.cling.model.message.header.UpnpHeader;
import org.fourthline.cling.model.types.SoapActionType;

public class SoapActionHeader
extends UpnpHeader<SoapActionType> {
    public SoapActionHeader() {
    }

    public SoapActionHeader(URI uri) {
        this.setValue(SoapActionType.valueOf(uri.toString()));
    }

    public SoapActionHeader(SoapActionType value) {
        this.setValue(value);
    }

    public SoapActionHeader(String s2) throws InvalidHeaderException {
        this.setString(s2);
    }

    @Override
    public void setString(String s2) throws InvalidHeaderException {
        try {
            if (!s2.startsWith("\"") && s2.endsWith("\"")) {
                throw new InvalidHeaderException("Invalid SOAP action header, must be enclosed in doublequotes:" + s2);
            }
            SoapActionType t2 = SoapActionType.valueOf(s2.substring(1, s2.length() - 1));
            this.setValue(t2);
        }
        catch (RuntimeException ex) {
            throw new InvalidHeaderException("Invalid SOAP action header value, " + ex.getMessage());
        }
    }

    @Override
    public String getString() {
        return "\"" + ((SoapActionType)this.getValue()).toString() + "\"";
    }
}

