/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.message.header;

import org.fourthline.cling.model.ServerClientTokens;
import org.fourthline.cling.model.message.header.InvalidHeaderException;
import org.fourthline.cling.model.message.header.UpnpHeader;

public class ServerHeader
extends UpnpHeader<ServerClientTokens> {
    public ServerHeader() {
        this.setValue(new ServerClientTokens());
    }

    public ServerHeader(ServerClientTokens tokens) {
        this.setValue(tokens);
    }

    @Override
    public void setString(String s2) throws InvalidHeaderException {
        ServerClientTokens serverClientTokens = new ServerClientTokens();
        serverClientTokens.setOsName("UNKNOWN");
        serverClientTokens.setOsVersion("UNKNOWN");
        serverClientTokens.setProductName("UNKNOWN");
        serverClientTokens.setProductVersion("UNKNOWN");
        if (s2.contains("UPnP/1.1")) {
            serverClientTokens.setMinorVersion(1);
        } else if (!s2.contains("UPnP/1.")) {
            throw new InvalidHeaderException("Missing 'UPnP/1.' in server information: " + s2);
        }
        try {
            String[] productNameVersion;
            String[] osNameVersion;
            int numberOfSpaces = 0;
            for (int i = 0; i < s2.length(); ++i) {
                if (s2.charAt(i) != ' ') continue;
                ++numberOfSpaces;
            }
            if (s2.contains(",")) {
                String[] productTokens = s2.split(",");
                osNameVersion = productTokens[0].split("/");
                productNameVersion = productTokens[2].split("/");
            } else if (numberOfSpaces > 2) {
                String beforeUpnpToken = s2.substring(0, s2.indexOf("UPnP/1.")).trim();
                String afterUpnpToken = s2.substring(s2.indexOf("UPnP/1.") + 8).trim();
                osNameVersion = beforeUpnpToken.split("/");
                productNameVersion = afterUpnpToken.split("/");
            } else {
                String[] productTokens = s2.split(" ");
                osNameVersion = productTokens[0].split("/");
                productNameVersion = productTokens[2].split("/");
            }
            serverClientTokens.setOsName(osNameVersion[0].trim());
            if (osNameVersion.length > 1) {
                serverClientTokens.setOsVersion(osNameVersion[1].trim());
            }
            serverClientTokens.setProductName(productNameVersion[0].trim());
            if (productNameVersion.length > 1) {
                serverClientTokens.setProductVersion(productNameVersion[1].trim());
            }
        }
        catch (Exception ex) {
            serverClientTokens.setOsName("UNKNOWN");
            serverClientTokens.setOsVersion("UNKNOWN");
            serverClientTokens.setProductName("UNKNOWN");
            serverClientTokens.setProductVersion("UNKNOWN");
        }
        this.setValue(serverClientTokens);
    }

    @Override
    public String getString() {
        return ((ServerClientTokens)this.getValue()).getHttpToken();
    }
}

