/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioFileFormat {
    private Type m_type;
    private AudioFormat m_audioFormat;
    private int m_nLengthInFrames;
    private int m_nLengthInBytes;
    private Map<String, Object> m_properties;
    private Map<String, Object> m_unmodifiableProperties;

    public AudioFileFormat(Type type, AudioFormat audioFormat, int nLengthInFrames) {
        this(type, audioFormat, nLengthInFrames, null);
    }

    public AudioFileFormat(Type type, AudioFormat audioFormat, int nLengthInFrames, Map<String, Object> properties) {
        this(type, -1, audioFormat, nLengthInFrames);
        this.initProperties(properties);
    }

    protected AudioFileFormat(Type type, int nLengthInBytes, AudioFormat audioFormat, int nLengthInFrames) {
        this.m_type = type;
        this.m_audioFormat = audioFormat;
        this.m_nLengthInFrames = nLengthInFrames;
        this.m_nLengthInBytes = nLengthInBytes;
        this.initProperties(null);
    }

    private void initProperties(Map<String, Object> properties) {
        this.m_properties = new HashMap<String, Object>();
        if (properties != null) {
            this.m_properties.putAll(properties);
        }
        this.m_unmodifiableProperties = Collections.unmodifiableMap(this.m_properties);
    }

    public Type getType() {
        return this.m_type;
    }

    public int getByteLength() {
        return this.m_nLengthInBytes;
    }

    public AudioFormat getFormat() {
        return this.m_audioFormat;
    }

    public int getFrameLength() {
        return this.m_nLengthInFrames;
    }

    public String toString() {
        return super.toString() + "[type=" + this.getType() + ", format=" + this.getFormat() + ", lengthInFrames=" + this.getByteLength() + ", lengthInBytes=" + this.getFrameLength() + "]";
    }

    public Map<String, Object> properties() {
        return this.m_unmodifiableProperties;
    }

    public Object getProperty(String key) {
        return this.m_properties.get(key);
    }

    protected void setProperty(String key, Object value) {
        this.m_properties.put(key, value);
    }

    public static class Type {
        public static final Type AIFC = new Type("AIFC", "aifc");
        public static final Type AIFF = new Type("AIFF", "aiff");
        public static final Type AU = new Type("AU", "au");
        public static final Type SND = new Type("SND", "snd");
        public static final Type WAVE = new Type("WAVE", "wav");
        private String m_strName;
        private String m_strExtension;

        public Type(String strName, String strExtension) {
            this.m_strName = strName;
            this.m_strExtension = strExtension;
        }

        public String getExtension() {
            return this.m_strExtension;
        }

        public final boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Type t2 = (Type)obj;
            return this.toString().equals(t2.toString()) && this.getExtension().equals(t2.getExtension());
        }

        public final int hashCode() {
            int nHash = 11;
            nHash = 31 * nHash + this.toString().hashCode();
            nHash = 31 * nHash + this.getExtension().hashCode();
            return nHash;
        }

        public final String toString() {
            return this.m_strName;
        }
    }
}

