/*
 * Decompiled with CFR 0.152.
 */
package forge.view.arcane.util;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.BreakIterator;
import java.util.Locale;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;

public class OutlinedLabel
extends JLabel {
    private static final long serialVersionUID = -2868833097364223352L;
    private Color outlineColor;
    private static final int outlineSize = 1;
    private boolean wrap;

    public final void setGlow(Color glowColor) {
        this.outlineColor = glowColor;
    }

    public final void setWrap(boolean wrap) {
        this.wrap = wrap;
    }

    @Override
    public final Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.width += 2;
        size.height += 2;
        return size;
    }

    @Override
    public final void setText(String text) {
        super.setText(text);
    }

    @Override
    public final void paint(Graphics g2) {
        if (this.getText().length() == 0) {
            return;
        }
        Dimension size = this.getSize();
        Graphics2D g2d = (Graphics2D)g2;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int textX = 1;
        int textY = 0;
        int wrapWidth = Math.max(0, this.wrap ? size.width - 2 : Integer.MAX_VALUE);
        String text = this.getText();
        AttributedString attributedString = new AttributedString(text);
        if (!StringUtils.isEmpty(text)) {
            attributedString.addAttribute(TextAttribute.FONT, this.getFont());
        }
        AttributedCharacterIterator charIterator = attributedString.getIterator();
        FontRenderContext fontContext = g2d.getFontRenderContext();
        LineBreakMeasurer measurer = new LineBreakMeasurer(charIterator, BreakIterator.getWordInstance(Locale.ENGLISH), fontContext);
        int lineCount = 0;
        while (measurer.getPosition() < charIterator.getEndIndex()) {
            measurer.nextLayout(wrapWidth);
            if (++lineCount <= 2) continue;
        }
        charIterator.first();
        if (lineCount > 2) {
            measurer = new LineBreakMeasurer(charIterator, BreakIterator.getCharacterInstance(Locale.ENGLISH), fontContext);
        } else {
            measurer.setPosition(0);
        }
        while (measurer.getPosition() < charIterator.getEndIndex()) {
            TextLayout textLayout = measurer.nextLayout(wrapWidth);
            float ascent = textLayout.getAscent();
            textY = (int)((float)textY + ascent);
            g2d.setColor(this.outlineColor);
            g2d.setComposite(AlphaComposite.getInstance(3, 0.8f));
            textLayout.draw(g2d, textX + 1, textY - 1);
            textLayout.draw(g2d, textX + 1, textY + 1);
            textLayout.draw(g2d, textX - 1, textY - 1);
            textLayout.draw(g2d, textX - 1, textY + 1);
            g2d.setColor(this.getForeground());
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
            textLayout.draw(g2d, textX, textY);
            textY = (int)((float)textY + (textLayout.getDescent() + textLayout.getLeading()));
        }
    }
}

