/*
 * Decompiled with CFR 0.152.
 */
package forge.view.arcane.util;

import forge.view.arcane.CardPanel;
import java.awt.Container;
import java.awt.EventQueue;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JLayeredPane;

public abstract class Animation {
    private static final long TARGET_MILLIS_PER_FRAME = 30L;
    private static final Timer timer = new Timer("Animation", true);
    private final long delay;
    private final TimerTask timerTask;
    private FrameTimer frameTimer;
    private long elapsed;

    private Animation(long duration) {
        this(duration, 0L);
    }

    private Animation(final long duration, long delay) {
        this.delay = delay;
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                if (Animation.this.frameTimer == null) {
                    Animation.this.onStart();
                    Animation.this.frameTimer = new FrameTimer();
                }
                Animation.this.elapsed += Animation.this.frameTimer.getTimeSinceLastFrame();
                if (Animation.this.elapsed >= duration) {
                    this.cancel();
                    Animation.this.elapsed = duration;
                }
                Animation.this.update((float)Animation.this.elapsed / (float)duration);
                if (Animation.this.elapsed == duration) {
                    Animation.this.onEnd();
                }
            }
        };
    }

    protected final void run() {
        timer.scheduleAtFixedRate(this.timerTask, this.delay, 30L);
    }

    protected abstract void update(float var1);

    protected final void cancel() {
        this.timerTask.cancel();
        this.onEnd();
    }

    protected void onStart() {
    }

    protected void onEnd() {
    }

    private static void invokeLater(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    public static void tapCardToggle(final CardPanel panel) {
        new Animation(200L){

            @Override
            protected void onStart() {
                panel.setTapped(!panel.isTapped());
            }

            @Override
            protected void update(float percentage) {
                panel.setTappedAngle(1.5707963267948966 * (double)percentage);
                if (!panel.isTapped()) {
                    panel.setTappedAngle(1.5707963267948966 - panel.getTappedAngle());
                }
                panel.repaint();
            }

            @Override
            protected void onEnd() {
                panel.setTappedAngle(panel.isTapped() ? 1.5707963267948966 : 0.0);
            }
        }.run();
    }

    public static void moveCard(final int startX, final int startY, final int startWidth, final int endX, final int endY, final int endWidth, final CardPanel animationPanel, final CardPanel placeholder, final JLayeredPane layeredPane, int speed) {
        Animation.invokeLater(() -> {
            final int startHeight = Math.round((float)startWidth * 1.4f);
            final int endHeight = Math.round((float)endWidth * 1.4f);
            animationPanel.setCardBounds(startX, startY, startWidth, startHeight);
            animationPanel.setAnimationPanel(true);
            Container parent = animationPanel.getParent();
            if (parent != layeredPane) {
                layeredPane.add(animationPanel);
                layeredPane.setLayer(animationPanel, JLayeredPane.MODAL_LAYER);
            }
            new Animation(speed){

                @Override
                protected void update(float percentage) {
                    int currentX = startX + Math.round((float)(endX - startX) * percentage);
                    int currentY = startY + Math.round((float)(endY - startY) * percentage);
                    int currentWidth = startWidth + Math.round((float)(endWidth - startWidth) * percentage);
                    int currentHeight = startHeight + Math.round((float)(endHeight - startHeight) * percentage);
                    animationPanel.setCardBounds(currentX, currentY, currentWidth, currentHeight);
                }

                @Override
                protected void onEnd() {
                    EventQueue.invokeLater(() -> {
                        if (placeholder != null) {
                            placeholder.setDisplayEnabled(true);
                            placeholder.setCard(placeholder.getCard());
                        }
                        animationPanel.setVisible(false);
                        animationPanel.repaint();
                        layeredPane.remove(animationPanel);
                        if (animationPanel != CardPanel.getDragAnimationPanel()) {
                            animationPanel.dispose();
                        }
                    });
                }
            }.run();
        });
    }

    public static void moveCard(CardPanel placeholder) {
        Animation.invokeLater(() -> {
            if (placeholder != null) {
                placeholder.setDisplayEnabled(true);
                placeholder.setCard(placeholder.getCard());
            }
        });
    }

    private static final class FrameTimer {
        private static final int SAMPLES = 6;
        private static final long MAX_FRAME = 100L;
        private long[] samples = new long[6];
        private int sampleIndex;

        public FrameTimer() {
            long currentTime = System.currentTimeMillis();
            for (int i = 5; i >= 0; --i) {
                this.samples[i] = currentTime - (long)(6 - i) * 30L;
            }
        }

        public long getTimeSinceLastFrame() {
            long timeSinceLastSample;
            long currentTime = System.currentTimeMillis();
            int id = this.sampleIndex - 1;
            if (id < 0) {
                id += 6;
            }
            if ((timeSinceLastSample = currentTime - this.samples[id]) > 100L) {
                long diff = timeSinceLastSample - 100L;
                int i = 0;
                while (i < 6) {
                    int n = i++;
                    this.samples[n] = this.samples[n] + diff;
                }
            }
            long timeSinceOldestSample = currentTime - this.samples[this.sampleIndex];
            this.samples[this.sampleIndex] = currentTime;
            this.sampleIndex = (this.sampleIndex + 1) % 6;
            return timeSinceOldestSample / 6L;
        }
    }
}

