/*
 * Decompiled with CFR 0.152.
 */
package forge.view.arcane;

import forge.gui.GuiBase;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class ScaledImagePanel
extends JPanel {
    private static final long serialVersionUID = -5691107238620895385L;
    private volatile BufferedImage srcImage;

    public ScaledImagePanel() {
        super(false);
        this.setOpaque(false);
    }

    public final void setImage(BufferedImage srcImage) {
        this.srcImage = srcImage;
    }

    public final void clearImage() {
        this.setImage(null);
        this.repaint();
    }

    public final boolean hasImage() {
        return this.getSrcImage() != null;
    }

    @Override
    public final void paint(Graphics g2) {
        Dimension sz = this.getSize();
        BufferedImage src = this.getSrcImage();
        if (src == null) {
            return;
        }
        BufferedImage img = this.getSrcImage();
        float screenScale = GuiBase.getInterface().getScreenScale();
        boolean needsScale = Math.round((float)img.getWidth() / screenScale) < sz.width;
        float scaleFactor = (float)img.getWidth() / screenScale / (float)sz.width;
        if (needsScale && ((double)scaleFactor < 0.95 || (double)scaleFactor > 1.05)) {
            float maxZoomX = (float)sz.width / ((float)img.getWidth() / screenScale);
            float maxZoomY = (float)sz.height / ((float)img.getHeight() / screenScale);
            float zoom = Math.min(maxZoomX, maxZoomY);
            int zoomedWidth = (int)((float)img.getWidth() / screenScale * zoom);
            int zoomedHeight = (int)((float)img.getHeight() / screenScale * zoom);
            int x = (sz.width - zoomedWidth) / 2;
            int y = (sz.height - zoomedHeight) / 2;
            g2.drawImage(img, x, y, x + zoomedWidth, y + zoomedHeight, 0, 0, img.getWidth(), img.getHeight(), null);
        } else {
            int x = Math.round((float)(sz.width / 2) - (float)img.getWidth() / screenScale / 2.0f);
            int y = Math.round((float)(sz.height / 2) - (float)img.getHeight() / screenScale / 2.0f);
            g2.drawImage(img, x, y, x + sz.width, y + sz.height, 0, 0, img.getWidth(), img.getHeight(), null);
        }
    }

    public BufferedImage getSrcImage() {
        return this.srcImage;
    }
}

