/*
 * Decompiled with CFR 0.152.
 */
package forge.view.arcane;

import com.google.common.collect.Lists;
import forge.game.card.CardView;
import forge.game.player.PlayerView;
import forge.game.zone.ZoneType;
import forge.gui.FThreads;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.match.CMatchUI;
import forge.toolbox.FScrollPane;
import forge.toolbox.MouseTriggerEvent;
import forge.util.collect.FCollectionView;
import forge.view.arcane.CardPanel;
import forge.view.arcane.CardPanelContainer;
import forge.view.arcane.util.Animation;
import forge.view.arcane.util.CardPanelMouseListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class PlayArea
extends CardPanelContainer
implements CardPanelMouseListener {
    private static final long serialVersionUID = 8333013579724492513L;
    private static final int GUTTER_Y = 5;
    private static final int GUTTER_X = 5;
    static final float EXTRA_CARD_SPACING_X = 0.04f;
    private static final float CARD_SPACING_Y = 0.06f;
    private static final float STACK_SPACING_X = 0.12f;
    private static final float STACK_SPACING_Y = 0.12f;
    private final int creatureStackMax = 4;
    private final int landStackMax = 5;
    private final int tokenStackMax = 5;
    private final int othersStackMax = 4;
    private final boolean mirror;
    private List<CardStackRow> rows = new ArrayList<CardStackRow>();
    private int cardWidth;
    private int cardHeight;
    private int playAreaWidth;
    private int playAreaHeight;
    private int extraCardSpacingX;
    private int cardSpacingX;
    private int cardSpacingY;
    private int stackSpacingX;
    private int stackSpacingY;
    private final PlayerView model;
    private final ZoneType zone;
    private boolean makeTokenRow = true;
    private boolean stackCreatures = false;

    public PlayArea(CMatchUI matchUI, FScrollPane scrollPane, boolean mirror, PlayerView player, ZoneType zone) {
        super(matchUI, scrollPane);
        this.setBackground(Color.white);
        this.mirror = mirror;
        this.model = player;
        this.zone = zone;
        this.makeTokenRow = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_TOKENS_IN_SEPARATE_ROW);
        this.stackCreatures = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_STACK_CREATURES);
    }

    private CardStackRow collectAllLands() {
        CardStackRow allLands = new CardStackRow();
        block0: for (CardPanel panel : this.getCardPanels()) {
            CardView card = panel.getCard();
            CardView.CardStateView state = card.getCurrentState();
            if (!state.isLand() || state.isCreature()) continue;
            int insertIndex = -1;
            int n = allLands.size();
            for (int i = 0; i < n; ++i) {
                block6: {
                    CardStack stack;
                    block8: {
                        block7: {
                            stack = (CardStack)allLands.get(i);
                            CardPanel firstPanel = (CardPanel)stack.get(0);
                            if (!firstPanel.getCard().getCurrentState().getName().equals(state.getName())) break block6;
                            if (!firstPanel.getAttachedPanels().isEmpty() || firstPanel.getCard().hasCardAttachments()) {
                                insertIndex = i;
                                break;
                            }
                            if (!panel.getAttachedPanels().isEmpty() || !panel.getCard().hasSameCounters(firstPanel.getCard()) || firstPanel.getCard().hasCardAttachments()) break block7;
                            int n2 = stack.size();
                            Objects.requireNonNull(this);
                            if (n2 != 5) break block8;
                        }
                        insertIndex = i + 1;
                        continue;
                    }
                    stack.add(0, panel);
                    continue block0;
                }
                if (insertIndex != -1) break;
            }
            CardStack stack = new CardStack();
            stack.add(panel);
            allLands.add(insertIndex == -1 ? allLands.size() : insertIndex, stack);
        }
        return allLands;
    }

    private CardStackRow collectAllTokens() {
        CardStackRow allTokens = new CardStackRow();
        block0: for (CardPanel panel : this.getCardPanels()) {
            CardView card = panel.getCard();
            CardView.CardStateView state = card.getCurrentState();
            if (!card.isToken()) continue;
            int insertIndex = -1;
            int n = allTokens.size();
            for (int i = 0; i < n; ++i) {
                CardStack stack = (CardStack)allTokens.get(i);
                CardPanel firstPanel = (CardPanel)stack.get(0);
                CardView firstCard = firstPanel.getCard();
                if (firstPanel.getCard().getCurrentState().getName().equals(state.getName())) {
                    if (!firstPanel.getAttachedPanels().isEmpty()) {
                        insertIndex = i;
                        break;
                    }
                    if (!(panel.getAttachedPanels().isEmpty() && card.hasSameCounters(firstPanel.getCard()) && card.isSick() == firstCard.isSick() && card.hasSamePT(firstCard) && card.getText().equals(firstCard.getText()) && stack.size() != 5)) {
                        insertIndex = i + 1;
                        continue;
                    }
                    stack.add(0, panel);
                    continue block0;
                }
                if (insertIndex != -1) break;
            }
            CardStack stack = new CardStack();
            stack.add(panel);
            allTokens.add(insertIndex == -1 ? allTokens.size() : insertIndex, stack);
        }
        return allTokens;
    }

    private CardStackRow collectAllCreatures() {
        CardStackRow allCreatures = new CardStackRow();
        block0: for (CardPanel panel : this.getCardPanels()) {
            CardView card = panel.getCard();
            CardView.CardStateView state = card.getCurrentState();
            if (!state.isCreature() || card.isToken()) continue;
            int insertIndex = -1;
            int n = allCreatures.size();
            for (int i = 0; i < n; ++i) {
                CardStack stack = (CardStack)allCreatures.get(i);
                CardPanel firstPanel = (CardPanel)stack.get(0);
                CardView firstCard = firstPanel.getCard();
                if (firstCard.getName().equals(card.getName())) {
                    if (!firstPanel.getAttachedPanels().isEmpty()) {
                        insertIndex = i;
                        break;
                    }
                    if (!panel.getAttachedPanels().isEmpty() || card.isCloned() || !card.hasSameCounters(firstCard) || card.isSick() != firstCard.isSick() || !card.hasSamePT(firstCard) || stack.size() == 4) {
                        insertIndex = i + 1;
                        continue;
                    }
                    stack.add(0, panel);
                    continue block0;
                }
                if (insertIndex != -1) break;
            }
            CardStack stack = new CardStack();
            stack.add(panel);
            allCreatures.add(insertIndex == -1 ? allCreatures.size() : insertIndex, stack);
        }
        return allCreatures;
    }

    @Override
    public final CardPanel addCard(CardView card) {
        CardPanel placeholder = new CardPanel(this.getMatchUI(), card);
        placeholder.setDisplayEnabled(false);
        this.getCardPanels().add(placeholder);
        this.add(placeholder);
        return placeholder;
    }

    @Override
    public final void doLayout() {
        int minCardWidth;
        Object collectedCreatures;
        Rectangle rect = this.getScrollPane().getVisibleRect();
        this.playAreaWidth = rect.width;
        this.playAreaHeight = rect.height;
        CardStackRow lands = this.collectAllLands();
        CardStackRow tokens = this.collectAllTokens();
        Object creatures = new CardStackRow(this.getCardPanels(), RowType.CreatureNonToken);
        CardStackRow others = new CardStackRow(this.getCardPanels(), RowType.Other);
        if (this.stackCreatures && !((ArrayList)(collectedCreatures = this.collectAllCreatures())).isEmpty()) {
            creatures = collectedCreatures;
        }
        if (!this.makeTokenRow) {
            for (CardStack s2 : tokens) {
                if (s2.isEmpty() || !((CardPanel)s2.get(0)).getCard().getCurrentState().isCreature()) continue;
                ((ArrayList)creatures).add(s2);
            }
            tokens.clear();
        }
        int maxCardWidth = this.getCardWidthMax();
        this.setCardWidth(maxCardWidth);
        int lastGoodCardWidth = minCardWidth = this.getCardWidthMin();
        int deltaCardWidth = (maxCardWidth - minCardWidth) / 2;
        List<CardStackRow> lastTemplate = null;
        while (deltaCardWidth > 0) {
            List<CardStackRow> template = this.tryArrangePilesOfWidth(lands, tokens, (CardStackRow)creatures, others);
            deltaCardWidth = (this.getCardWidth() - lastGoodCardWidth) / 2;
            if (template != null) {
                lastTemplate = template;
                lastGoodCardWidth = this.getCardWidth();
                this.setCardWidth(this.getCardWidth() + deltaCardWidth);
                if (lastGoodCardWidth != maxCardWidth) continue;
                break;
            }
            this.setCardWidth(this.getCardWidth() - deltaCardWidth);
        }
        this.setCardWidth(lastGoodCardWidth);
        if (null == lastTemplate) {
            lastTemplate = this.tryArrangePilesOfWidth(lands, tokens, (CardStackRow)creatures, others);
        }
        this.rows = lastTemplate;
        int y = 5;
        int maxRowWidth = 0;
        for (CardStackRow row : this.rows) {
            int rowBottom = 0;
            int x = 5;
            for (CardStack stack : row) {
                rowBottom = Math.max(rowBottom, y + stack.getHeight());
                x += stack.getWidth();
            }
            y = rowBottom;
            maxRowWidth = Math.max(maxRowWidth, x);
        }
        this.setPreferredSize(new Dimension(maxRowWidth - this.cardSpacingX, y - this.cardSpacingY));
        this.revalidate();
        this.positionAllCards(lastTemplate);
        this.repaint();
        super.doLayout();
    }

    private void positionAllCards(List<CardStackRow> template) {
        int x = 0;
        int y = 5;
        for (CardStackRow row : template) {
            int rowBottom = 0;
            x = 5;
            int stackCount = row.size();
            for (int stackIndex = 0; stackIndex < stackCount; ++stackIndex) {
                CardStack stack = (CardStack)row.get(stackIndex);
                if (RowType.Other.isGoodFor(((CardPanel)stack.get(0)).getCard().getCurrentState())) {
                    x = this.playAreaWidth - 5 + this.extraCardSpacingX;
                    int n = row.size();
                    for (int i = stackIndex; i < n; ++i) {
                        CardStack r = (CardStack)row.get(i);
                        x -= r.getWidth();
                    }
                }
                int panelCount = stack.size();
                for (int panelIndex = 0; panelIndex < panelCount; ++panelIndex) {
                    CardPanel panel = (CardPanel)stack.get(panelIndex);
                    int stackPosition = panelCount - panelIndex - 1;
                    this.setComponentZOrder(panel, panelIndex);
                    int panelX = x + stackPosition * this.stackSpacingX;
                    int panelY = y + stackPosition * this.stackSpacingY;
                    panel.setCardBounds(panelX, panelY, this.getCardWidth(), this.cardHeight);
                }
                rowBottom = Math.max(rowBottom, y + stack.getHeight());
                x += stack.getWidth();
            }
            y = rowBottom;
        }
    }

    private List<CardStackRow> tryArrangePilesOfWidth(CardStackRow lands, CardStackRow tokens, CardStackRow creatures, CardStackRow others) {
        boolean creaturesFit;
        boolean tokensFit;
        int afterFirstRow;
        boolean landsFit;
        ArrayList<CardStackRow> template = new ArrayList<CardStackRow>();
        if (this.mirror) {
            landsFit = this.planRow(lands, template, -1);
            afterFirstRow = template.size();
            tokensFit = this.planRow(tokens, template, afterFirstRow);
            creaturesFit = this.planRow(creatures, template, template.size());
        } else {
            creaturesFit = this.planRow(creatures, template, -1);
            afterFirstRow = template.size();
            tokensFit = this.planRow(tokens, template, afterFirstRow);
            landsFit = this.planRow(lands, template, template.size());
        }
        if (!(landsFit && creaturesFit && tokensFit)) {
            return null;
        }
        int cntOthers = others.size();
        ArrayList<CardStackRow> templateCopy = new ArrayList<CardStackRow>(template.size());
        for (CardStackRow row : template) {
            templateCopy.add((CardStackRow)row.clone());
        }
        int nextOther = 0;
        for (CardStackRow row : template) {
            if ((nextOther = this.planOthersRow(others, nextOther, template, row)) != cntOthers) continue;
            return template;
        }
        template = templateCopy;
        if (this.planRow(others, template, afterFirstRow)) {
            return template;
        }
        return null;
    }

    private boolean planRow(CardStackRow sourceRow, List<CardStackRow> template, int insertIndex) {
        boolean isMinimalSize = this.getCardWidth() == this.getCardWidthMin();
        CardStackRow currentRow = new CardStackRow();
        for (CardStack stack : sourceRow) {
            int stackWidth;
            int rowWidth = currentRow.getWidth();
            if (rowWidth + (stackWidth = stack.getWidth()) > this.playAreaWidth && !currentRow.isEmpty()) {
                if (!(rowWidth <= this.playAreaWidth && this.getRowsHeight(template) + sourceRow.getHeight() <= this.playAreaHeight || isMinimalSize)) {
                    return false;
                }
                if (insertIndex == -1) {
                    template.add(currentRow);
                } else {
                    template.add(insertIndex, currentRow);
                }
                currentRow = new CardStackRow();
            }
            currentRow.add(stack);
        }
        if (!currentRow.isEmpty()) {
            int rowWidth = currentRow.getWidth();
            if (isMinimalSize || rowWidth <= this.playAreaWidth && this.getRowsHeight(template) + sourceRow.getHeight() <= this.playAreaHeight) {
                if (insertIndex == -1) {
                    template.add(currentRow);
                } else {
                    template.add(insertIndex, currentRow);
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private int planOthersRow(List<CardStack> sourceRow, int firstPile, List<CardStackRow> template, CardStackRow rowToFill) {
        int rowWidth = rowToFill.getWidth();
        for (int i = firstPile; i < sourceRow.size(); ++i) {
            int newAllRowsHeight;
            CardStack stack = sourceRow.get(i);
            if ((rowWidth += stack.getWidth()) > this.playAreaWidth) {
                return i;
            }
            if (stack.getHeight() > rowToFill.getHeight() && (newAllRowsHeight = this.getRowsHeight(template) - rowToFill.getHeight() + stack.getHeight()) > this.playAreaHeight) {
                return i;
            }
            rowToFill.add(stack);
        }
        return sourceRow.size();
    }

    private int getRowsHeight(List<CardStackRow> rows) {
        int height = 0;
        for (CardStackRow row : rows) {
            height += row.getHeight();
        }
        return height - this.cardSpacingY + 10;
    }

    @Override
    public final CardPanel getCardPanel(int x, int y) {
        for (CardStackRow row : this.rows) {
            for (CardStack stack : row) {
                for (CardPanel panel : stack) {
                    int panelHeight;
                    int panelWidth;
                    int panelX = panel.getCardX();
                    int panelY = panel.getCardY();
                    if (panel.isTapped()) {
                        panelWidth = panel.getCardHeight();
                        panelHeight = panel.getCardWidth();
                        panelY += panelWidth - panelHeight;
                    } else {
                        panelWidth = panel.getCardWidth();
                        panelHeight = panel.getCardHeight();
                    }
                    if (x <= panelX || x >= panelX + panelWidth || y <= panelY || y >= panelY + panelHeight) continue;
                    if (!panel.isDisplayEnabled()) {
                        return null;
                    }
                    return panel;
                }
            }
        }
        return null;
    }

    @Override
    public final void mouseOver(CardPanel panel, MouseEvent evt) {
        this.getMatchUI().setCard(panel.getCard(), evt.isShiftDown());
        super.mouseOver(panel, evt);
    }

    @Override
    public final void mouseLeftClicked(CardPanel panel, MouseEvent evt) {
        this.selectCard(panel, new MouseTriggerEvent(evt), evt.isShiftDown());
        if (panel.getTappedAngle() != 0.0 && panel.getTappedAngle() != 1.5707963267948966) {
            return;
        }
        super.mouseLeftClicked(panel, evt);
    }

    @Override
    public final void mouseRightClicked(CardPanel panel, MouseEvent evt) {
        this.selectCard(panel, new MouseTriggerEvent(evt), evt.isShiftDown());
        super.mouseRightClicked(panel, evt);
    }

    private boolean selectCard(CardPanel panel, MouseTriggerEvent triggerEvent, boolean selectEntireStack) {
        ArrayList<CardView> otherCardViewsToSelect = null;
        List<CardPanel> stack = panel.getStack();
        if (selectEntireStack && stack != null) {
            for (CardPanel p : stack) {
                if (p == panel || p.getCard() == null || p.getStack() != stack) continue;
                if (otherCardViewsToSelect == null) {
                    otherCardViewsToSelect = new ArrayList<CardView>();
                }
                otherCardViewsToSelect.add(p.getCard());
            }
        }
        if (this.getMatchUI().getGameController().selectCard(panel.getCard(), otherCardViewsToSelect, triggerEvent)) {
            return true;
        }
        if (stack != null) {
            for (int i = stack.indexOf(panel) + 1; i < stack.size(); ++i) {
                CardPanel p;
                p = stack.get(i);
                if (p.getStack() != stack || !this.selectCard(stack.get(i), triggerEvent, selectEntireStack)) continue;
                return true;
            }
        }
        for (CardPanel p : panel.getAttachedPanels()) {
            if (p.getStack() == stack || !this.selectCard(p, triggerEvent, selectEntireStack)) continue;
            return true;
        }
        this.getMatchUI().flashIncorrectAction();
        return false;
    }

    public void update() {
        FThreads.assertExecutedByEdt(true);
        this.recalculateCardPanels(this.model, this.zone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculateCardPanels(PlayerView model, ZoneType zone) {
        ArrayList<Object> modelCopy;
        PlayerView playerView = model;
        synchronized (playerView) {
            FCollectionView<CardView> cards = model.getCards(zone);
            modelCopy = cards != null ? Lists.newArrayList(cards) : Lists.newArrayList();
        }
        ArrayList<CardView> oldCards = Lists.newArrayList();
        for (CardPanel cpa : this.getCardPanels()) {
            oldCards.add(cpa.getCard());
        }
        ArrayList<CardView> toDelete = Lists.newArrayList(oldCards);
        LinkedList<CardView> notToDelete = Lists.newLinkedList();
        for (CardView cardView : modelCopy) {
            for (CardView c2 : toDelete) {
                if (cardView.getId() != c2.getId()) continue;
                notToDelete.add(c2);
            }
        }
        toDelete.removeAll(notToDelete);
        if (toDelete.size() == this.getCardPanels().size()) {
            this.clear(false);
        } else {
            for (CardView cardView : toDelete) {
                this.removeCardPanel(this.getCardPanel(cardView.getId()), false);
            }
        }
        ArrayList<Object> toAdd = new ArrayList<Object>(modelCopy);
        toAdd.removeAll(oldCards);
        ArrayList<CardPanel> arrayList = new ArrayList<CardPanel>();
        for (Object card : toAdd) {
            CardPanel cardPanel = new CardPanel(this.getMatchUI(), (CardView)card);
            cardPanel.setDisplayEnabled(false);
            this.getCardPanels().add(cardPanel);
            this.add(cardPanel);
            arrayList.add(cardPanel);
        }
        boolean needLayoutRefresh = !arrayList.isEmpty() || !toDelete.isEmpty();
        for (CardView cardView : modelCopy) {
            if (!this.doUpdateCard(cardView, true)) continue;
            needLayoutRefresh = true;
        }
        if (needLayoutRefresh) {
            this.doLayout();
        }
        this.invalidate();
        if (!arrayList.isEmpty()) {
            int i = arrayList.size();
            for (CardPanel toPanel : arrayList) {
                if (--i == 0) {
                    this.scrollRectToVisible(new Rectangle(toPanel.getCardX(), toPanel.getCardY(), toPanel.getCardWidth(), toPanel.getCardHeight()));
                }
                Animation.moveCard(toPanel);
            }
        }
        this.repaint();
    }

    public boolean updateCard(CardView card, boolean fromRefresh) {
        FThreads.assertExecutedByEdt(true);
        boolean result = this.doUpdateCard(card, fromRefresh);
        this.repaint();
        return result;
    }

    private boolean doUpdateCard(CardView card, boolean fromRefresh) {
        CardPanel attachedToPanel;
        CardPanel toPanel = this.getCardPanel(card.getId());
        if (toPanel == null) {
            return false;
        }
        boolean needLayoutRefresh = false;
        if (card.isTapped()) {
            toPanel.setTapped(true);
            toPanel.setTappedAngle(1.5707963267948966);
        } else {
            toPanel.setTapped(false);
            toPanel.setTappedAngle(0.0);
        }
        toPanel.getAttachedPanels().clear();
        if (card.hasAnyCardAttachments()) {
            Iterable<CardView> enchants = card.getAllAttachedCards();
            for (CardView e : enchants) {
                CardPanel cardE = this.getCardPanel(e.getId());
                if (cardE == null) continue;
                if (cardE.getAttachedToPanel() != toPanel) {
                    cardE.setAttachedToPanel(toPanel);
                    needLayoutRefresh = true;
                }
                toPanel.getAttachedPanels().add(cardE);
            }
        }
        if (card.getAttachedTo() != null) {
            if (card != card.getAttachedTo().getAttachedTo()) {
                attachedToPanel = this.getCardPanel(card.getAttachedTo().getId());
            } else {
                toPanel.getAttachedPanels().remove(this.getCardPanel(card.getAttachedTo().getId()));
                CardPanel panel = this.getCardPanel(card.getAttachedTo().getId());
                if (panel != null) {
                    panel.setAttachedToPanel(null);
                }
                attachedToPanel = null;
            }
        } else {
            attachedToPanel = null;
        }
        if (toPanel.getAttachedToPanel() != attachedToPanel) {
            toPanel.setAttachedToPanel(attachedToPanel);
            needLayoutRefresh = true;
        }
        toPanel.setCard(card);
        if (fromRefresh) {
            toPanel.updatePTOverlay();
        }
        if (needLayoutRefresh && !fromRefresh) {
            this.doLayout();
        }
        return needLayoutRefresh;
    }

    private int getCardWidth() {
        return this.cardWidth;
    }

    private void setCardWidth(int cardWidth0) {
        this.cardWidth = cardWidth0;
        this.cardHeight = Math.round((float)this.cardWidth * 1.4f);
        this.extraCardSpacingX = Math.round((float)this.cardWidth * 0.04f);
        this.cardSpacingX = this.cardHeight - this.cardWidth + this.extraCardSpacingX;
        this.cardSpacingY = Math.round((float)this.cardHeight * 0.06f);
        this.stackSpacingX = Math.round((float)this.cardWidth * 0.12f);
        this.stackSpacingY = Math.round((float)this.cardHeight * 0.12f);
    }

    private class CardStack
    extends ArrayList<CardPanel> {
        private static final long serialVersionUID = 3863135156832080368L;

        public CardStack() {
            super(8);
        }

        @Override
        public boolean add(CardPanel panel) {
            if (panel.getCard() == null) {
                return false;
            }
            if (super.add(panel)) {
                panel.setStack(this);
                this.addAttachedPanels(panel);
                return true;
            }
            return false;
        }

        @Override
        public void add(int index, CardPanel panel) {
            super.add(index, panel);
            panel.setStack(this);
        }

        private void addAttachedPanels(CardPanel panel) {
            for (CardPanel attachedPanel : panel.getAttachedPanels()) {
                if (panel.getCard() == null || !super.add(attachedPanel)) continue;
                this.addAttachedPanels(attachedPanel);
            }
        }

        private int getWidth() {
            return PlayArea.this.cardWidth + (this.size() - 1) * PlayArea.this.stackSpacingX + PlayArea.this.cardSpacingX;
        }

        private int getHeight() {
            return PlayArea.this.cardHeight + (this.size() - 1) * PlayArea.this.stackSpacingY + PlayArea.this.cardSpacingY;
        }
    }

    private class CardStackRow
    extends ArrayList<CardStack> {
        private static final long serialVersionUID = 716489891951011846L;

        public CardStackRow() {
            super(16);
        }

        public CardStackRow(List<CardPanel> cardPanels, RowType type) {
            this();
            if (type == RowType.Other) {
                this.addAllOthers(cardPanels, type);
            } else {
                this.addAll(cardPanels, type);
            }
        }

        private void addAll(List<CardPanel> cardPanels, RowType type) {
            for (CardPanel panel : cardPanels) {
                if (!type.isGoodFor(panel.getCard().getCurrentState()) || panel.getAttachedToPanel() != null) continue;
                CardStack stack = new CardStack();
                stack.add(panel);
                this.add(stack);
            }
        }

        private void addAllOthers(List<CardPanel> cardPanels, RowType type) {
            for (CardPanel panel : cardPanels) {
                if (!type.isGoodFor(panel.getCard().getCurrentState()) || panel.getAttachedToPanel() != null) continue;
                boolean stackable = false;
                for (CardStack s2 : this) {
                    CardView otherCard = ((CardPanel)s2.get(0)).getCard();
                    CardView.CardStateView otherState = otherCard.getCurrentState();
                    CardView thisCard = panel.getCard();
                    CardView.CardStateView thisState = thisCard.getCurrentState();
                    if (!otherState.getName().equals(thisState.getName()) || s2.size() >= 4 || !panel.getAttachedPanels().isEmpty() || !thisCard.hasSameCounters(otherCard) || thisCard.isSick() != otherCard.isSick() || thisCard.isCloned() != otherCard.isCloned()) continue;
                    s2.add(panel);
                    stackable = true;
                }
                if (stackable) continue;
                CardStack stack = new CardStack();
                stack.add(panel);
                this.add(stack);
            }
        }

        @Override
        public boolean addAll(Collection<? extends CardStack> c) {
            boolean changed = super.addAll(c);
            c.clear();
            return changed;
        }

        private int getWidth() {
            if (this.isEmpty()) {
                return 0;
            }
            int width = 0;
            for (CardStack stack : this) {
                width += stack.getWidth();
            }
            return width + 10 - PlayArea.this.extraCardSpacingX;
        }

        private int getHeight() {
            if (this.isEmpty()) {
                return 0;
            }
            int height = 0;
            for (CardStack stack : this) {
                height = Math.max(height, stack.getHeight());
            }
            return height;
        }
    }

    private static enum RowType {
        Land,
        Creature,
        CreatureNonToken,
        Other;


        public boolean isGoodFor(CardView.CardStateView stateView) {
            switch (this) {
                case Land: {
                    return stateView.isLand();
                }
                case Creature: {
                    return stateView.isCreature();
                }
                case CreatureNonToken: {
                    return stateView.isCreature() && !stateView.getCard().isToken();
                }
                case Other: {
                    return !stateView.isLand() && !stateView.isCreature();
                }
            }
            throw new RuntimeException("Unhandled type: " + (Object)((Object)this));
        }
    }
}

