/*
 * Decompiled with CFR 0.152.
 */
package forge.view.arcane;

import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.match.CMatchUI;
import forge.toolbox.FLabel;
import forge.toolbox.FSkin;
import forge.view.arcane.util.OutlinedLabel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class MiscCardPanel
extends FSkin.SkinnedPanel {
    private static final float ROT_CENTER_TO_TOP_CORNER = 1.0295631f;
    private static final float ROT_CENTER_TO_BOTTOM_CORNER = 0.70710677f;
    private final CMatchUI matchUI;
    private final String label;
    private final FLabel image;
    private OutlinedLabel titleText;
    private int cardXOffset;
    private int cardYOffset;
    private int cardWidth;
    private int cardHeight;

    public MiscCardPanel(CMatchUI matchUI, String label, FSkin.SkinImage image) {
        this.matchUI = matchUI;
        this.label = label;
        this.image = new FLabel.Builder().icon(image).build();
        this.setBackground(Color.black);
        this.setOpaque(true);
        this.add(this.image);
        this.createCardNameOverlay();
    }

    public CMatchUI getMatchUI() {
        return this.matchUI;
    }

    private void createCardNameOverlay() {
        this.titleText = new OutlinedLabel();
        this.titleText.setFont(this.getFont().deriveFont(1, 13.0f));
        this.titleText.setForeground(Color.white);
        this.titleText.setGlow(Color.black);
        this.titleText.setWrap(true);
        this.titleText.setText(this.label);
        this.add(this.titleText);
    }

    @Override
    public final void paint(Graphics g2) {
        if (!this.isValid()) {
            super.validate();
        }
        super.paint(g2);
    }

    @Override
    public final void doLayout() {
        Point imgPos = new Point(this.cardXOffset, this.cardYOffset);
        Dimension imgSize = new Dimension(this.cardWidth, this.cardHeight);
        this.image.setLocation(imgPos);
        this.image.setSize(imgSize);
        this.displayCardNameOverlay(this.showCardNameOverlay(), imgSize, imgPos);
    }

    private void displayCardNameOverlay(boolean isVisible, Dimension imgSize, Point imgPos) {
        if (isVisible) {
            int titleX = Math.round((float)imgSize.width * 0.05f);
            int titleY = Math.round((float)imgSize.height * 0.084375f) - 15;
            int titleH = Math.round((float)imgSize.height * 0.5625f);
            this.titleText.setBounds(imgPos.x + titleX, imgPos.y + titleY + 2, imgSize.width - 2 * titleX, titleH - titleY);
        }
        this.titleText.setVisible(isVisible);
    }

    @Override
    public final String toString() {
        return this.label;
    }

    public final void setCardBounds(int x, int y, int width, int height) {
        this.cardWidth = width;
        this.cardHeight = height;
        int rotCenterX = Math.round((float)width / 2.0f);
        int rotCenterY = height - rotCenterX;
        int rotCenterToTopCorner = Math.round((float)width * 1.0295631f);
        int rotCenterToBottomCorner = Math.round((float)width * 0.70710677f);
        int xOffset = rotCenterX - rotCenterToBottomCorner;
        int yOffset = rotCenterY - rotCenterToTopCorner;
        this.cardXOffset = -xOffset;
        this.cardYOffset = -yOffset;
        width = -xOffset + rotCenterX + rotCenterToTopCorner;
        height = -yOffset + rotCenterY + rotCenterToBottomCorner;
        this.setBounds(x + xOffset, y + yOffset, width, height);
    }

    @Override
    public final void repaint() {
        Rectangle b = this.getBounds();
        JRootPane rootPane = SwingUtilities.getRootPane(this);
        if (rootPane == null) {
            return;
        }
        Point p = SwingUtilities.convertPoint(this.getParent(), b.x, b.y, rootPane);
        rootPane.repaint(p.x, p.y, b.width, b.height);
    }

    private static boolean isPreferenceEnabled(ForgePreferences.FPref preferenceName) {
        return FModel.getPreferences().getPrefBoolean(preferenceName);
    }

    private boolean isShowingOverlays() {
        return MiscCardPanel.isPreferenceEnabled(ForgePreferences.FPref.UI_SHOW_CARD_OVERLAYS);
    }

    private boolean showCardNameOverlay() {
        return this.isShowingOverlays() && MiscCardPanel.isPreferenceEnabled(ForgePreferences.FPref.UI_OVERLAY_CARD_NAME);
    }

    public void repaintOverlays() {
        this.repaint();
        this.doLayout();
    }
}

