/*
 * Decompiled with CFR 0.152.
 */
package forge.view.arcane;

import forge.game.card.CardView;
import forge.screens.match.CMatchUI;
import forge.toolbox.FButton;
import forge.util.Localizer;
import forge.view.arcane.CardPanel;
import forge.view.arcane.FloatingCardArea;
import forge.view.arcane.util.CardPanelMouseAdapter;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

public class ListCardArea
extends FloatingCardArea {
    private static ArrayList<CardView> cardList;
    private static ArrayList<CardView> moveableCards;
    private static ListCardArea storedArea;
    private static FButton doneButton;
    private boolean toTop;
    private boolean toBottom;
    private boolean toAnywhere;

    private ListCardArea(CMatchUI matchUI) {
        super(matchUI);
        this.window.add((Component)this.getScrollPane(), "grow, push");
        this.window.setModal(true);
        this.getScrollPane().setViewportView(this);
        doneButton = new FButton(Localizer.getInstance().getMessage("lblDone", new Object[0]));
        doneButton.addActionListener(e -> this.window.setVisible(false));
        this.window.add((Component)doneButton, "South");
        this.setOpaque(false);
    }

    public static ListCardArea show(CMatchUI matchUI, String title0, Iterable<CardView> cardList0, Iterable<CardView> moveableCards0, boolean toTop0, boolean toBottom0, boolean toAnywhere0) {
        if (storedArea == null) {
            storedArea = new ListCardArea(matchUI);
        }
        cardList = new ArrayList();
        for (CardView cv : cardList0) {
            cardList.add(cv);
        }
        moveableCards = new ArrayList();
        for (CardView card : moveableCards0) {
            if (!cardList.contains(card)) continue;
            moveableCards.add(card);
        }
        ListCardArea.storedArea.title = title0;
        ListCardArea.storedArea.toTop = toTop0;
        ListCardArea.storedArea.toBottom = toBottom0;
        ListCardArea.storedArea.toAnywhere = toAnywhere0;
        storedArea.setDragEnabled(true);
        storedArea.setVertical(true);
        storedArea.showWindow();
        return storedArea;
    }

    public ListCardArea(CMatchUI matchUI, String title0, List<CardView> cardList0, List<CardView> moveableCards0, boolean toTop0, boolean toBottom0, boolean toAnywhere0) {
        super(matchUI);
        this.window.add((Component)this.getScrollPane(), "grow, push");
        this.getScrollPane().setViewportView(this);
        this.setOpaque(false);
        doneButton = new FButton(Localizer.getInstance().getMessage("lblDone", new Object[0]));
        doneButton.addActionListener(e -> this.window.setVisible(false));
        this.window.add((Component)doneButton, "South");
        cardList = new ArrayList<CardView>(cardList0);
        moveableCards = new ArrayList<CardView>(moveableCards0);
        this.title = title0;
        this.toTop = toTop0;
        this.toBottom = toBottom0;
        this.toAnywhere = toAnywhere0;
        this.setDragEnabled(true);
        this.setVertical(true);
        storedArea = this;
    }

    public List<CardView> getCards() {
        return cardList;
    }

    @Override
    protected void showWindow() {
        this.onShow();
        this.getWindow().setFocusableWindowState(true);
        this.getWindow().setVisible(true);
    }

    @Override
    protected void onShow() {
        super.onShow();
        if (!this.hasBeenShown) {
            this.addCardPanelMouseListener(new CardPanelMouseAdapter(){

                @Override
                public void mouseDragEnd(CardPanel dragPanel, MouseEvent evt) {
                    ListCardArea.this.dragEnd(dragPanel);
                }
            });
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    switch (e.getKeyCode()) {
                        case 10: {
                            doneButton.doClick();
                            break;
                        }
                    }
                }
            });
        }
    }

    private boolean validIndex(CardView card, int index) {
        if (this.toAnywhere) {
            return true;
        }
        int oldIndex = cardList.indexOf(card);
        boolean topMove = true;
        for (int i = 0; i < index + (oldIndex < index ? 1 : 0); ++i) {
            if (moveableCards.contains(cardList.get(i))) continue;
            topMove = false;
            break;
        }
        if (this.toTop && topMove) {
            return true;
        }
        boolean bottomMove = true;
        for (int i = index + 1 - (oldIndex > index ? 1 : 0); i < cardList.size(); ++i) {
            if (moveableCards.contains(cardList.get(i))) continue;
            bottomMove = false;
            break;
        }
        return this.toBottom && bottomMove;
    }

    @Override
    protected boolean cardPanelDraggable(CardPanel panel) {
        return moveableCards.contains(panel.getCard());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dragEnd(CardPanel dragPanel) {
        int index;
        CardView dragCard = dragPanel.getCard();
        if (moveableCards.contains(dragCard) && this.validIndex(dragCard, index = this.getCardPanels().indexOf(dragPanel))) {
            ArrayList<CardView> arrayList = cardList;
            synchronized (arrayList) {
                cardList.remove(dragCard);
                cardList.add(index, dragCard);
            }
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void mouseLeftClicked(CardPanel panel, MouseEvent evt) {
        CardView clickCard = panel.getCard();
        if (moveableCards.contains(clickCard) && (this.toTop || this.toBottom)) {
            ArrayList<CardView> arrayList = cardList;
            synchronized (arrayList) {
                int position;
                cardList.remove(clickCard);
                if (this.toTop) {
                    position = 0;
                } else {
                    for (position = cardList.size(); position > 0 && moveableCards.contains(cardList.get(position - 1)); --position) {
                    }
                }
                cardList.add(position, clickCard);
            }
            this.refresh();
        }
        super.mouseLeftClicked(panel, evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void mouseRightClicked(CardPanel panel, MouseEvent evt) {
        CardView clickCard = panel.getCard();
        if (moveableCards.contains(clickCard) && (this.toTop || this.toBottom)) {
            ArrayList<CardView> arrayList = cardList;
            synchronized (arrayList) {
                int position;
                cardList.remove(clickCard);
                if (this.toBottom) {
                    position = cardList.size();
                } else {
                    for (position = 0; position < cardList.size() && moveableCards.contains(cardList.get(position)); ++position) {
                    }
                }
                cardList.add(position, clickCard);
            }
            this.refresh();
        }
        super.mouseRightClicked(panel, evt);
    }
}

