/*
 * Decompiled with CFR 0.152.
 */
package forge.view.arcane;

import forge.game.card.CardView;
import forge.game.player.PlayerView;
import forge.game.zone.ZoneType;
import forge.gui.FThreads;
import forge.localinstance.properties.ForgePreferences;
import forge.localinstance.skin.FSkinProp;
import forge.screens.match.CMatchUI;
import forge.toolbox.FMouseAdapter;
import forge.toolbox.FScrollPane;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import forge.util.collect.FCollection;
import forge.util.collect.FCollectionView;
import forge.view.arcane.CardPanel;
import forge.view.arcane.FloatingCardArea;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class FloatingZone
extends FloatingCardArea {
    private static final long serialVersionUID = 1927906492186378596L;
    private static final Map<Integer, FloatingZone> floatingAreas = new HashMap<Integer, FloatingZone>();
    private final ZoneType zone;
    private PlayerView player;
    protected boolean sortedByName = false;
    protected FCollection<CardView> cardList;
    private final Comparator<CardView> comp = (lhs, rhs) -> {
        if (!this.getMatchUI().mayView((CardView)lhs)) {
            return this.getMatchUI().mayView((CardView)rhs) ? 1 : 0;
        }
        if (!this.getMatchUI().mayView((CardView)rhs)) {
            return -1;
        }
        return lhs.getName().compareTo(rhs.getName());
    };

    private static int getKey(PlayerView player, ZoneType zone) {
        return 40 * player.getId() + zone.hashCode();
    }

    public static void showOrHide(CMatchUI matchUI, PlayerView player, ZoneType zone) {
        FloatingZone cardArea = FloatingZone._init(matchUI, player, zone);
        cardArea.showOrHideWindow();
    }

    public static boolean show(CMatchUI matchUI, PlayerView player, ZoneType zone) {
        FloatingZone cardArea = FloatingZone._init(matchUI, player, zone);
        if (cardArea.isVisible()) {
            return false;
        }
        FThreads.invokeInEdtNowOrLater(cardArea::showWindow);
        return true;
    }

    public static boolean hide(CMatchUI matchUI, PlayerView player, ZoneType zone) {
        FloatingZone cardArea = FloatingZone._init(matchUI, player, zone);
        if (!cardArea.isVisible()) {
            return false;
        }
        FThreads.invokeInEdtNowOrLater(cardArea::hideWindow);
        return true;
    }

    private static FloatingZone _init(CMatchUI matchUI, PlayerView player, ZoneType zone) {
        int key = FloatingZone.getKey(player, zone);
        FloatingZone cardArea = floatingAreas.get(key);
        if (cardArea == null || cardArea.getMatchUI() != matchUI) {
            cardArea = new FloatingZone(matchUI, player, zone);
            floatingAreas.put(key, cardArea);
        } else {
            cardArea.setPlayer(player);
        }
        return cardArea;
    }

    public static CardPanel getCardPanel(CMatchUI matchUI, CardView card) {
        FloatingZone window = FloatingZone._init(matchUI, card.getController(), card.getZone());
        return window.getCardPanel(card.getId());
    }

    public static void refresh(PlayerView player, ZoneType zone) {
        FloatingZone cardArea = floatingAreas.get(FloatingZone.getKey(player, zone));
        if (cardArea != null) {
            cardArea.setPlayer(player);
            cardArea.refresh();
        }
        switch (zone) {
            case Graveyard: 
            case Library: 
            case Exile: {
                FloatingZone.refresh(player, ZoneType.Flashback);
                break;
            }
        }
    }

    public static void closeAll() {
        for (FloatingZone cardArea : floatingAreas.values()) {
            cardArea.window.setVisible(false);
        }
        floatingAreas.clear();
    }

    public static void refreshAll() {
        for (FloatingZone cardArea : floatingAreas.values()) {
            cardArea.refresh();
        }
    }

    @Override
    protected Iterable<CardView> getCards() {
        FCollectionView<CardView> zoneCards = this.player.getCards(this.zone);
        if (zoneCards != null) {
            this.cardList = new FCollection<CardView>(zoneCards);
            if (this.sortedByName) {
                this.cardList.sort(this.comp);
            }
            return this.cardList;
        }
        return null;
    }

    private FloatingZone(CMatchUI matchUI, PlayerView player0, ZoneType zone0) {
        super(matchUI, new FScrollPane(false, 20, 31));
        this.window.add((Component)this.getScrollPane(), "grow, push");
        this.window.setDefaultCloseOperation(2);
        this.getScrollPane().setViewportView(this);
        this.setOpaque(false);
        switch (zone0) {
            case Exile: {
                this.window.setIconImage(FSkin.getImage(FSkinProp.IMG_ZONE_EXILE));
                break;
            }
            case Graveyard: {
                this.window.setIconImage(FSkin.getImage(FSkinProp.IMG_ZONE_GRAVEYARD));
                break;
            }
            case Hand: {
                this.window.setIconImage(FSkin.getImage(FSkinProp.IMG_ZONE_HAND));
                break;
            }
            case Library: {
                this.window.setIconImage(FSkin.getImage(FSkinProp.IMG_ZONE_LIBRARY));
                break;
            }
            case Flashback: {
                this.window.setIconImage(FSkin.getImage(FSkinProp.IMG_ZONE_FLASHBACK));
                break;
            }
            case Command: {
                this.window.setIconImage(FSkin.getImage(FSkinProp.IMG_PLANESWALKER));
                break;
            }
            case Ante: {
                this.window.setIconImage(FSkin.getImage(FSkinProp.IMG_ZONE_ANTE));
                break;
            }
            case Sideboard: {
                this.window.setIconImage(FSkin.getImage(FSkinProp.IMG_ZONE_SIDEBOARD));
                break;
            }
            default: {
                this.locPref = null;
            }
        }
        this.zone = zone0;
        this.setPlayer(player0);
        this.setVertical(true);
    }

    private void toggleSorted() {
        this.sortedByName = !this.sortedByName;
        this.setTitle();
        this.refresh();
        this.getWindow().repaint();
    }

    @Override
    protected void onShow() {
        super.onShow();
        if (!this.hasBeenShown) {
            this.getWindow().getTitleBar().addMouseListener(new FMouseAdapter(){

                @Override
                public void onRightClick(MouseEvent e) {
                    FloatingZone.this.toggleSorted();
                }
            });
        }
    }

    private void setTitle() {
        String sort_detail = this.sortedByName ? Localizer.getInstance().getMessage("lblRightClickToUnSort", new Object[0]) : Localizer.getInstance().getMessage("lblRightClickToSort", new Object[0]);
        this.title = Localizer.getInstance().getMessage("lblPlayerZoneNCardSortStatus", this.player.getName(), this.zone.getTranslatedName(), "%d", sort_detail);
    }

    private void setPlayer(PlayerView player0) {
        if (this.player == player0) {
            return;
        }
        this.player = player0;
        this.setTitle();
        boolean isAi = player0.isAI();
        switch (this.zone) {
            case Exile: {
                this.locPref = isAi ? ForgePreferences.FPref.ZONE_LOC_AI_EXILE : ForgePreferences.FPref.ZONE_LOC_HUMAN_EXILE;
                break;
            }
            case Graveyard: {
                this.locPref = isAi ? ForgePreferences.FPref.ZONE_LOC_AI_GRAVEYARD : ForgePreferences.FPref.ZONE_LOC_HUMAN_GRAVEYARD;
                break;
            }
            case Hand: {
                this.locPref = isAi ? ForgePreferences.FPref.ZONE_LOC_AI_HAND : ForgePreferences.FPref.ZONE_LOC_HUMAN_HAND;
                break;
            }
            case Library: {
                this.locPref = isAi ? ForgePreferences.FPref.ZONE_LOC_AI_LIBRARY : ForgePreferences.FPref.ZONE_LOC_HUMAN_LIBRARY;
                break;
            }
            case Flashback: {
                this.locPref = isAi ? ForgePreferences.FPref.ZONE_LOC_AI_FLASHBACK : ForgePreferences.FPref.ZONE_LOC_HUMAN_FLASHBACK;
                break;
            }
            case Command: {
                this.locPref = isAi ? ForgePreferences.FPref.ZONE_LOC_AI_COMMAND : ForgePreferences.FPref.ZONE_LOC_HUMAN_COMMAND;
                break;
            }
            case Ante: {
                this.locPref = isAi ? ForgePreferences.FPref.ZONE_LOC_AI_ANTE : ForgePreferences.FPref.ZONE_LOC_HUMAN_ANTE;
                break;
            }
            case Sideboard: {
                this.locPref = isAi ? ForgePreferences.FPref.ZONE_LOC_AI_SIDEBOARD : ForgePreferences.FPref.ZONE_LOC_HUMAN_SIDEBOARD;
                break;
            }
            default: {
                this.locPref = null;
            }
        }
    }
}

