/*
 * Decompiled with CFR 0.152.
 */
package forge.view.arcane;

import forge.Singletons;
import forge.game.card.CardView;
import forge.gui.framework.SDisplayUtil;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.match.CMatchUI;
import forge.toolbox.FMouseAdapter;
import forge.toolbox.FScrollPane;
import forge.toolbox.MouseTriggerEvent;
import forge.view.FDialog;
import forge.view.FFrame;
import forge.view.arcane.CardArea;
import forge.view.arcane.CardPanel;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Timer;

public abstract class FloatingCardArea
extends CardArea {
    protected static final String COORD_DELIM = ",";
    protected static final ForgePreferences prefs = FModel.getPreferences();
    protected String title;
    protected ForgePreferences.FPref locPref;
    protected boolean hasBeenShown;
    protected boolean locLoaded;
    protected final FDialog window = new FDialog(false, true, "0"){

        @Override
        public void setLocationRelativeTo(Component c) {
            if (FloatingCardArea.this.hasBeenShown || FloatingCardArea.this.locLoaded) {
                return;
            }
            super.setLocationRelativeTo(c);
        }

        @Override
        public void setVisible(boolean b0) {
            if (this.isVisible() == b0) {
                return;
            }
            if (!b0 && FloatingCardArea.this.hasBeenShown && FloatingCardArea.this.locPref != null) {
                prefs.setPref(FloatingCardArea.this.locPref, this.getX() + FloatingCardArea.COORD_DELIM + this.getY() + FloatingCardArea.COORD_DELIM + this.getWidth() + FloatingCardArea.COORD_DELIM + this.getHeight());
            }
            if (b0) {
                FloatingCardArea.this.doRefresh();
                FloatingCardArea.this.hasBeenShown = true;
            }
            super.setVisible(b0);
        }
    };
    protected final Timer layoutTimer = new Timer(250, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            FloatingCardArea.this.layoutTimer.stop();
            FloatingCardArea.this.finishDoLayout();
        }
    });

    protected abstract Iterable<CardView> getCards();

    protected FloatingCardArea(CMatchUI matchUI) {
        this(matchUI, new FScrollPane(false, 20, 31));
    }

    protected FloatingCardArea(CMatchUI matchUI, FScrollPane scrollPane) {
        super(matchUI, scrollPane);
    }

    protected void showWindow() {
        this.onShow();
        this.getWindow().setFocusableWindowState(false);
        this.getWindow().setVisible(true);
    }

    protected void hideWindow() {
        this.onShow();
        this.getWindow().setFocusableWindowState(false);
        this.getWindow().setVisible(false);
        this.getWindow().dispose();
    }

    protected void showOrHideWindow() {
        if (this.getWindow().isVisible()) {
            this.hideWindow();
        } else {
            this.showWindow();
        }
    }

    protected void onShow() {
        if (!this.hasBeenShown) {
            this.loadLocation();
            this.getWindow().getTitleBar().addMouseListener(new FMouseAdapter(){

                @Override
                public void onLeftDoubleClick(MouseEvent e) {
                    FloatingCardArea.this.getWindow().setVisible(false);
                }
            });
        }
    }

    @Override
    public boolean isVisible() {
        return this.window.isVisible();
    }

    protected FDialog getWindow() {
        return this.window;
    }

    protected void loadLocation() {
        String value;
        if (this.locPref != null && (value = prefs.getPref(this.locPref)).length() > 0) {
            String[] coords = value.split(COORD_DELIM);
            if (coords.length == 4) {
                try {
                    int x = Integer.parseInt(coords[0]);
                    int y = Integer.parseInt(coords[1]);
                    int w = Integer.parseInt(coords[2]);
                    int h2 = Integer.parseInt(coords[3]);
                    int centerX = x + w / 2;
                    int centerY = y + h2 / 2;
                    Rectangle screenBounds = SDisplayUtil.getScreenBoundsForPoint(new Point(centerX, centerY));
                    if (centerX < screenBounds.x) {
                        x = screenBounds.x;
                    } else if (centerX > screenBounds.x + screenBounds.width && (x = screenBounds.x + screenBounds.width - w) < screenBounds.x) {
                        x = screenBounds.x;
                    }
                    if (centerY < screenBounds.y) {
                        y = screenBounds.y;
                    } else if (centerY > screenBounds.y + screenBounds.height && (y = screenBounds.y + screenBounds.height - h2) < screenBounds.y) {
                        y = screenBounds.y;
                    }
                    this.getWindow().setBounds(x, y, w, h2);
                    this.locLoaded = true;
                    return;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            prefs.setPref(this.locPref, "");
            prefs.save();
        }
        FFrame mainFrame = Singletons.getView().getFrame();
        this.getWindow().setSize(mainFrame.getWidth() / 5, mainFrame.getHeight() / 2);
    }

    protected void refresh() {
        if (!this.getWindow().isVisible()) {
            return;
        }
        this.doRefresh();
    }

    protected void doRefresh() {
        ArrayList<CardPanel> cardPanels = new ArrayList<CardPanel>();
        Iterable<CardView> cards = this.getCards();
        if (cards != null) {
            for (CardView card : cards) {
                CardPanel cardPanel = this.getCardPanel(card.getId());
                if (cardPanel == null) {
                    cardPanel = new CardPanel(this.getMatchUI(), card);
                    cardPanel.setDisplayEnabled(true);
                } else {
                    cardPanel.setCard(card);
                }
                cardPanels.add(cardPanel);
            }
        }
        boolean hadCardPanels = this.getCardPanels().size() > 0;
        this.setCardPanels(cardPanels);
        this.getWindow().setTitle(String.format(this.title, cardPanels.size()));
    }

    @Override
    public void doLayout() {
        if (this.getWindow().isResizing()) {
            this.layoutTimer.restart();
        } else {
            this.finishDoLayout();
        }
    }

    protected void finishDoLayout() {
        super.doLayout();
    }

    @Override
    public final void mouseOver(CardPanel panel, MouseEvent evt) {
        this.getMatchUI().setCard(panel.getCard(), evt.isShiftDown());
        super.mouseOver(panel, evt);
    }

    @Override
    public void mouseLeftClicked(CardPanel panel, MouseEvent evt) {
        this.getMatchUI().getGameController().selectCard(panel.getCard(), null, new MouseTriggerEvent(evt));
        super.mouseLeftClicked(panel, evt);
    }

    @Override
    public void mouseRightClicked(CardPanel panel, MouseEvent evt) {
        this.getMatchUI().getGameController().selectCard(panel.getCard(), null, new MouseTriggerEvent(evt));
        super.mouseRightClicked(panel, evt);
    }
}

