/*
 * Decompiled with CFR 0.152.
 */
package forge.view.arcane;

import forge.game.card.CardView;
import forge.gui.FThreads;
import forge.screens.match.CMatchUI;
import forge.toolbox.FScrollPane;
import forge.toolbox.FSkin;
import forge.toolbox.special.CardZoomer;
import forge.view.arcane.CardPanel;
import forge.view.arcane.util.CardPanelMouseListener;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public abstract class CardPanelContainer
extends FSkin.SkinnedPanel {
    private static final long serialVersionUID = -6400018234895548306L;
    private static final int DRAG_SMUDGE = 10;
    private final List<CardPanel> cardPanels = new ArrayList<CardPanel>();
    private final CMatchUI matchUI;
    private final FScrollPane scrollPane;
    private int cardWidthMin = 50;
    private int cardWidthMax = 300;
    private CardPanel hoveredPanel;
    private CardPanel mouseDownPanel;
    private CardPanel mouseDragPanel;
    private final List<CardPanelMouseListener> listeners = new ArrayList<CardPanelMouseListener>(2);
    private int mouseDragOffsetX;
    private int mouseDragOffsetY;
    private int intialMouseDragX = -1;
    private int intialMouseDragY;
    private boolean dragEnabled;
    private boolean isDragged;
    private final List<LayoutEventListener> layoutListeners = new ArrayList<LayoutEventListener>(1);

    public CardPanelContainer(CMatchUI matchUI, FScrollPane scrollPane) {
        this.matchUI = matchUI;
        this.scrollPane = scrollPane;
        this.setOpaque(true);
        this.setupMouseListeners();
    }

    protected final CMatchUI getMatchUI() {
        return this.matchUI;
    }

    private void mouseWheelZoom(CardView card) {
        if (this.canZoom(card)) {
            CardZoomer.SINGLETON_INSTANCE.setCard(card.getCurrentState(), false);
            CardZoomer.SINGLETON_INSTANCE.doMouseWheelZoom();
        }
    }

    private void mouseButtonZoom(CardView card) {
        if (this.canZoom(card)) {
            CardZoomer.SINGLETON_INSTANCE.setCard(card.getCurrentState(), false);
            CardZoomer.SINGLETON_INSTANCE.doMouseButtonZoom();
        }
    }

    private boolean canZoom(CardView card) {
        return this.getMatchUI().mayView(card);
    }

    private void setupMouseListeners() {
        MouseMotionListener mml = this.setupMotionMouseListener();
        this.setupMouseListener(mml);
        this.setupMouseWheelListener();
    }

    private void setupMouseWheelListener() {
        this.addMouseWheelListener(e -> {
            CardPanel hitPanel = this.getCardPanel(e.getX(), e.getY());
            if (hitPanel != null && e.getWheelRotation() < 0) {
                this.mouseWheelZoom(hitPanel.getCard());
            }
        });
    }

    private void setupMouseListener(final MouseMotionListener mml) {
        this.addMouseListener(new MouseAdapter(){
            private final boolean[] buttonsDown = new boolean[4];

            @Override
            public void mousePressed(MouseEvent evt) {
                int button = evt.getButton();
                if (button < 1 || button > 3) {
                    return;
                }
                this.buttonsDown[button] = true;
                CardPanelContainer.this.mouseDownPanel = CardPanelContainer.this.getCardPanel(evt.getX(), evt.getY());
                if (CardPanelContainer.this.mouseDownPanel != null && CardPanelContainer.this.getMouseDragPanel() == null && (this.buttonsDown[2] || this.buttonsDown[1] && this.buttonsDown[3])) {
                    CardPanelContainer.this.mouseButtonZoom(CardPanelContainer.this.mouseDownPanel.getCard());
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                CardPanel panel;
                int button = evt.getButton();
                if (button < 1 || button > 3) {
                    return;
                }
                boolean zoomed = CardZoomer.SINGLETON_INSTANCE.isZoomerOpen();
                if (!zoomed && CardPanelContainer.this.dragEnabled) {
                    CardPanelContainer.this.intialMouseDragX = -1;
                    if (CardPanelContainer.this.getMouseDragPanel() != null) {
                        panel = CardPanelContainer.this.getMouseDragPanel();
                        CardPanelContainer.this.setMouseDragPanel(null);
                        CardPanelContainer.this.mouseDragEnd(panel, evt);
                    }
                }
                if (!this.buttonsDown[button]) {
                    return;
                }
                this.buttonsDown[button] = false;
                if (zoomed) {
                    if (!(this.buttonsDown[1] || this.buttonsDown[2] || this.buttonsDown[3])) {
                        CardZoomer.SINGLETON_INSTANCE.closeZoomer();
                    }
                    return;
                }
                panel = CardPanelContainer.this.getCardPanel(evt.getX(), evt.getY());
                if (panel != null && CardPanelContainer.this.mouseDownPanel == panel) {
                    if (SwingUtilities.isLeftMouseButton(evt)) {
                        CardPanelContainer.this.mouseLeftClicked(panel, evt);
                    } else if (SwingUtilities.isRightMouseButton(evt)) {
                        CardPanelContainer.this.mouseRightClicked(panel, evt);
                    }
                } else {
                    mml.mouseMoved(evt);
                }
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                CardPanelContainer.this.mouseOutPanel(evt);
            }
        });
    }

    protected boolean cardPanelDraggable(CardPanel panel) {
        return true;
    }

    private MouseMotionListener setupMotionMouseListener() {
        MouseMotionListener mml = new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                int y;
                if (CardZoomer.SINGLETON_INSTANCE.isZoomerOpen() || !SwingUtilities.isLeftMouseButton(evt)) {
                    return;
                }
                if (!CardPanelContainer.this.dragEnabled) {
                    CardPanelContainer.this.mouseOutPanel(evt);
                    return;
                }
                if (CardPanelContainer.this.getMouseDragPanel() != null) {
                    CardPanelContainer.this.mouseDragged(CardPanelContainer.this.getMouseDragPanel(), CardPanelContainer.this.mouseDragOffsetX, CardPanelContainer.this.mouseDragOffsetY, evt);
                    return;
                }
                int x = evt.getX();
                CardPanel panel = CardPanelContainer.this.getCardPanel(x, y = evt.getY());
                if (panel == null) {
                    return;
                }
                if (panel != CardPanelContainer.this.mouseDownPanel) {
                    return;
                }
                if (CardPanelContainer.this.cardPanelDraggable(panel)) {
                    if (CardPanelContainer.this.intialMouseDragX == -1) {
                        CardPanelContainer.this.intialMouseDragX = x;
                        CardPanelContainer.this.intialMouseDragY = y;
                        return;
                    }
                    if (Math.abs(x - CardPanelContainer.this.intialMouseDragX) < 10 && Math.abs(y - CardPanelContainer.this.intialMouseDragY) < 10) {
                        return;
                    }
                    CardPanelContainer.this.mouseDownPanel = null;
                    CardPanelContainer.this.setMouseDragPanel(panel);
                    CardPanelContainer.this.mouseDragOffsetX = panel.getX() - CardPanelContainer.this.intialMouseDragX;
                    CardPanelContainer.this.mouseDragOffsetY = panel.getY() - CardPanelContainer.this.intialMouseDragY;
                    CardPanelContainer.this.mouseDragStart(CardPanelContainer.this.getMouseDragPanel(), evt);
                }
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                CardPanel hitPanel = CardPanelContainer.this.getCardPanel(evt.getX(), evt.getY());
                if (CardPanelContainer.this.hoveredPanel == hitPanel) {
                    return;
                }
                if (CardPanelContainer.this.hoveredPanel != null) {
                    CardPanelContainer.this.mouseOutPanel(evt);
                }
                if (hitPanel != null) {
                    CardPanelContainer.this.matchUI.setCard(hitPanel.getCard());
                    CardPanelContainer.this.hoveredPanel = hitPanel;
                    CardPanelContainer.this.hoveredPanel.setSelected(true);
                    CardPanelContainer.this.mouseOver(hitPanel, evt);
                }
            }
        };
        this.addMouseMotionListener(mml);
        return mml;
    }

    private void mouseOutPanel(MouseEvent evt) {
        if (this.hoveredPanel == null) {
            return;
        }
        this.hoveredPanel.setSelected(false);
        this.mouseOut(this.hoveredPanel, evt);
        this.hoveredPanel = null;
    }

    protected abstract CardPanel getCardPanel(int var1, int var2);

    public CardPanel addCard(CardView card) {
        CardPanel placeholder = new CardPanel(this.matchUI, card);
        placeholder.setDisplayEnabled(false);
        this.getCardPanels().add(placeholder);
        this.add(placeholder);
        this.doLayout();
        this.scrollRectToVisible(new Rectangle(placeholder.getCardX(), placeholder.getCardY(), placeholder.getCardWidth(), placeholder.getCardHeight()));
        return placeholder;
    }

    public final CardPanel getCardPanel(int gameCardID) {
        for (CardPanel panel : this.getCardPanels()) {
            if (panel.getCard().getId() != gameCardID) continue;
            return panel;
        }
        return null;
    }

    public final void removeCardPanel(CardPanel fromPanel) {
        this.removeCardPanel(fromPanel, true);
    }

    public final void removeCardPanel(CardPanel fromPanel, boolean repaint) {
        FThreads.assertExecutedByEdt(true);
        if (this.getMouseDragPanel() != null) {
            CardPanel.getDragAnimationPanel().setVisible(false);
            CardPanel.getDragAnimationPanel().repaint();
            this.getCardPanels().remove(CardPanel.getDragAnimationPanel());
            this.remove(CardPanel.getDragAnimationPanel());
            this.setMouseDragPanel(null);
        }
        this.hoveredPanel = null;
        fromPanel.dispose();
        this.getCardPanels().remove(fromPanel);
        this.remove(fromPanel);
        if (repaint) {
            this.invalidate();
            this.repaint();
            this.doingLayout();
        }
    }

    public final void setCardPanels(List<CardPanel> cardPanels) {
        if (cardPanels.size() == 0) {
            this.clear();
            return;
        }
        for (CardPanel p : this.getCardPanels()) {
            if (cardPanels.contains(p)) continue;
            p.dispose();
        }
        this.getCardPanels().clear();
        this.removeAll();
        this.getCardPanels().addAll(cardPanels);
        for (CardPanel cardPanel : cardPanels) {
            this.add(cardPanel);
        }
        this.invalidate();
        this.getParent().validate();
        this.repaint();
    }

    public final void clear() {
        this.clear(true);
    }

    public final void clear(boolean repaint) {
        FThreads.assertExecutedByEdt(true);
        for (CardPanel p : this.getCardPanels()) {
            p.dispose();
        }
        this.getCardPanels().clear();
        this.removeAll();
        if (repaint) {
            this.setPreferredSize(new Dimension(0, 0));
            this.invalidate();
            this.getParent().validate();
            this.repaint();
        }
    }

    public final FScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public final int getCardWidthMin() {
        return this.cardWidthMin;
    }

    public final void setCardWidthMin(int cardWidthMin) {
        this.cardWidthMin = cardWidthMin;
    }

    public final int getCardWidthMax() {
        return this.cardWidthMax;
    }

    public final void setCardWidthMax(int cardWidthMax) {
        this.cardWidthMax = cardWidthMax;
    }

    public final boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public final void setDragEnabled(boolean dragEnabled) {
        this.dragEnabled = dragEnabled;
    }

    public final boolean isDragged() {
        return this.isDragged;
    }

    public final void setDragged(boolean isDragged) {
        this.isDragged = isDragged;
    }

    public final void addCardPanelMouseListener(CardPanelMouseListener listener) {
        this.listeners.add(listener);
    }

    public void mouseLeftClicked(CardPanel panel, MouseEvent evt) {
        for (CardPanelMouseListener listener : this.listeners) {
            listener.mouseLeftClicked(panel, evt);
        }
    }

    public void mouseRightClicked(CardPanel panel, MouseEvent evt) {
        for (CardPanelMouseListener listener : this.listeners) {
            listener.mouseRightClicked(panel, evt);
        }
    }

    public void mouseDragEnd(CardPanel dragPanel, MouseEvent evt) {
        for (CardPanelMouseListener listener : this.listeners) {
            listener.mouseDragEnd(dragPanel, evt);
        }
    }

    public void mouseDragged(CardPanel dragPanel, int dragOffsetX, int dragOffsetY, MouseEvent evt) {
        for (CardPanelMouseListener listener : this.listeners) {
            listener.mouseDragged(this.getMouseDragPanel(), this.mouseDragOffsetX, this.mouseDragOffsetY, evt);
        }
    }

    public void mouseDragStart(CardPanel dragPanel, MouseEvent evt) {
        for (CardPanelMouseListener listener : this.listeners) {
            listener.mouseDragStart(this.getMouseDragPanel(), evt);
        }
    }

    public final void mouseOut(CardPanel panel, MouseEvent evt) {
        for (CardPanelMouseListener listener : this.listeners) {
            listener.mouseOut(this.hoveredPanel, evt);
        }
    }

    public void mouseOver(CardPanel panel, MouseEvent evt) {
        for (CardPanelMouseListener listener : this.listeners) {
            listener.mouseOver(panel, evt);
        }
    }

    public final List<CardPanel> getCardPanels() {
        return this.cardPanels;
    }

    public CardPanel getMouseDragPanel() {
        return this.mouseDragPanel;
    }

    public void setMouseDragPanel(CardPanel mouseDragPanel0) {
        this.mouseDragPanel = mouseDragPanel0;
    }

    @Override
    public void doLayout() {
        this.doingLayout();
    }

    private void doingLayout() {
        if (!this.isDragged) {
            for (LayoutEventListener listener : this.layoutListeners) {
                listener.doingLayout();
            }
        }
    }

    public void addLayoutListener(LayoutEventListener listener) {
        this.layoutListeners.add(listener);
    }

    public static interface LayoutEventListener {
        public void doingLayout();
    }
}

