/*
 * Decompiled with CFR 0.152.
 */
package forge.view.arcane;

import forge.CachedCardImage;
import forge.StaticData;
import forge.card.CardEdition;
import forge.card.mana.ManaCost;
import forge.game.card.Card;
import forge.game.card.CardView;
import forge.game.card.CounterType;
import forge.game.keyword.Keyword;
import forge.game.zone.ZoneType;
import forge.gui.CardContainer;
import forge.gui.FThreads;
import forge.gui.GuiBase;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.match.CMatchUI;
import forge.toolbox.CardFaceSymbols;
import forge.toolbox.FSkin;
import forge.toolbox.IDisposable;
import forge.util.CardTranslation;
import forge.view.arcane.ScaledImagePanel;
import forge.view.arcane.util.OutlinedLabel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.font.TextAttribute;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class CardPanel
extends FSkin.SkinnedPanel
implements CardContainer,
IDisposable {
    private static final long serialVersionUID = 2361907095724263295L;
    public static final double TAPPED_ANGLE = 1.5707963267948966;
    public static final float ASPECT_RATIO = 1.4f;
    public static final float TARGET_ORIGIN_FACTOR_X = 0.25f;
    public static final float TARGET_ORIGIN_FACTOR_Y = 0.5f;
    private static CardPanel dragAnimationPanel;
    public static final float ROUNDED_CORNER_SIZE = 0.1f;
    public static final float SELECTED_BORDER_SIZE = 0.01f;
    public static final float BLACK_BORDER_SIZE = 0.03f;
    private static final float ROT_CENTER_TO_TOP_CORNER = 1.0295631f;
    private static final float ROT_CENTER_TO_BOTTOM_CORNER = 0.70710677f;
    private final CMatchUI matchUI;
    private CardView card;
    private CardPanel attachedToPanel;
    private List<CardPanel> attachedPanels = new ArrayList<CardPanel>();
    private List<CardPanel> stack;
    private boolean tapped;
    private double tappedAngle = 0.0;
    private ScaledImagePanel imagePanel;
    private OutlinedLabel titleText;
    private OutlinedLabel ptText;
    private OutlinedLabel damageText;
    private OutlinedLabel cardIdText;
    private boolean displayEnabled = true;
    private boolean isAnimationPanel;
    private int cardXOffset;
    private int cardYOffset;
    private int cardWidth;
    private int cardHeight;
    private boolean isSelected;
    private boolean hasFlash;
    private CachedCardImage cachedImage;
    private static Font smallCounterFont;
    private static Font largeCounterFont;

    public CardPanel(CMatchUI matchUI, CardView card0) {
        this.matchUI = matchUI;
        this.setBackground(Color.black);
        this.setOpaque(false);
        this.createCardNameOverlay();
        this.createPTOverlay();
        this.createCardIdOverlay();
        this.createScaleImagePanel();
        this.setCard(card0);
    }

    public CMatchUI getMatchUI() {
        return this.matchUI;
    }

    private void createScaleImagePanel() {
        this.imagePanel = new ScaledImagePanel();
        this.add(this.imagePanel);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                CardPanel.this.setCard(CardPanel.this.getCard());
            }

            @Override
            public void componentResized(ComponentEvent e) {
                CardPanel.this.setCard(CardPanel.this.getCard());
            }
        });
    }

    private void createCardNameOverlay() {
        this.titleText = new OutlinedLabel();
        this.titleText.setFont(this.getFont().deriveFont(1, 13.0f));
        this.titleText.setForeground(Color.white);
        this.titleText.setGlow(Color.black);
        this.titleText.setWrap(true);
        this.add(this.titleText);
    }

    private void createPTOverlay() {
        this.ptText = new OutlinedLabel();
        this.ptText.setFont(this.getFont().deriveFont(1, 13.0f));
        this.ptText.setForeground(Color.white);
        this.ptText.setGlow(Color.black);
        this.add(this.ptText);
        this.damageText = new OutlinedLabel();
        this.damageText.setFont(this.getFont().deriveFont(1, 15.0f));
        this.damageText.setForeground(new Color(160, 0, 0));
        this.damageText.setGlow(Color.white);
        this.add(this.damageText);
    }

    private void createCardIdOverlay() {
        this.cardIdText = new OutlinedLabel();
        this.cardIdText.setFont(this.getFont().deriveFont(1, 11.0f));
        this.cardIdText.setForeground(Color.LIGHT_GRAY);
        this.cardIdText.setGlow(Color.black);
        this.add(this.cardIdText);
    }

    private void updateImage() {
        FThreads.assertExecutedByEdt(true);
        if (this.card == null) {
            this.cachedImage = null;
            this.setImage(null);
            return;
        }
        float screenScale = GuiBase.getInterface().getScreenScale();
        int imageWidth = Math.round((float)this.imagePanel.getWidth() * screenScale);
        int imageHeight = Math.round((float)this.imagePanel.getHeight() * screenScale);
        this.cachedImage = new CachedCardImage(this.card, this.matchUI.getLocalPlayers(), imageWidth, imageHeight){

            @Override
            public void onImageFetched() {
                if (CardPanel.this.cachedImage != null) {
                    CardPanel.this.setImage(CardPanel.this.cachedImage.getImage());
                }
            }
        };
        this.setImage(this.cachedImage.getImage());
    }

    private void setImage(BufferedImage srcImage) {
        if (this.imagePanel == null || this.imagePanel.getSrcImage() == srcImage) {
            return;
        }
        this.imagePanel.setImage(srcImage);
        this.repaint();
    }

    public final boolean isDisplayEnabled() {
        return this.displayEnabled;
    }

    public final void setDisplayEnabled(boolean displayEnabled0) {
        this.displayEnabled = displayEnabled0;
    }

    public final void setAnimationPanel(boolean isAnimationPanel0) {
        this.isAnimationPanel = isAnimationPanel0;
    }

    public final boolean isSelected() {
        return this.isSelected;
    }

    public final void setSelected(boolean isSelected0) {
        this.isSelected = isSelected0;
        this.repaint();
    }

    @Override
    public final void paint(Graphics g2) {
        if (!this.displayEnabled) {
            return;
        }
        if (!this.isValid()) {
            super.validate();
        }
        Graphics2D g2d = (Graphics2D)g2;
        if (this.getTappedAngle() > 0.0) {
            g2d = (Graphics2D)g2d.create();
            float edgeOffset = (float)this.cardWidth / 2.0f;
            g2d.rotate(this.getTappedAngle(), (float)this.cardXOffset + edgeOffset, (float)(this.cardYOffset + this.cardHeight) - edgeOffset);
        }
        super.paint(g2d);
    }

    @Override
    protected final void paintComponent(Graphics g2) {
        int n;
        int offset;
        Graphics2D g2d = (Graphics2D)g2;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        boolean noBorderPref = !CardPanel.isPreferenceEnabled(ForgePreferences.FPref.UI_RENDER_BLACK_BORDERS);
        boolean cardImgHasAlpha = this.imagePanel != null && this.imagePanel.getSrcImage() != null && this.imagePanel.getSrcImage().getColorModel().hasAlpha();
        int cornerSize = noBorderPref && !cardImgHasAlpha ? 0 : Math.max(4, Math.round((float)this.cardWidth * 0.1f));
        int n2 = offset = this.isTapped() && (!noBorderPref || cardImgHasAlpha) ? 1 : 0;
        if (this.matchUI.isUsedToPay(this.getCard())) {
            g2d.setColor(Color.magenta);
            int n22 = Math.max(1, Math.round((float)(2 * this.cardWidth) * 0.01f));
            g2d.fillRoundRect(this.cardXOffset - n22, this.cardYOffset - n22 + offset, this.cardWidth + n22 * 2, this.cardHeight + n22 * 2, cornerSize + n22, cornerSize + n22);
        }
        if (this.isSelected) {
            g2d.setColor(Color.green);
            n = Math.max(1, Math.round((float)this.cardWidth * 0.01f));
            g2d.fillRoundRect(this.cardXOffset - n, this.cardYOffset - n + offset, this.cardWidth + n * 2, this.cardHeight + n * 2, cornerSize + n, cornerSize + n);
        } else if (this.hasFlash && this.getCard() != null && this.matchUI.mayView(this.getCard())) {
            g2d.setColor(Color.cyan);
            n = Math.max(1, Math.round((float)this.cardWidth * 0.01f));
            g2d.fillRoundRect(this.cardXOffset - n, this.cardYOffset - n + offset, this.cardWidth + n * 2, this.cardHeight + n * 2, cornerSize + n, cornerSize + n);
        }
        g2d.setColor(Color.black);
        g2d.fillRoundRect(this.cardXOffset, this.cardYOffset + offset, this.cardWidth, this.cardHeight, cornerSize, cornerSize);
        if (this.getCard() != null && this.matchUI.mayView(this.getCard())) {
            CardView.CardStateView state = this.getCard().getCurrentState();
            CardEdition ed = FModel.getMagicDb().getEditions().get(state.getSetCode());
            boolean colorIsSet = false;
            if (this.getCard().isImmutable()) {
                g2d.setColor(Color.ORANGE);
                colorIsSet = true;
            } else if (ed != null && state.getFoilIndex() == 0) {
                switch (ed.getBorderColor()) {
                    case WHITE: {
                        g2d.setColor(Color.WHITE);
                        colorIsSet = true;
                        break;
                    }
                    case GOLD: {
                        g2d.setColor(Color.ORANGE);
                        colorIsSet = true;
                        break;
                    }
                    case SILVER: {
                        g2d.setColor(Color.GRAY);
                        colorIsSet = true;
                    }
                }
            }
            if (colorIsSet) {
                boolean ins = true;
                g2d.fillRoundRect(this.cardXOffset + 1, this.cardYOffset + 1, this.cardWidth - 2, this.cardHeight - 2, cornerSize - 1, cornerSize - 1);
            }
        }
        if (this.matchUI.isSelectable(this.getCard())) {
            g2d.setColor(Color.WHITE);
            boolean ins = true;
            g2d.fillRoundRect(this.cardXOffset + 1, this.cardYOffset + 1, this.cardWidth - 2, this.cardHeight - 2, cornerSize - 1, cornerSize - 1);
        }
    }

    private void drawManaCost(Graphics g2, ManaCost cost, int deltaY) {
        int width = CardFaceSymbols.getWidth(cost);
        int height = CardFaceSymbols.getHeight();
        int counterOffset = this.card.getCounters() != null && !this.card.getCounters().isEmpty() ? 15 : 0;
        CardFaceSymbols.draw(g2, cost, this.cardXOffset + this.cardWidth / 2 - width / 2, deltaY + this.cardYOffset + this.cardHeight / 2 - height / 2 + counterOffset);
    }

    @Override
    protected final void paintChildren(Graphics g2) {
        boolean nonselectable;
        super.paintChildren(g2);
        if (this.isAnimationPanel || this.card == null) {
            return;
        }
        boolean canShow = this.matchUI.mayView(this.card);
        this.displayIconOverlay(g2, canShow);
        if (canShow) {
            CardPanel.drawFoilEffect(g2, this.card, this.cardXOffset, this.cardYOffset, this.cardWidth, this.cardHeight, Math.round((float)this.cardWidth * 0.03f));
        }
        boolean bl = nonselectable = this.matchUI.isSelecting() && !this.matchUI.isSelectable(this.getCard());
        if (nonselectable) {
            boolean noBorderPref = !CardPanel.isPreferenceEnabled(ForgePreferences.FPref.UI_RENDER_BLACK_BORDERS);
            boolean cardImgHasAlpha = this.imagePanel != null && this.imagePanel.getSrcImage() != null && this.imagePanel.getSrcImage().getColorModel().hasAlpha();
            int cornerSize = noBorderPref && !cardImgHasAlpha ? 0 : Math.max(4, Math.round((float)this.cardWidth * 0.1f));
            int offset = this.isTapped() && (!noBorderPref || cardImgHasAlpha) ? 1 : 0;
            g2.setColor(new Color(0.0f, 0.0f, 0.0f, 0.6f));
            g2.fillRoundRect(this.cardXOffset, this.cardYOffset + offset, this.cardWidth, this.cardHeight, cornerSize, cornerSize);
        }
    }

    public static void drawFoilEffect(Graphics g2, CardView card2, int x, int y, int width, int height, int borderSize) {
        int foil;
        if (CardPanel.isPreferenceEnabled(ForgePreferences.FPref.UI_OVERLAY_FOIL_EFFECT) && (foil = card2.getCurrentState().getFoilIndex()) > 0) {
            CardFaceSymbols.drawOther(g2, String.format("foil%02d", foil), x + borderSize, y + borderSize, width - 2 * borderSize, height - 2 * borderSize);
        }
    }

    @Override
    public final void doLayout() {
        int borderSize = this.calculateBorderSize();
        Point imgPos = new Point(this.cardXOffset + borderSize, this.cardYOffset + borderSize);
        Dimension imgSize = this.calculateImageSize();
        this.imagePanel.setLocation(imgPos);
        this.imagePanel.setSize(imgSize);
        boolean canShow = this.matchUI.mayView(this.card);
        boolean showText = !this.imagePanel.hasImage() || !this.isAnimationPanel;
        this.displayCardNameOverlay(showText && canShow && this.showCardNameOverlay(), imgSize, imgPos);
        this.displayPTOverlay(showText && (canShow || this.card.isFaceDown()) && this.showCardPowerOverlay(), imgSize, imgPos);
        this.displayCardIdOverlay(showText && canShow && this.showCardIdOverlay(), imgSize, imgPos);
    }

    private int calculateBorderSize() {
        boolean cardImgHasAlpha;
        boolean noBorderPref = !CardPanel.isPreferenceEnabled(ForgePreferences.FPref.UI_RENDER_BLACK_BORDERS);
        boolean noBorderOnCard = this.getCard().getCurrentState().getSetCode().equalsIgnoreCase("MPS_AKH");
        boolean bl = cardImgHasAlpha = this.imagePanel != null && this.imagePanel.getSrcImage() != null && this.imagePanel.getSrcImage().getColorModel().hasAlpha();
        if (!(noBorderPref || (noBorderOnCard |= this.getCard().getCurrentState().isBasicLand() && this.getCard().getCurrentState().getSetCode().equalsIgnoreCase("UST")) && cardImgHasAlpha)) {
            return noBorderOnCard ? 2 : Math.round((float)this.cardWidth * 0.03f);
        }
        return 0;
    }

    private Dimension calculateImageSize() {
        int borderSize = this.calculateBorderSize();
        return new Dimension(this.cardWidth - borderSize * 2, this.cardHeight - borderSize * 2);
    }

    private void displayCardIdOverlay(boolean isVisible, Dimension imgSize, Point imgPos) {
        if (isVisible) {
            Dimension idSize = this.cardIdText.getPreferredSize();
            this.cardIdText.setSize(idSize.width, idSize.height);
            int idX = Math.round((float)imgSize.width * 0.05f);
            int idY = Math.round((float)imgSize.height * 0.9558824f) - 8;
            this.cardIdText.setLocation(imgPos.x + idX, imgPos.y + idY);
        }
        this.cardIdText.setVisible(isVisible);
    }

    private void displayPTOverlay(boolean isVisible, Dimension imgSize, Point imgPos) {
        if (isVisible) {
            int rightLine = Math.round((float)imgSize.width * 0.85833335f) + 3;
            Dimension ptSize = this.ptText.getPreferredSize();
            this.ptText.setSize(ptSize.width, ptSize.height);
            int ptX = rightLine - ptSize.width / 2;
            int ptY = Math.round((float)imgSize.height * 0.9558824f) - 10;
            this.ptText.setLocation(imgPos.x + ptX, imgPos.y + ptY);
            Dimension dmgSize = this.damageText.getPreferredSize();
            this.damageText.setSize(dmgSize.width, dmgSize.height);
            int dmgX = rightLine - dmgSize.width / 2;
            int dmgY = ptY - 16;
            this.damageText.setLocation(imgPos.x + dmgX, imgPos.y + dmgY);
        }
        this.ptText.setVisible(isVisible);
        this.damageText.setVisible(isVisible);
    }

    private void displayCardNameOverlay(boolean isVisible, Dimension imgSize, Point imgPos) {
        if (isVisible) {
            int titleX = Math.round((float)imgSize.width * 0.05f);
            int titleY = Math.round((float)imgSize.height * 0.084375f) - 15;
            int titleH = Math.round((float)imgSize.height * 0.5625f);
            this.titleText.setBounds(imgPos.x + titleX, imgPos.y + titleY + 2, imgSize.width - 2 * titleX, titleH - titleY);
        }
        this.titleText.setVisible(isVisible);
    }

    private void displayIconOverlay(Graphics g2, boolean canShow) {
        if (canShow && this.showCardManaCostOverlay() && this.cardWidth < 200) {
            boolean showSplitMana;
            boolean bl = showSplitMana = this.card.isSplitCard() && this.card.getZone() != ZoneType.Battlefield;
            if (!showSplitMana) {
                this.drawManaCost(g2, this.card.getCurrentState().getManaCost(), 0);
            } else if (!this.card.isFaceDown()) {
                PaperCard pc = null;
                if (!this.card.getName().isEmpty()) {
                    pc = StaticData.instance().getCommonCards().getCard(this.card.getName());
                }
                int ofs = pc != null && Card.getCardForUi(pc).hasKeyword(Keyword.AFTERMATH) ? -12 : 12;
                this.drawManaCost(g2, this.card.getLeftSplitState().getManaCost(), ofs);
                this.drawManaCost(g2, this.card.getAlternateState().getManaCost(), -ofs);
            }
        }
        if (this.card.getCounters() != null && !this.card.getCounters().isEmpty()) {
            switch (ForgeConstants.CounterDisplayType.from(FModel.getPreferences().getPref(ForgePreferences.FPref.UI_CARD_COUNTER_DISPLAY_TYPE))) {
                case OLD_WHEN_SMALL: 
                case TEXT: {
                    this.drawCounterTabs(g2);
                    break;
                }
                case IMAGE: {
                    this.drawCounterImage(g2);
                    break;
                }
                case HYBRID: {
                    this.drawCounterImage(g2);
                    this.drawCounterTabs(g2);
                }
            }
        }
        if (this.card.getCurrentRoom() != null && !this.card.getCurrentRoom().isEmpty()) {
            ArrayList<String> markers = new ArrayList<String>();
            markers.add("In Room:");
            markers.add(this.card.getCurrentRoom());
            this.drawMarkersTabs(g2, markers);
        }
        int combatXSymbols = this.cardXOffset + this.cardWidth / 4 - 16;
        int stateXSymbols = this.cardXOffset + this.cardWidth / 2 - 16;
        int ySymbols = this.cardYOffset + this.cardHeight - this.cardHeight / 8 - 16;
        if (this.card.isAttacking()) {
            CardFaceSymbols.drawSymbol("attack", g2, combatXSymbols, ySymbols);
        } else if (this.card.isBlocking()) {
            CardFaceSymbols.drawSymbol("defend", g2, combatXSymbols, ySymbols);
        }
        if (this.card.isSick()) {
            CardFaceSymbols.drawSymbol("summonsick", g2, stateXSymbols, ySymbols);
        }
        if (this.card.isPhasedOut()) {
            CardFaceSymbols.drawSymbol("phasing", g2, stateXSymbols, ySymbols);
        }
        if (this.matchUI.isUsedToPay(this.card)) {
            CardFaceSymbols.drawSymbol("sacrifice", g2, this.cardXOffset + this.cardWidth / 2 - 20, this.cardYOffset + this.cardHeight / 2 - 20);
        }
        int abiScale = this.cardWidth / 7;
        int abiX = this.cardXOffset + this.cardWidth / 2 + this.cardWidth / 3;
        int abiSpace = this.cardWidth / 7;
        int abiY = this.cardWidth < 200 ? this.cardYOffset + 25 : this.cardYOffset + 50;
        this.hasFlash = false;
        if (this.showAbilityIcons()) {
            if (ZoneType.Battlefield.equals((Object)this.card.getZone())) {
                if (this.card.isCommander()) {
                    CardFaceSymbols.drawAbilitySymbol("commander", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                }
                if (this.card.isRingBearer()) {
                    CardFaceSymbols.drawAbilitySymbol("ringbearer", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                }
                if (this.card.getCurrentState().hasFlying()) {
                    CardFaceSymbols.drawAbilitySymbol("flying", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                }
                if (this.card.getCurrentState().hasHaste()) {
                    CardFaceSymbols.drawAbilitySymbol("haste", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                }
                if (this.card.getCurrentState().hasDoubleStrike()) {
                    CardFaceSymbols.drawAbilitySymbol("doublestrike", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                } else if (this.card.getCurrentState().hasFirstStrike()) {
                    CardFaceSymbols.drawAbilitySymbol("firststrike", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                }
                if (this.card.getCurrentState().hasAnnihilator()) {
                    CardFaceSymbols.drawAbilitySymbol("annihilator", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                }
                if (this.card.getCurrentState().hasExalted()) {
                    CardFaceSymbols.drawAbilitySymbol("exalted", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                }
                if (this.card.getCurrentState().hasDeathtouch()) {
                    CardFaceSymbols.drawAbilitySymbol("deathtouch", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                }
                if (this.card.getCurrentState().hasToxic()) {
                    CardFaceSymbols.drawAbilitySymbol("toxic", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                }
                if (this.card.getCurrentState().hasIndestructible()) {
                    CardFaceSymbols.drawAbilitySymbol("indestructible", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                }
                if (this.card.getCurrentState().hasMenace()) {
                    CardFaceSymbols.drawAbilitySymbol("menace", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                }
                if (this.card.getCurrentState().hasFear()) {
                    CardFaceSymbols.drawAbilitySymbol("fear", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                }
                if (this.card.getCurrentState().hasIntimidate()) {
                    CardFaceSymbols.drawAbilitySymbol("intimidate", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                }
                if (this.card.getCurrentState().hasShadow()) {
                    CardFaceSymbols.drawAbilitySymbol("shadow", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                }
                if (this.card.getCurrentState().hasHorsemanship()) {
                    CardFaceSymbols.drawAbilitySymbol("horsemanship", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                }
                if (this.card.getCurrentState().hasHexproof()) {
                    if (!this.card.getCurrentState().getHexproofKey().isEmpty()) {
                        String[] splitK = this.card.getCurrentState().getHexproofKey().split(":");
                        List<String> listHK = Arrays.asList(splitK);
                        if (listHK.contains("generic")) {
                            CardFaceSymbols.drawAbilitySymbol("hexproof", g2, abiX, abiY, abiScale, abiScale);
                            abiY += abiSpace;
                        }
                        if (listHK.contains("R")) {
                            CardFaceSymbols.drawAbilitySymbol("hexproofR", g2, abiX, abiY, abiScale, abiScale);
                            abiY += abiSpace;
                        }
                        if (listHK.contains("B")) {
                            CardFaceSymbols.drawAbilitySymbol("hexproofB", g2, abiX, abiY, abiScale, abiScale);
                            abiY += abiSpace;
                        }
                        if (listHK.contains("U")) {
                            CardFaceSymbols.drawAbilitySymbol("hexproofU", g2, abiX, abiY, abiScale, abiScale);
                            abiY += abiSpace;
                        }
                        if (listHK.contains("G")) {
                            CardFaceSymbols.drawAbilitySymbol("hexproofG", g2, abiX, abiY, abiScale, abiScale);
                            abiY += abiSpace;
                        }
                        if (listHK.contains("W")) {
                            CardFaceSymbols.drawAbilitySymbol("hexproofW", g2, abiX, abiY, abiScale, abiScale);
                            abiY += abiSpace;
                        }
                        if (listHK.contains("monocolored")) {
                            CardFaceSymbols.drawAbilitySymbol("hexproofC", g2, abiX, abiY, abiScale, abiScale);
                            abiY += abiSpace;
                        }
                    } else {
                        CardFaceSymbols.drawAbilitySymbol("hexproof", g2, abiX, abiY, abiScale, abiScale);
                        abiY += abiSpace;
                    }
                } else if (this.card.getCurrentState().hasShroud()) {
                    CardFaceSymbols.drawAbilitySymbol("shroud", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                }
                if (this.card.getCurrentState().hasVigilance()) {
                    CardFaceSymbols.drawAbilitySymbol("vigilance", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                }
                if (this.card.getCurrentState().hasTrample()) {
                    CardFaceSymbols.drawAbilitySymbol("trample", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                }
                if (this.card.getCurrentState().hasReach()) {
                    CardFaceSymbols.drawAbilitySymbol("reach", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                }
                if (this.card.getCurrentState().hasLifelink()) {
                    CardFaceSymbols.drawAbilitySymbol("lifelink", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                }
                if (this.card.getCurrentState().hasWard()) {
                    CardFaceSymbols.drawAbilitySymbol("ward", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                }
                if (this.card.getCurrentState().hasWither()) {
                    CardFaceSymbols.drawAbilitySymbol("wither", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                }
                if (this.card.getCurrentState().hasDefender()) {
                    CardFaceSymbols.drawAbilitySymbol("defender", g2, abiX, abiY, abiScale, abiScale);
                    abiY += abiSpace;
                }
                if (!this.card.getCurrentState().getProtectionKey().isEmpty()) {
                    if (this.card.getCurrentState().getProtectionKey().contains("everything") || this.card.getCurrentState().getProtectionKey().contains("allcolors")) {
                        CardFaceSymbols.drawAbilitySymbol("protectAll", g2, abiX, abiY, abiScale, abiScale);
                        abiY += abiSpace;
                    } else if (this.card.getCurrentState().getProtectionKey().contains("coloredspells")) {
                        CardFaceSymbols.drawAbilitySymbol("protectColoredSpells", g2, abiX, abiY, abiScale, abiScale);
                        abiY += abiSpace;
                    } else if (this.card.getCurrentState().getProtectionKey().equals("R")) {
                        CardFaceSymbols.drawAbilitySymbol("protectR", g2, abiX, abiY, abiScale, abiScale);
                        abiY += abiSpace;
                    } else if (this.card.getCurrentState().getProtectionKey().equals("G")) {
                        CardFaceSymbols.drawAbilitySymbol("protectG", g2, abiX, abiY, abiScale, abiScale);
                        abiY += abiSpace;
                    } else if (this.card.getCurrentState().getProtectionKey().equals("B")) {
                        CardFaceSymbols.drawAbilitySymbol("protectB", g2, abiX, abiY, abiScale, abiScale);
                        abiY += abiSpace;
                    } else if (this.card.getCurrentState().getProtectionKey().equals("U")) {
                        CardFaceSymbols.drawAbilitySymbol("protectU", g2, abiX, abiY, abiScale, abiScale);
                        abiY += abiSpace;
                    } else if (this.card.getCurrentState().getProtectionKey().equals("W")) {
                        CardFaceSymbols.drawAbilitySymbol("protectW", g2, abiX, abiY, abiScale, abiScale);
                        abiY += abiSpace;
                    } else if (this.card.getCurrentState().getProtectionKey().equals("RG") || this.card.getCurrentState().getProtectionKey().equals("GR")) {
                        CardFaceSymbols.drawAbilitySymbol("protectRG", g2, abiX, abiY, abiScale, abiScale);
                        abiY += abiSpace;
                    } else if (this.card.getCurrentState().getProtectionKey().equals("RB") || this.card.getCurrentState().getProtectionKey().equals("BR")) {
                        CardFaceSymbols.drawAbilitySymbol("protectRB", g2, abiX, abiY, abiScale, abiScale);
                        abiY += abiSpace;
                    } else if (this.card.getCurrentState().getProtectionKey().equals("RU") || this.card.getCurrentState().getProtectionKey().equals("UR")) {
                        CardFaceSymbols.drawAbilitySymbol("protectRU", g2, abiX, abiY, abiScale, abiScale);
                        abiY += abiSpace;
                    } else if (this.card.getCurrentState().getProtectionKey().equals("RW") || this.card.getCurrentState().getProtectionKey().equals("WR")) {
                        CardFaceSymbols.drawAbilitySymbol("protectRW", g2, abiX, abiY, abiScale, abiScale);
                        abiY += abiSpace;
                    } else if (this.card.getCurrentState().getProtectionKey().equals("GB") || this.card.getCurrentState().getProtectionKey().equals("BG")) {
                        CardFaceSymbols.drawAbilitySymbol("protectGB", g2, abiX, abiY, abiScale, abiScale);
                        abiY += abiSpace;
                    } else if (this.card.getCurrentState().getProtectionKey().equals("GU") || this.card.getCurrentState().getProtectionKey().equals("UG")) {
                        CardFaceSymbols.drawAbilitySymbol("protectGU", g2, abiX, abiY, abiScale, abiScale);
                        abiY += abiSpace;
                    } else if (this.card.getCurrentState().getProtectionKey().equals("GW") || this.card.getCurrentState().getProtectionKey().equals("WG")) {
                        CardFaceSymbols.drawAbilitySymbol("protectGW", g2, abiX, abiY, abiScale, abiScale);
                        abiY += abiSpace;
                    } else if (this.card.getCurrentState().getProtectionKey().equals("BU") || this.card.getCurrentState().getProtectionKey().equals("UB")) {
                        CardFaceSymbols.drawAbilitySymbol("protectBU", g2, abiX, abiY, abiScale, abiScale);
                        abiY += abiSpace;
                    } else if (this.card.getCurrentState().getProtectionKey().equals("BW") || this.card.getCurrentState().getProtectionKey().equals("WB")) {
                        CardFaceSymbols.drawAbilitySymbol("protectBW", g2, abiX, abiY, abiScale, abiScale);
                        abiY += abiSpace;
                    } else if (this.card.getCurrentState().getProtectionKey().equals("UW") || this.card.getCurrentState().getProtectionKey().equals("WU")) {
                        CardFaceSymbols.drawAbilitySymbol("protectUW", g2, abiX, abiY, abiScale, abiScale);
                        abiY += abiSpace;
                    } else if (this.card.getCurrentState().getProtectionKey().contains("generic") || this.card.getCurrentState().getProtectionKey().length() > 2) {
                        CardFaceSymbols.drawAbilitySymbol("protectGeneric", g2, abiX, abiY, abiScale, abiScale);
                        abiY += abiSpace;
                    }
                }
            } else {
                String keywordKey = this.card.getCurrentState().getKeywordKey();
                String abilityText = this.card.getCurrentState().getAbilityText();
                if (!keywordKey.contains("Flashback") && keywordKey.contains("Flash") || abilityText.contains("May be played by") && abilityText.contains("and as though it has flash")) {
                    boolean bl = this.hasFlash = !this.card.isFaceDown() && (!ZoneType.Library.equals((Object)this.card.getZone()) && !ZoneType.Hand.equals((Object)this.card.getZone()) || this.matchUI.mayView(this.card));
                    if (this.hasFlash) {
                        CardFaceSymbols.drawAbilitySymbol("flash", g2, this.cardXOffset + this.cardWidth / 2 + this.cardWidth / 3, this.cardWidth < 200 ? this.cardYOffset + 25 : this.cardYOffset + 50, this.cardWidth / 7, this.cardWidth / 7);
                    }
                }
            }
        }
    }

    private void drawCounterTabs(Graphics g2) {
        Dimension imgSize = this.calculateImageSize();
        int titleY = Math.round((float)imgSize.height * 0.084375f) - 15;
        int spaceFromTopOfCard = titleY + 60;
        int counterBoxHeight = 24;
        int counterBoxBaseWidth = 58;
        int counterBoxSpacing = 2;
        int currentCounter = 0;
        FontMetrics smallFontMetrics = g2.getFontMetrics(smallCounterFont);
        FontMetrics largeFontMetrics = g2.getFontMetrics(largeCounterFont);
        if (ForgeConstants.CounterDisplayType.from(FModel.getPreferences().getPref(ForgePreferences.FPref.UI_CARD_COUNTER_DISPLAY_TYPE)) == ForgeConstants.CounterDisplayType.OLD_WHEN_SMALL) {
            int maxCounters = 0;
            for (Integer numberOfCounters : this.card.getCounters().values()) {
                maxCounters = Math.max(maxCounters, numberOfCounters);
            }
            if (58 + largeFontMetrics.stringWidth(String.valueOf(maxCounters)) > this.cardWidth) {
                this.drawCounterImage(g2);
                return;
            }
        }
        for (Map.Entry<CounterType, Integer> counterEntry : new HashSet<Map.Entry<CounterType, Integer>>(this.card.getCounters().entrySet())) {
            CounterType counter = counterEntry.getKey();
            int numberOfCounters = counterEntry.getValue();
            int counterBoxRealWidth = 58 + largeFontMetrics.stringWidth(String.valueOf(numberOfCounters));
            int counterYOffset = ForgeConstants.CounterDisplayLocation.from(FModel.getPreferences().getPref(ForgePreferences.FPref.UI_CARD_COUNTER_DISPLAY_LOCATION)) == ForgeConstants.CounterDisplayLocation.TOP ? this.cardYOffset + spaceFromTopOfCard - 24 + currentCounter++ * 26 : this.cardYOffset + this.cardHeight - spaceFromTopOfCard / 2 - 24 + currentCounter++ * 26;
            if (this.isSelected) {
                g2.setColor(new Color(0, 0, 0, 255));
            } else {
                g2.setColor(new Color(0, 0, 0, 200));
            }
            RoundRectangle2D.Float counterArea = new RoundRectangle2D.Float(this.cardXOffset, counterYOffset, counterBoxRealWidth, 24.0f, 9.0f, 9.0f);
            ((Graphics2D)g2).fill(counterArea);
            g2.fillRect(this.cardXOffset, counterYOffset, 9, 24);
            if (this.isSelected) {
                g2.setColor(new Color(counter.getRed(), counter.getGreen(), counter.getBlue()));
            } else {
                g2.setColor(new Color(counter.getRed(), counter.getGreen(), counter.getBlue(), 180));
            }
            Rectangle nameBounds = counterArea.getBounds();
            nameBounds.x += 8;
            --nameBounds.y;
            nameBounds.width = 43;
            this.drawVerticallyCenteredString(g2, counter.getCounterOnCardDisplayName(), nameBounds, smallCounterFont, smallFontMetrics);
            Rectangle numberBounds = counterArea.getBounds();
            numberBounds.x += 52;
            this.drawVerticallyCenteredString(g2, String.valueOf(numberOfCounters), numberBounds, largeCounterFont, largeFontMetrics);
        }
    }

    private void drawCounterImage(Graphics g2) {
        int counters = 0;
        for (Integer i : this.card.getCounters().values()) {
            counters += i.intValue();
        }
        int yCounters = this.cardYOffset + this.cardHeight - this.cardHeight / 3 - 40;
        if (counters == 1) {
            CardFaceSymbols.drawSymbol("counters1", g2, this.cardXOffset - 15, yCounters);
        } else if (counters == 2) {
            CardFaceSymbols.drawSymbol("counters2", g2, this.cardXOffset - 15, yCounters);
        } else if (counters == 3) {
            CardFaceSymbols.drawSymbol("counters3", g2, this.cardXOffset - 15, yCounters);
        } else if (counters > 3) {
            CardFaceSymbols.drawSymbol("countersMulti", g2, this.cardXOffset - 15, yCounters);
        }
    }

    private void drawMarkersTabs(Graphics g2, List<String> markers) {
        Dimension imgSize = this.calculateImageSize();
        int titleY = Math.round((float)imgSize.height * 0.084375f) - 15;
        int spaceFromTopOfCard = titleY + 60;
        int markerBoxHeight = 24;
        int markerBoxBaseWidth = 14;
        int markerBoxSpacing = 2;
        int currentMarker = 0;
        FontMetrics smallFontMetrics = g2.getFontMetrics(smallCounterFont);
        for (String marker : markers) {
            int markerBoxRealWidth = 14 + smallFontMetrics.stringWidth(marker);
            int markerYOffset = ForgeConstants.CounterDisplayLocation.from(FModel.getPreferences().getPref(ForgePreferences.FPref.UI_CARD_COUNTER_DISPLAY_LOCATION)) == ForgeConstants.CounterDisplayLocation.TOP ? this.cardYOffset + spaceFromTopOfCard - 24 + currentMarker++ * 26 : this.cardYOffset + this.cardHeight - spaceFromTopOfCard / 2 - 24 + currentMarker++ * 26;
            if (this.isSelected) {
                g2.setColor(new Color(0, 0, 0, 255));
            } else {
                g2.setColor(new Color(0, 0, 0, 200));
            }
            RoundRectangle2D.Float markerArea = new RoundRectangle2D.Float(this.cardXOffset, markerYOffset, markerBoxRealWidth, 24.0f, 9.0f, 9.0f);
            ((Graphics2D)g2).fill(markerArea);
            g2.fillRect(this.cardXOffset, markerYOffset, 9, 24);
            if (this.isSelected) {
                g2.setColor(new Color(200, 200, 200));
            } else {
                g2.setColor(new Color(200, 200, 200, 180));
            }
            Rectangle nameBounds = markerArea.getBounds();
            nameBounds.x += 8;
            --nameBounds.y;
            nameBounds.width = 43;
            this.drawVerticallyCenteredString(g2, marker, nameBounds, smallCounterFont, smallFontMetrics);
        }
    }

    private void drawVerticallyCenteredString(Graphics g2, String text, Rectangle area, Font font, FontMetrics fontMetrics) {
        Font oldFont = g2.getFont();
        int x = area.x;
        int y = area.y + (area.height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent() + 1;
        g2.setFont(font);
        g2.drawString(text, x, y);
        g2.setFont(oldFont);
    }

    @Override
    public final String toString() {
        return this.getCard().toString();
    }

    public final void setCardBounds(int x, int y, int width, int height) {
        this.cardWidth = width;
        this.cardHeight = height;
        int rotCenterX = Math.round((float)width / 2.0f);
        int rotCenterY = height - rotCenterX;
        int rotCenterToTopCorner = Math.round((float)width * 1.0295631f);
        int rotCenterToBottomCorner = Math.round((float)width * 0.70710677f);
        int xOffset = rotCenterX - rotCenterToBottomCorner;
        int yOffset = rotCenterY - rotCenterToTopCorner;
        this.cardXOffset = -xOffset;
        this.cardYOffset = -yOffset;
        width = -xOffset + rotCenterX + rotCenterToTopCorner;
        height = -yOffset + rotCenterY + rotCenterToBottomCorner;
        this.setBounds(x + xOffset, y + yOffset, width, height);
    }

    @Override
    public final void repaint() {
        Rectangle b = this.getBounds();
        JRootPane rootPane = SwingUtilities.getRootPane(this);
        if (rootPane == null) {
            return;
        }
        Point p = SwingUtilities.convertPoint(this.getParent(), b.x, b.y, rootPane);
        rootPane.repaint(p.x, p.y, b.width, b.height);
    }

    public final int getCardX() {
        return this.getX() + this.cardXOffset;
    }

    public final int getCardY() {
        return this.getY() + this.cardYOffset;
    }

    public final int getCardWidth() {
        return this.cardWidth;
    }

    public final int getCardHeight() {
        return this.cardHeight;
    }

    public final Point getCardLocation() {
        Point p = this.getLocation();
        p.x += this.cardXOffset;
        p.y += this.cardYOffset;
        return p;
    }

    public final Point getCardLocationOnScreen() {
        Point p = this.getLocationOnScreen();
        p.x += this.cardXOffset;
        p.y += this.cardYOffset;
        return p;
    }

    public final void updateText() {
        int damage;
        if (this.card == null) {
            return;
        }
        this.titleText.setText(CardTranslation.getTranslatedName(this.card.getCurrentState().getName()));
        if (CardPanel.isPreferenceEnabled(ForgePreferences.FPref.UI_SR_OPTIMIZE)) {
            if (this.isTapped()) {
                this.titleText.getAccessibleContext().setAccessibleDescription("tapped");
            } else {
                this.titleText.getAccessibleContext().setAccessibleDescription("");
            }
        }
        this.damageText.setText((damage = this.card.getDamage()) > 0 ? "\u00bb " + damage + " \u00ab" : "");
        this.cardIdText.setText(this.card.getCurrentState().getDisplayId());
    }

    public final void updatePTOverlay() {
        CardView.CardStateView state = this.card.getCurrentState();
        String sPt = "";
        if (state.isCreature() && state.isPlaneswalker()) {
            sPt = state.getPower() + "/" + state.getToughness() + " (" + state.getLoyalty() + ")";
        } else if (state.isCreature()) {
            sPt = state.getPower() + "/" + state.getToughness();
        } else if (state.getType().hasSubtype("Vehicle")) {
            sPt = "[" + state.getPower() + "/" + state.getToughness() + "]";
        } else if (state.isPlaneswalker()) {
            sPt = state.getLoyalty();
        }
        this.ptText.setText(sPt);
    }

    @Override
    public final CardView getCard() {
        return this.card;
    }

    @Override
    public final void setCard(CardView cardView) {
        CardView oldCard = this.card;
        this.card = cardView;
        if (this.imagePanel == null) {
            return;
        }
        if (oldCard != null && oldCard.equals(this.card) && this.isAnimationPanel && this.imagePanel.hasImage()) {
            return;
        }
        this.updateText();
        this.updatePTOverlay();
        this.updateImage();
        this.repaint();
    }

    @Override
    public void dispose() {
        this.attachedToPanel = null;
        this.attachedPanels = null;
        this.stack = null;
        this.imagePanel.setImage(null);
        this.imagePanel = null;
        this.card = null;
    }

    public static CardPanel getDragAnimationPanel() {
        return dragAnimationPanel;
    }

    public static void setDragAnimationPanel(CardPanel dragAnimationPanel0) {
        dragAnimationPanel = dragAnimationPanel0;
    }

    public final CardPanel getAttachedToPanel() {
        return this.attachedToPanel;
    }

    public final void setAttachedToPanel(CardPanel attachedToPanel0) {
        this.attachedToPanel = attachedToPanel0;
    }

    public final List<CardPanel> getAttachedPanels() {
        return this.attachedPanels;
    }

    public final List<CardPanel> getStack() {
        return this.stack;
    }

    public final void setStack(List<CardPanel> stack0) {
        this.stack = stack0;
    }

    public final boolean isTapped() {
        return this.tapped;
    }

    public final void setTapped(boolean tapped0) {
        this.tapped = tapped0;
    }

    public final double getTappedAngle() {
        return this.tappedAngle;
    }

    public final void setTappedAngle(double tappedAngle0) {
        this.tappedAngle = tappedAngle0;
    }

    private static boolean isPreferenceEnabled(ForgePreferences.FPref preferenceName) {
        return FModel.getPreferences().getPrefBoolean(preferenceName);
    }

    private boolean isShowingOverlays() {
        return CardPanel.isPreferenceEnabled(ForgePreferences.FPref.UI_SHOW_CARD_OVERLAYS) && this.card != null;
    }

    private boolean showCardNameOverlay() {
        return this.isShowingOverlays() && CardPanel.isPreferenceEnabled(ForgePreferences.FPref.UI_OVERLAY_CARD_NAME);
    }

    private boolean showCardPowerOverlay() {
        return this.isShowingOverlays() && CardPanel.isPreferenceEnabled(ForgePreferences.FPref.UI_OVERLAY_CARD_POWER);
    }

    private boolean showCardManaCostOverlay() {
        return this.isShowingOverlays() && CardPanel.isPreferenceEnabled(ForgePreferences.FPref.UI_OVERLAY_CARD_MANA_COST);
    }

    private boolean showCardIdOverlay() {
        return this.isShowingOverlays() && CardPanel.isPreferenceEnabled(ForgePreferences.FPref.UI_OVERLAY_CARD_ID);
    }

    private boolean showAbilityIcons() {
        return this.isShowingOverlays() && CardPanel.isPreferenceEnabled(ForgePreferences.FPref.UI_OVERLAY_ABILITY_ICONS);
    }

    public void repaintOverlays() {
        this.repaint();
        this.doLayout();
    }

    static {
        try {
            Font roboto = Font.createFont(0, Paths.get(ForgeConstants.COMMON_FONTS_DIR, "Roboto-Bold.ttf").toFile());
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            ge.registerFont(roboto);
            HashMap<TextAttribute, Object> attributes = new HashMap<TextAttribute, Object>();
            attributes.put(TextAttribute.FAMILY, "Roboto Bold");
            attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            attributes.put(TextAttribute.SIZE, 11);
            attributes.put(TextAttribute.KERNING, TextAttribute.KERNING_ON);
            smallCounterFont = Font.getFont(attributes);
            attributes.put(TextAttribute.SIZE, 14);
            largeCounterFont = Font.getFont(attributes);
        }
        catch (FontFormatException | IOException e) {
            e.printStackTrace();
        }
    }
}

