/*
 * Decompiled with CFR 0.152.
 */
package forge.view.arcane;

import com.google.common.collect.Lists;
import forge.screens.match.CMatchUI;
import forge.toolbox.FScrollPane;
import forge.view.arcane.CardPanel;
import forge.view.arcane.CardPanelContainer;
import forge.view.arcane.util.Animation;
import forge.view.arcane.util.CardPanelMouseListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JLayeredPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class CardArea
extends CardPanelContainer
implements CardPanelMouseListener {
    private static final long serialVersionUID = -5836122075999621592L;
    public static final int GUTTER_Y = 5;
    public static final int GUTTER_X = 5;
    private static final float HORIZ_CARD_SPACING_X = 0.04f;
    private static final float HORIZ_CARD_SPACING_Y = 0.06f;
    private static final float VERT_CARD_SPACING_X = 0.06f;
    private static final float VERT_CARD_SPACING_Y = 0.1f;
    private float maxCoverage = 0.5f;
    private int maxRows = 0;
    private float cardSpacingX;
    private int actualCardsPerRow;
    private int mouseDragStartX;
    private int mouseDragStartY;
    private boolean isVertical;
    private boolean hasScrollbars;

    public CardArea(CMatchUI matchUI, FScrollPane scrollPane) {
        super(matchUI, scrollPane);
        this.setBackground(Color.white);
    }

    @Override
    public final CardPanel getCardPanel(int x, int y) {
        List<CardPanel> panels = this.isVertical ? Lists.reverse(this.getCardPanels()) : this.getCardPanels();
        for (CardPanel panel : panels) {
            int panelX = panel == this.getMouseDragPanel() ? this.mouseDragStartX : panel.getCardX();
            int panelY = panel == this.getMouseDragPanel() ? this.mouseDragStartY : panel.getCardY();
            int panelWidth = panel.getCardWidth();
            int panelHeight = panel.getCardHeight();
            if (x <= panelX || x >= panelX + panelWidth || y <= panelY || y >= panelY + panelHeight) continue;
            if (!panel.isDisplayEnabled()) {
                return null;
            }
            return panel;
        }
        return null;
    }

    @Override
    public void doLayout() {
        float x;
        if (this.getCardPanels().isEmpty()) {
            return;
        }
        Rectangle rect = this.getScrollPane().getVisibleRect();
        Insets insets = this.getScrollPane().getInsets();
        rect.width -= insets.left;
        rect.height -= insets.top;
        rect.width -= insets.right;
        rect.height -= insets.bottom;
        int cardAreaWidth = rect.width;
        int cardAreaHeight = rect.height;
        int cardWidth = this.getCardWidthMax();
        int maxWidth = 0;
        int maxHeight = 0;
        if (this.isVertical) {
            int availableRowHeight;
            int cardHeight;
            int cardSpacingY;
            int actualRowHeight;
            do {
                cardHeight = Math.round((float)cardWidth * 1.4f);
                this.cardSpacingX = Math.round((float)cardWidth * 0.06f);
                cardSpacingY = cardHeight + Math.round((float)cardWidth * 0.1f);
                int maxRows = Math.max((int)Math.floor(((float)(cardAreaWidth - 10) + this.cardSpacingX) / ((float)cardWidth + this.cardSpacingX)), 1);
                if (this.maxRows > 0) {
                    maxRows = Math.min(this.maxRows, maxRows);
                }
                availableRowHeight = cardAreaHeight - 10;
                int availableCardsPerRow = (int)Math.floor((double)(availableRowHeight - (cardHeight - cardSpacingY)) / (double)cardSpacingY);
                this.actualCardsPerRow = Math.max(availableCardsPerRow, (int)Math.ceil((float)this.getCardPanels().size() / (float)maxRows));
                actualRowHeight = (int)Math.floor((this.actualCardsPerRow - 1) * cardSpacingY + cardHeight);
                float overflow = actualRowHeight - availableRowHeight;
                if (!(overflow > 0.0f)) continue;
                float offsetY = overflow / (float)(this.actualCardsPerRow - 1);
                offsetY = Math.min(offsetY, (float)cardHeight * this.maxCoverage);
                cardSpacingY = (int)((float)cardSpacingY - offsetY);
            } while (((actualRowHeight = (int)Math.floor((this.actualCardsPerRow - 1) * cardSpacingY + cardHeight)) < 0 || actualRowHeight > availableRowHeight) && --cardWidth != this.getCardWidthMin());
            x = 5.0f;
            int y = 5;
            int zOrder = this.getCardPanels().size() - 1;
            int rowCount = 0;
            int maxZOrder = this.getComponentCount() - 1;
            if (zOrder > maxZOrder) {
                zOrder = maxZOrder;
            }
            for (CardPanel panel : this.getCardPanels()) {
                if (panel != this.getMouseDragPanel()) {
                    panel.setCardBounds((int)Math.floor(x), y, cardWidth, cardHeight);
                }
                maxWidth = Math.round(x) + cardWidth + 5;
                maxHeight = Math.max(maxHeight, (y += cardSpacingY) + (cardHeight - cardSpacingY) + 5);
                this.setComponentZOrder(panel, zOrder);
                if (zOrder > 0) {
                    --zOrder;
                }
                if (++rowCount != this.actualCardsPerRow) continue;
                rowCount = 0;
                x += (float)cardWidth + this.cardSpacingX;
                y = 5;
            }
        } else {
            int cardSpacingY;
            int cardHeight;
            int availableRowWidth;
            int actualRowWidth;
            do {
                cardHeight = Math.round((float)cardWidth * 1.4f);
                int extraCardSpacingX = Math.round((float)cardWidth * 0.04f);
                cardSpacingY = Math.round((float)cardHeight * 0.06f);
                this.cardSpacingX = cardWidth + extraCardSpacingX;
                int maxRows = Math.max((int)Math.floor((double)(cardAreaHeight - 10 + cardSpacingY) / (double)(cardHeight + cardSpacingY)), 1);
                if (this.maxRows > 0) {
                    maxRows = Math.min(this.maxRows, maxRows);
                }
                availableRowWidth = cardAreaWidth - 10;
                int availableCardsPerRow = (int)Math.floor(((float)availableRowWidth - ((float)cardWidth - this.cardSpacingX)) / this.cardSpacingX);
                this.actualCardsPerRow = Math.max(availableCardsPerRow, (int)Math.ceil((float)this.getCardPanels().size() / (float)maxRows));
                actualRowWidth = (int)Math.floor((float)(this.actualCardsPerRow - 1) * this.cardSpacingX + (float)cardWidth);
                float overflow = actualRowWidth - availableRowWidth;
                if (!(overflow > 0.0f)) continue;
                float offsetX = overflow / (float)(this.actualCardsPerRow - 1);
                offsetX = Math.min(offsetX, (float)cardWidth * this.maxCoverage);
                this.cardSpacingX -= offsetX;
            } while ((actualRowWidth = (int)Math.floor((float)(this.actualCardsPerRow - 1) * this.cardSpacingX + (float)cardWidth)) > availableRowWidth && --cardWidth != this.getCardWidthMin());
            x = 5.0f;
            int y = 5;
            int zOrder = 0;
            int rowCount = 0;
            for (CardPanel panel : this.getCardPanels()) {
                if (panel != this.getMouseDragPanel()) {
                    panel.setCardBounds((int)Math.floor(x), y, cardWidth, cardHeight);
                }
                maxWidth = Math.max(maxWidth, Math.round((x += this.cardSpacingX) + ((float)cardWidth - this.cardSpacingX) + 5.0f) - 1);
                maxHeight = Math.max(maxHeight, y + (cardHeight - cardSpacingY) + 5);
                this.setComponentZOrder(panel, zOrder);
                ++zOrder;
                if (++rowCount != this.actualCardsPerRow) continue;
                rowCount = 0;
                x = 5.0f;
                y += cardHeight + cardSpacingY;
            }
        }
        Dimension oldPreferredSize = this.getPreferredSize();
        this.setPreferredSize(new Dimension(maxWidth, maxHeight));
        if (oldPreferredSize.width != maxWidth || oldPreferredSize.height != maxHeight) {
            this.getParent().invalidate();
            this.getParent().validate();
        }
        super.doLayout();
    }

    @Override
    public final void paint(Graphics g2) {
        boolean hasScrollbars = this.getScrollPane().getVerticalScrollBar().isVisible();
        if (hasScrollbars != this.hasScrollbars) {
            this.revalidate();
        }
        this.hasScrollbars = hasScrollbars;
        super.paint(g2);
    }

    @Override
    public final void mouseDragStart(CardPanel dragPanel, MouseEvent evt) {
        super.setDragged(true);
        super.mouseDragStart(dragPanel, evt);
        this.mouseDragStartX = dragPanel.getCardX();
        this.mouseDragStartY = dragPanel.getCardY();
        dragPanel.setDisplayEnabled(false);
        CardPanel.setDragAnimationPanel(new CardPanel(dragPanel.getMatchUI(), dragPanel.getCard()));
        RootPaneContainer frame = (RootPaneContainer)((Object)SwingUtilities.windowForComponent(this));
        JLayeredPane layeredPane = frame.getLayeredPane();
        layeredPane.add(CardPanel.getDragAnimationPanel());
        layeredPane.moveToFront(CardPanel.getDragAnimationPanel());
        Point p = SwingUtilities.convertPoint(this, this.mouseDragStartX, this.mouseDragStartY, layeredPane);
        CardPanel.getDragAnimationPanel().setCardBounds(p.x, p.y, dragPanel.getCardWidth(), dragPanel.getCardHeight());
    }

    @Override
    public final void mouseDragged(CardPanel dragPanel, int dragOffsetX, int dragOffsetY, MouseEvent evt) {
        super.mouseDragged(dragPanel, dragOffsetX, dragOffsetY, evt);
        int mouseX = evt.getX();
        int mouseY = evt.getY();
        int dragPanelX = mouseX + dragOffsetX;
        int dragPanelY = mouseY + dragOffsetY;
        Point p = SwingUtilities.convertPoint(this, dragPanelX, dragPanelY, CardPanel.getDragAnimationPanel().getParent());
        CardPanel.getDragAnimationPanel().setLocation(p.x, p.y);
        CardPanel panel = this.getCardPanel(mouseX, mouseY);
        if (panel == null || panel == dragPanel) {
            return;
        }
        int index = this.getCardPanels().size();
        while (--index >= 0 && this.getCardPanels().get(index) != panel) {
        }
        this.getCardPanels().remove(dragPanel);
        this.getCardPanels().add(index, dragPanel);
        this.mouseDragStartX = panel.getCardX();
        this.mouseDragStartY = panel.getCardY();
        this.revalidate();
    }

    @Override
    public final void mouseDragEnd(CardPanel dragPanel, MouseEvent evt) {
        super.setDragged(false);
        super.mouseDragEnd(dragPanel, evt);
        this.doLayout();
        JLayeredPane layeredPane = SwingUtilities.getRootPane(CardPanel.getDragAnimationPanel()).getLayeredPane();
        int startX = CardPanel.getDragAnimationPanel().getCardX();
        int startY = CardPanel.getDragAnimationPanel().getCardY();
        int startWidth = CardPanel.getDragAnimationPanel().getCardWidth();
        Point endPos = SwingUtilities.convertPoint(this, dragPanel.getCardLocation(), layeredPane);
        int endWidth = dragPanel.getCardWidth();
        Animation.moveCard(startX, startY, startWidth, endPos.x, endPos.y, endWidth, CardPanel.getDragAnimationPanel(), dragPanel, layeredPane, 200);
    }

    public final float getMaxCoverage() {
        return this.maxCoverage;
    }

    public final void setMaxCoverage(float maxCoverage) {
        this.maxCoverage = maxCoverage;
    }

    public final int getMaxRows() {
        return this.maxRows;
    }

    public final void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public final boolean isVertical() {
        return this.isVertical;
    }

    public final void setVertical(boolean isVertical) {
        this.isVertical = isVertical;
    }
}

