/*
 * Decompiled with CFR 0.152.
 */
package forge.view;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TimeLimitedCodeBlock {
    public static void runWithTimeout(Runnable runnable, long timeout, TimeUnit timeUnit) throws Exception {
        TimeLimitedCodeBlock.runWithTimeout(() -> {
            runnable.run();
            return null;
        }, timeout, timeUnit);
    }

    public static <T> T runWithTimeout(Callable<T> callable, long timeout, TimeUnit timeUnit) throws Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<T> future = executor.submit(callable);
        executor.shutdown();
        try {
            return future.get(timeout, timeUnit);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw e;
        }
        catch (ExecutionException e) {
            Throwable t2 = e.getCause();
            if (t2 instanceof Error) {
                throw (Error)t2;
            }
            if (t2 instanceof Exception) {
                throw (Exception)t2;
            }
            throw new IllegalStateException(t2);
        }
    }
}

