/*
 * Decompiled with CFR 0.152.
 */
package forge.view;

import forge.LobbyPlayer;
import forge.deck.Deck;
import forge.deck.DeckGroup;
import forge.deck.io.DeckSerializer;
import forge.game.Game;
import forge.game.GameEndReason;
import forge.game.GameLogEntry;
import forge.game.GameLogEntryType;
import forge.game.GameRules;
import forge.game.GameType;
import forge.game.Match;
import forge.game.player.RegisteredPlayer;
import forge.gamemodes.tournament.system.AbstractTournament;
import forge.gamemodes.tournament.system.TournamentBracket;
import forge.gamemodes.tournament.system.TournamentPairing;
import forge.gamemodes.tournament.system.TournamentPlayer;
import forge.gamemodes.tournament.system.TournamentRoundRobin;
import forge.gamemodes.tournament.system.TournamentSwiss;
import forge.localinstance.properties.ForgeConstants;
import forge.model.FModel;
import forge.player.GamePlayerUtil;
import forge.util.Lang;
import forge.util.TextUtil;
import forge.util.WordUtil;
import forge.util.storage.IStorage;
import forge.view.TimeLimitedCodeBlock;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.time.StopWatch;

public class SimulateMatch {
    public static void simulate(String[] args) {
        FModel.initialize(null, null);
        System.out.println("Simulation mode");
        if (args.length < 4) {
            SimulateMatch.argumentHelp();
            return;
        }
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        ArrayList<String> options = null;
        for (int i = 1; i < args.length; ++i) {
            String a = args[i];
            if (a.charAt(0) == '-') {
                if (a.length() < 2) {
                    System.err.println("Error at argument " + a);
                    SimulateMatch.argumentHelp();
                    return;
                }
                options = new ArrayList<String>();
                params.put(a.substring(1), options);
                continue;
            }
            if (options != null) {
                options.add(a);
                continue;
            }
            System.err.println("Illegal parameter usage");
            return;
        }
        int nGames = 1;
        if (params.containsKey("n")) {
            nGames = Integer.parseInt((String)((List)params.get("n")).get(0));
        }
        int matchSize = 0;
        if (params.containsKey("m")) {
            matchSize = Integer.parseInt((String)((List)params.get("m")).get(0));
        }
        boolean outputGamelog = !params.containsKey("q");
        GameType type = GameType.Constructed;
        if (params.containsKey("f")) {
            type = GameType.valueOf(WordUtil.capitalize((String)((List)params.get("f")).get(0)));
        }
        GameRules rules = new GameRules(type);
        rules.setAppliedVariants(EnumSet.of(type));
        if (matchSize != 0) {
            rules.setGamesPerMatch(matchSize);
        }
        if (params.containsKey("t")) {
            SimulateMatch.simulateTournament(params, rules, outputGamelog);
            System.out.flush();
            return;
        }
        ArrayList<RegisteredPlayer> pp = new ArrayList<RegisteredPlayer>();
        StringBuilder sb = new StringBuilder();
        int i = 1;
        if (params.containsKey("d")) {
            for (String deck : (List)params.get("d")) {
                Deck d = SimulateMatch.deckFromCommandLineParameter(deck, type);
                if (d == null) {
                    System.out.println(TextUtil.concatNoSpace("Could not load deck - ", deck, ", match cannot start"));
                    return;
                }
                if (i > 1) {
                    sb.append(" vs ");
                }
                String name = TextUtil.concatNoSpace("Ai(", String.valueOf(i), ")-", d.getName());
                sb.append(name);
                RegisteredPlayer rp = type.equals((Object)GameType.Commander) ? RegisteredPlayer.forCommander(d) : new RegisteredPlayer(d);
                rp.setPlayer(GamePlayerUtil.createAiPlayer(name, i - 1));
                pp.add(rp);
                ++i;
            }
        }
        sb.append(" - ").append(Lang.nounWithNumeral(nGames, "game")).append(" of ").append((Object)type);
        System.out.println(sb.toString());
        Match mc = new Match(rules, pp, "Test");
        if (matchSize != 0) {
            int iGame = 0;
            while (!mc.isMatchOver()) {
                SimulateMatch.simulateSingleMatch(mc, iGame, outputGamelog);
                ++iGame;
            }
        } else {
            for (int iGame = 0; iGame < nGames; ++iGame) {
                SimulateMatch.simulateSingleMatch(mc, iGame, outputGamelog);
            }
        }
        System.out.flush();
    }

    private static void argumentHelp() {
        System.out.println("Syntax: forge.exe sim -d <deck1[.dck]> ... <deckX[.dck]> -D [D] -n [N] -m [M] -t [T] -p [P] -f [F] -q");
        System.out.println("\tsim - stands for simulation mode");
        System.out.println("\tdeck1 (or deck2,...,X) - constructed deck name or filename (has to be quoted when contains multiple words)");
        System.out.println("\tdeck is treated as file if it ends with a dot followed by three numbers or letters");
        System.out.println("\tD - absolute directory to load decks from");
        System.out.println("\tN - number of games, defaults to 1 (Ignores match setting)");
        System.out.println("\tM - Play full match of X games, typically 1,3,5 games. (Optional, overrides N)");
        System.out.println("\tT - Type of tournament to run with all provided decks (Bracket, RoundRobin, Swiss)");
        System.out.println("\tP - Amount of players per match (used only with Tournaments, defaults to 2)");
        System.out.println("\tF - format of games, defaults to constructed");
        System.out.println("\tq - Quiet flag. Output just the game result, not the entire game log.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void simulateSingleMatch(Match mc, int iGame, boolean outputGamelog) {
        StopWatch sw = new StopWatch();
        sw.start();
        Game g1 = mc.createGame();
        try {
            TimeLimitedCodeBlock.runWithTimeout(() -> {
                mc.startGame(g1);
                sw.stop();
            }, 120L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            System.out.println("Stopping slow match as draw");
        }
        catch (Exception | StackOverflowError e) {
            e.printStackTrace();
        }
        finally {
            if (sw.isStarted()) {
                sw.stop();
            }
            if (!g1.isGameOver()) {
                g1.setGameOver(GameEndReason.Draw);
            }
        }
        List<GameLogEntry> log = outputGamelog ? g1.getGameLog().getLogEntries(null) : g1.getGameLog().getLogEntries(GameLogEntryType.MATCH_RESULTS);
        Collections.reverse(log);
        for (GameLogEntry l : log) {
            System.out.println(l);
        }
        if (g1.getOutcome().isDraw()) {
            System.out.printf("\nGame Result: Game %d ended in a Draw! Took %d ms.%n", 1 + iGame, sw.getTime());
        } else {
            System.out.printf("\nGame Result: Game %d ended in %d ms. %s has won!\n%n", 1 + iGame, sw.getTime(), g1.getOutcome().getWinningLobbyPlayer().getName());
        }
    }

    private static void simulateTournament(Map<String, List<String>> params, GameRules rules, boolean outputGamelog) {
        String tournament = params.get("t").get(0);
        AbstractTournament tourney = null;
        int matchPlayers = params.containsKey("p") ? Integer.parseInt(params.get("p").get(0)) : 2;
        DeckGroup deckGroup = new DeckGroup("SimulatedTournament");
        ArrayList<TournamentPlayer> players = new ArrayList<TournamentPlayer>();
        int numPlayers = 0;
        if (params.containsKey("d")) {
            for (String deck : params.get("d")) {
                File[] d = SimulateMatch.deckFromCommandLineParameter(deck, rules.getGameType());
                if (d == null) {
                    System.out.println(TextUtil.concatNoSpace("Could not load deck - ", deck, ", match cannot start"));
                    return;
                }
                deckGroup.addAiDeck((Deck)d);
                players.add(new TournamentPlayer(GamePlayerUtil.createAiPlayer(d.getName(), 0), numPlayers));
                ++numPlayers;
            }
        }
        if (params.containsKey("D")) {
            String foldName = params.get("D").get(0);
            File folder = new File(foldName);
            if (!folder.isDirectory()) {
                System.out.println("Directory not found - " + foldName);
            } else {
                for (File deck : folder.listFiles((dir, name) -> name.endsWith(".dck"))) {
                    Deck d = DeckSerializer.fromFile(deck);
                    if (d == null) {
                        System.out.println(TextUtil.concatNoSpace("Could not load deck - ", deck.getName(), ", match cannot start"));
                        return;
                    }
                    deckGroup.addAiDeck(d);
                    players.add(new TournamentPlayer(GamePlayerUtil.createAiPlayer(d.getName(), 0), numPlayers));
                    ++numPlayers;
                }
            }
        }
        if (numPlayers == 0) {
            System.out.println("No decks/Players found. Please try again.");
        }
        if ("bracket".equalsIgnoreCase(tournament)) {
            tourney = new TournamentBracket(players, matchPlayers);
        } else if ("roundrobin".equalsIgnoreCase(tournament)) {
            tourney = new TournamentRoundRobin(players, matchPlayers);
        } else if ("swiss".equalsIgnoreCase(tournament)) {
            tourney = new TournamentSwiss(players, matchPlayers);
        }
        if (tourney == null) {
            System.out.println("Failed to initialize tournament, bailing out");
            return;
        }
        tourney.initializeTournament();
        String lastWinner = "";
        int curRound = 0;
        System.out.println(TextUtil.concatNoSpace("Starting a ", tournament, " tournament with ", String.valueOf(numPlayers), " players over ", String.valueOf(tourney.getTotalRounds()), " rounds"));
        while (!tourney.isTournamentOver()) {
            if (tourney.getActiveRound() != curRound) {
                if (curRound != 0) {
                    System.out.println(TextUtil.concatNoSpace("End Round - ", String.valueOf(curRound)));
                }
                curRound = tourney.getActiveRound();
                System.out.println();
                System.out.println(TextUtil.concatNoSpace("Round ", String.valueOf(curRound), " Pairings:"));
                for (TournamentPairing pairing : tourney.getActivePairings()) {
                    System.out.println(pairing.outputHeader());
                }
                System.out.println();
            }
            TournamentPairing pairing = tourney.getNextPairing();
            List<RegisteredPlayer> regPlayers = AbstractTournament.registerTournamentPlayers(pairing, deckGroup);
            StringBuilder sb = new StringBuilder();
            sb.append("Round ").append(tourney.getActiveRound()).append(" - ");
            sb.append(pairing.outputHeader());
            System.out.println(sb.toString());
            if (!pairing.isBye()) {
                Match mc = new Match(rules, regPlayers, "TourneyMatch");
                int exceptions = 0;
                int iGame = 0;
                while (!mc.isMatchOver()) {
                    try {
                        SimulateMatch.simulateSingleMatch(mc, iGame, outputGamelog);
                        ++iGame;
                    }
                    catch (Exception e) {
                        System.out.println(e.toString());
                        if (++exceptions > 5) {
                            System.out.println("Exceeded number of exceptions thrown. Abandoning match...");
                            break;
                        }
                        System.out.println("Game threw exception. Abandoning game and continuing...");
                    }
                }
                LobbyPlayer winner = mc.getWinner().getPlayer();
                for (TournamentPlayer tp : pairing.getPairedPlayers()) {
                    if (!winner.equals(tp.getPlayer())) continue;
                    pairing.setWinner(tp);
                    lastWinner = winner.getName();
                    System.out.println(TextUtil.concatNoSpace("Match Winner - ", lastWinner, "!"));
                    System.out.println();
                    break;
                }
            }
            tourney.reportMatchCompletion(pairing);
        }
        tourney.outputTournamentResults();
    }

    public static Match simulateOffthreadGame(List<Deck> decks, GameType format, int games) {
        return null;
    }

    private static Deck deckFromCommandLineParameter(String deckname, GameType type) {
        int dotpos = deckname.lastIndexOf(46);
        if (dotpos > 0 && dotpos == deckname.length() - 4) {
            String baseDir = type.equals((Object)GameType.Commander) ? ForgeConstants.DECK_COMMANDER_DIR : ForgeConstants.DECK_CONSTRUCTED_DIR;
            File f = new File(baseDir + deckname);
            if (!f.exists()) {
                System.out.println("No deck found in " + baseDir);
            }
            return DeckSerializer.fromFile(f);
        }
        IStorage<Deck> deckStore = null;
        deckStore = type.equals((Object)GameType.Commander) ? FModel.getDecks().getCommander() : FModel.getDecks().getConstructed();
        return deckStore.get(deckname);
    }
}

