/*
 * Decompiled with CFR 0.152.
 */
package forge.view;

import forge.GuiDesktop;
import forge.Singletons;
import forge.error.ExceptionHandler;
import forge.gui.GuiBase;
import forge.gui.card.CardReaderExperiments;
import forge.util.BuildInfo;
import forge.view.SimulateMatch;
import io.sentry.Sentry;

public final class Main {
    public static void main(String[] args) {
        String mode;
        Sentry.init(options -> {
            options.setEnableExternalConfiguration(true);
            options.setRelease(BuildInfo.getVersionString());
            options.setEnvironment(System.getProperty("os.name"));
            options.setTag("Java Version", System.getProperty("java.version"));
        }, true);
        System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
        System.setProperty("sun.java2d.d3d", "false");
        GuiBase.setInterface(new GuiDesktop());
        ExceptionHandler.registerErrorHandling();
        if (args.length == 0) {
            Singletons.initializeOnce(true);
            Singletons.getControl().initialize();
            return;
        }
        switch (mode = args[0].toLowerCase()) {
            case "sim": {
                SimulateMatch.simulate(args);
                break;
            }
            case "parse": {
                CardReaderExperiments.parseAllCards(args);
                break;
            }
            case "server": {
                System.out.println("Dedicated server mode.\nNot implemented.");
                break;
            }
            default: {
                System.out.println("Unknown mode.\nKnown mode is 'sim', 'parse' ");
            }
        }
        System.exit(0);
    }

    protected void finalize() throws Throwable {
        try {
            ExceptionHandler.unregisterErrorHandling();
        }
        finally {
            super.finalize();
        }
    }

    private Main() {
    }
}

