/*
 * Decompiled with CFR 0.152.
 */
package forge.view;

import com.google.common.collect.Lists;
import forge.Singletons;
import forge.gui.ImportDialog;
import forge.gui.SOverlayUtils;
import forge.gui.UiCommand;
import forge.gui.framework.DragCell;
import forge.gui.framework.EDocID;
import forge.gui.framework.FScreen;
import forge.gui.framework.ICDoc;
import forge.gui.framework.IVDoc;
import forge.gui.framework.SLayoutIO;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.properties.ForgePreferences;
import forge.localinstance.skin.FSkinProp;
import forge.model.FModel;
import forge.screens.bazaar.VBazaarUI;
import forge.screens.deckeditor.VDeckEditorUI;
import forge.screens.home.VHomeUI;
import forge.sound.MusicPlaylist;
import forge.sound.SoundSystem;
import forge.toolbox.CardFaceSymbols;
import forge.toolbox.FAbsolutePositioner;
import forge.toolbox.FButton;
import forge.toolbox.FLabel;
import forge.toolbox.FOptionPane;
import forge.toolbox.FOverlay;
import forge.toolbox.FPanel;
import forge.toolbox.FProgressBar;
import forge.toolbox.FScrollPane;
import forge.toolbox.FSkin;
import forge.util.BuildInfo;
import forge.util.RuntimeVersion;
import forge.view.FDialog;
import forge.view.FFrame;
import forge.view.FNavigationBar;
import forge.view.SplashFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;

public enum FView {
    SINGLETON_INSTANCE;

    public static final Integer DIALOG_BACKDROP_LAYER;
    public static final Integer NAVIGATION_BAR_LAYER;
    public static final Integer NAVIGATION_BAR_REVEAL_LAYER;
    public static final Integer OVERLAY_LAYER;
    public static final Integer TARGETING_LAYER;
    private final List<DragCell> allCells = new ArrayList<DragCell>();
    private SplashFrame frmSplash;
    private final FFrame frmDocument = new FFrame();
    private final FSkin.SkinnedLayeredPane lpnDocument = new FSkin.SkinnedLayeredPane();
    private FNavigationBar navigationBar;
    private final JPanel pnlContent = new JPanel();
    private FPanel pnlInsets;
    private final JPanel pnlPreview = new PreviewPanel();
    private final JPanel pnlTabOverflow = new JPanel(new MigLayout("insets 0, gap 0, wrap"));

    private FView() {
        this.frmSplash = new SplashFrame();
        this.frmDocument.setTitle("Forge: " + BuildInfo.getVersionString());
        JOptionPane.setRootFrame(this.frmDocument);
    }

    public void initialize() {
        RuntimeVersion javaVersion;
        this.pnlInsets = new FPanel(new BorderLayout());
        this.pnlInsets.setBorderToggle(false);
        this.navigationBar = new FNavigationBar(this.frmDocument);
        this.frmDocument.initialize(this.navigationBar);
        this.frmDocument.setMinimumSize(new Dimension(800, 600));
        this.frmDocument.setLocationRelativeTo(null);
        this.frmDocument.setDefaultCloseOperation(2);
        this.frmDocument.setIconImage(FSkin.getIcon(FSkinProp.ICO_FAVICON));
        this.frmDocument.setContentPane(this.lpnDocument);
        this.lpnDocument.add((Component)this.pnlInsets, (Object)1);
        FAbsolutePositioner.SINGLETON_INSTANCE.initialize(this.lpnDocument, 2);
        this.lpnDocument.add((Component)this.pnlPreview, (Object)3);
        this.lpnDocument.add((Component)this.pnlTabOverflow, (Object)4);
        this.lpnDocument.add((Component)this.navigationBar, NAVIGATION_BAR_LAYER);
        this.lpnDocument.add((Component)this.navigationBar.getPnlReveal(), NAVIGATION_BAR_REVEAL_LAYER);
        this.lpnDocument.add((Component)FOverlay.SINGLETON_INSTANCE.getPanel(), OVERLAY_LAYER);
        this.lpnDocument.add((Component)FDialog.getBackdropPanel(), DIALOG_BACKDROP_LAYER);
        this.pnlInsets.add((Component)this.pnlContent, "Center");
        this.pnlInsets.setBackgroundTexture(FSkin.getIcon(FSkinProp.BG_TEXTURE));
        this.pnlInsets.setCornerDiameter(0);
        this.pnlInsets.setBorder(new EmptyBorder(5, 5, 0, 0));
        this.pnlContent.setOpaque(false);
        this.pnlContent.setLayout(null);
        FOverlay.SINGLETON_INSTANCE.getPanel().setBackground(FSkin.getColor(FSkin.Colors.CLR_OVERLAY));
        FView.cacheUIStates();
        CardFaceSymbols.loadImages();
        for (EDocID doc : EDocID.values()) {
            IVDoc<? extends ICDoc> d = doc.getDoc();
            if (d == null) continue;
            d.getLayoutControl().initialize();
        }
        Singletons.getControl().setCurrentScreen(FScreen.HOME_SCREEN);
        this.frmSplash.dispose();
        this.frmSplash = null;
        SLayoutIO.loadWindowLayout();
        this.frmDocument.setVisible(true);
        HashSet<File> profileDirs = new HashSet<File>();
        for (String dname : ForgeConstants.PROFILE_DIRS) {
            profileDirs.add(new File(dname));
        }
        ArrayList<File> resDirs = new ArrayList<File>();
        for (String resDir : Lists.newArrayList("decks", "gauntlet", "layouts", "pics", "preferences", "quest/data")) {
            resDirs.add(new File("res", resDir));
        }
        HashSet<File> doNotDeleteDirs = new HashSet<File>();
        for (String dir : Lists.newArrayList("decks", "decks/constructed", "decks/draft", "decks/plane", "decks/scheme", "decks/sealed", "gauntlet", "layouts", "pics", "preferences", "quest/data")) {
            doNotDeleteDirs.add(new File("res", dir));
        }
        if (FView._addRemainingFiles(null, resDirs, profileDirs, doNotDeleteDirs)) {
            new ImportDialog("res", () -> {
                for (String cruftFile : Lists.newArrayList("decks/SkieraCube-cards_not_supported_yet.txt", "decks/cube/ArabianExtended.dck", "decks/cube/GtcGuildBoros.dck", "decks/cube/GtcGuildDimir.dck", "decks/cube/GtcGuildGruul.dck", "decks/cube/GtcGuildOrzhov.dck", "decks/cube/GtcGuildSimic.dck", "decks/cube/GtcPromoBoros.dck", "decks/cube/GtcPromoDimir.dck", "decks/cube/GtcPromoGruul.dck", "decks/cube/GtcPromoOrzhov.dck", "decks/cube/GtcPromoSimic.dck", "decks/cube/JuzamjediCube.dck", "decks/cube/RtRGuildAzorius.dck", "decks/cube/RtRGuildGolgari.dck", "decks/cube/RtRGuildIzzet.dck", "decks/cube/RtRGuildRakdos.dck", "decks/cube/RtRGuildSelesnya.dck", "decks/cube/RtRPromoAzorius.dck", "decks/cube/RtRPromoGolgari.dck", "decks/cube/RtRPromoIzzet.dck", "decks/cube/RtRPromoRakdos.dck", "decks/cube/RtRPromoSelesnya.dck", "decks/cube/SkieraCube.dck", "gauntlet/LOCKED_DotP Preconstructed.dat", "gauntlet/LOCKED_Swimming With Sharks.dat", "layouts/editor_default.xml", "layouts/home_default.xml", "layouts/match_default.xml", "pics/snow_covered_forest1.jpg", "pics/snow_covered_forest2.jpg", "pics/snow_covered_forest3.jpg", "pics/snow_covered_island1.jpg", "pics/snow_covered_island2.jpg", "pics/snow_covered_island3.jpg", "pics/snow_covered_mountain1.jpg", "pics/snow_covered_mountain2.jpg", "pics/snow_covered_mountain3.jpg", "pics/snow_covered_plains1.jpg", "pics/snow_covered_plains2.jpg", "pics/snow_covered_plains3.jpg", "pics/snow_covered_swamp1.jpg", "pics/snow_covered_swamp2.jpg", "pics/snow_covered_swamp3.jpg", "pics/VAN/Birds of Paradise Avatar.full.jpg", "pics/VAN/Erhnam Djinn Avatar.full.jpg", "pics/VAN/Goblin Warchief Avatar.full.jpg", "pics/VAN/Grinning Demon Avatar.full.jpg", "pics/VAN/Platinum Angel Avatar.full.jpg", "pics/VAN/Prodigal Sorcerer Avatar.full.jpg", "pics/VAN/Rith, the Awakener Avatar.full.jpg", "pics/VAN/Royal Assassin Avatar.full.jpg", "pics/VAN/Serra Angel Avatar.full.jpg", "pics/VAN/Tradewind Rider Avatar.full.jpg", "pics_product/10E.jpg", "pics_product/2ED.jpg", "pics_product/3ED.jpg", "pics_product/4ED.jpg", "pics_product/5DN.jpg", "pics_product/5ED.jpg", "pics_product/6ED.jpg", "pics_product/7ED.jpg", "pics_product/8ED.jpg", "pics_product/9ED.jpg", "pics_product/ALA.jpg", "pics_product/ALL.jpg", "pics_product/APC.jpg", "pics_product/ARB.jpg", "pics_product/ARN.jpg", "pics_product/ATQ.jpg", "pics_product/BOK.jpg", "pics_product/CFX.jpg", "pics_product/CHK.jpg", "pics_product/CHR.jpg", "pics_product/CSP.jpg", "pics_product/DIS.jpg", "pics_product/DKA.jpg", "pics_product/DRK.jpg", "pics_product/DST.jpg", "pics_product/EVE.jpg", "pics_product/EXO.jpg", "pics_product/FEM.jpg", "pics_product/FUT.jpg", "pics_product/GPT.jpg", "pics_product/HML.jpg", "pics_product/ICE.jpg", "pics_product/INV.jpg", "pics_product/ISD.jpg", "pics_product/JUD.jpg", "pics_product/LEA.jpg", "pics_product/LEB.jpg", "pics_product/LEG.jpg", "pics_product/LGN.jpg", "pics_product/LRW.jpg", "pics_product/M10.jpg", "pics_product/M11.jpg", "pics_product/M12.jpg", "pics_product/MBS.jpg", "pics_product/MIR.jpg", "pics_product/MMQ.jpg", "pics_product/MOR.jpg", "pics_product/MRD.jpg", "pics_product/NMS.jpg", "pics_product/NPH.jpg", "pics_product/ODY.jpg", "pics_product/ONS.jpg", "pics_product/PCY.jpg", "pics_product/PLC.jpg", "pics_product/PLS.jpg", "pics_product/PO2.jpg", "pics_product/POR.jpg", "pics_product/PTK.jpg", "pics_product/RAV.jpg", "pics_product/ROE.jpg", "pics_product/S99.jpg", "pics_product/SCG.jpg", "pics_product/SHM.jpg", "pics_product/SOK.jpg", "pics_product/SOM.jpg", "pics_product/STH.jpg", "pics_product/TMP.jpg", "pics_product/TOR.jpg", "pics_product/TSP.jpg", "pics_product/UDS.jpg", "pics_product/ULG.jpg", "pics_product/USG.jpg", "pics_product/VIS.jpg", "pics_product/WTH.jpg", "pics_product/WWK.jpg", "pics_product/ZEN.jpg", "pics_product/booster/7E.png", "pics_product/booster/AP.png", "pics_product/booster/DPA.png", "pics_product/booster/EX.png", "pics_product/booster/IN.png", "pics_product/booster/MI.png", "pics_product/booster/OD.png", "pics_product/booster/PS.png", "pics_product/booster/ST.png", "pics_product/booster/TE.png", "pics_product/booster/UD.png", "pics_product/booster/UL.png", "pics_product/booster/UZ.png", "pics_product/booster/VI.png", "pics_product/booster/WL.png", "preferences/.project", "preferences/editor.default.preferences", "preferences/main.properties", "quest/quest.preferences", "quest/quest.properties")) {
                    new File("res", cruftFile).delete();
                }
                LinkedList<File> remainingFiles = new LinkedList<File>();
                FView._addRemainingFiles(remainingFiles, resDirs, profileDirs, doNotDeleteDirs);
                FPanel p = new FPanel(new MigLayout("insets dialog, gap 10, center, wrap"));
                p.setOpaque(false);
                p.setBackgroundTexture(FSkin.getIcon(FSkinProp.BG_TEXTURE));
                if (remainingFiles.isEmpty()) {
                    p.add(new FLabel.Builder().text("<html>You're done!  It looks like everything went smoothly.  Now just restart Forge to load the data from its new home!  Note that there is more data available from the downloaders now.  You might want to run through the content downloaders to check for new files.</html>").build());
                } else {
                    p.add(new FLabel.Builder().text("<html>There seem to be a few files left over in your old data directories.  They should be deleted or moved somewhere else to avoid having the data migration prompt pop up again!</html>").build());
                    JTextArea files = new JTextArea(StringUtils.join(remainingFiles, '\n'));
                    files.setFont(new Font("Monospaced", 0, 10));
                    files.setOpaque(false);
                    files.setWrapStyleWord(true);
                    files.setLineWrap(true);
                    files.setEditable(false);
                    FScrollPane scroller = new FScrollPane(files, true);
                    p.add((Component)scroller, "w 600:100%:100%, h 100:100%:100%, gaptop 10");
                    SwingUtilities.invokeLater(() -> {
                        p.getParent().validate();
                        p.getParent().invalidate();
                    });
                }
                FButton btnOk = new FButton(remainingFiles.isEmpty() ? "Restart Forge" : "Close Forge");
                btnOk.addActionListener(e -> {
                    if (remainingFiles.isEmpty()) {
                        Singletons.getControl().restartForge();
                    } else {
                        Singletons.getControl().exitForge();
                    }
                });
                p.add((Component)btnOk, "center, w pref+64!, h pref+12!, gaptop 20");
                FSkin.SkinnedPanel overlay = FOverlay.SINGLETON_INSTANCE.getPanel();
                overlay.setLayout(new MigLayout("insets 0, gap 0, wrap, ax center, ay center"));
                overlay.add((Component)p, "w 100::80%, h 50::90%");
                SOverlayUtils.showOverlay();
                SwingUtilities.invokeLater(btnOk::requestFocusInWindow);
            }).show();
        }
        if ((javaVersion = RuntimeVersion.of(System.getProperty("java.version"))).getMajor() < 9 && javaVersion.getMinor() < 8 && !FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.DISABLE_DISPLAY_JAVA_8_UPDATE_WARNING)) {
            Desktop desktop;
            FSkin.SkinnedPanel updateWarningOverlay = FOverlay.SINGLETON_INSTANCE.getPanel();
            updateWarningOverlay.setLayout(new GridBagLayout());
            FPanel updateWarningContentPanel = new FPanel(new MigLayout("insets 20, wrap 3"));
            JTextPane textPane = new JTextPane();
            StyledDocument text = textPane.getStyledDocument();
            Style normalStyle = text.addStyle("normal", null);
            Style boldStyle = text.addStyle("bold", null);
            StyleConstants.setBold(normalStyle, false);
            StyleConstants.setBold(boldStyle, true);
            try {
                text.insertString(text.getLength(), "The next version of Forge will require ", normalStyle);
                text.insertString(text.getLength(), "Java 1.8", boldStyle);
                text.insertString(text.getLength(), " and will ", normalStyle);
                text.insertString(text.getLength(), "no longer run", boldStyle);
                text.insertString(text.getLength(), " on Java 1.7. You appear to be running Forge with version ", normalStyle);
                text.insertString(text.getLength(), javaVersion.toString(), boldStyle);
                text.insertString(text.getLength(), ".\n\nPlease upgrade to the latest version of Java if you plan to update Forge in the future.", normalStyle);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            textPane.setEditable(false);
            textPane.setOpaque(false);
            textPane.setForeground(FSkin.getColor(FSkin.Colors.CLR_TEXT).getColor());
            textPane.setBorder(null);
            textPane.setFont(FSkin.getRelativeFont(14).getBaseFont());
            FLabel btnRemindMeLater = new FLabel.Builder().text("Remind Me Later").hoverable().opaque().build();
            FLabel btnDoNotRemindMe = new FLabel.Builder().text("Don't Remind Me Again").hoverable().opaque().build();
            FLabel btnDownloadLatestJava = new FLabel.Builder().text("Download Latest Java").hoverable().opaque().build();
            String buttonConstraints = "w 200px!, h 30px!";
            updateWarningContentPanel.add((Component)textPane, "w 600px!, h 100px!, span 3 1");
            updateWarningContentPanel.add((Component)btnRemindMeLater, buttonConstraints);
            updateWarningContentPanel.add((Component)btnDoNotRemindMe, buttonConstraints + ", gap 10px 10px 0 0");
            Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
            if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                updateWarningContentPanel.add((Component)btnDownloadLatestJava, buttonConstraints);
            }
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.weighty = 1.0;
            constraints.weightx = 1.0;
            updateWarningOverlay.add((Component)updateWarningContentPanel, constraints);
            btnRemindMeLater.setCommand(new UiCommand(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run() {
                    SOverlayUtils.hideOverlay();
                }
            });
            btnDoNotRemindMe.setCommand(new UiCommand(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run() {
                    if (FOptionPane.showConfirmDialog("Are you sure? You can re-enable this warning in Forge's general preferences.")) {
                        FModel.getPreferences().setPref(ForgePreferences.FPref.DISABLE_DISPLAY_JAVA_8_UPDATE_WARNING, true);
                        FModel.getPreferences().save();
                        SOverlayUtils.hideOverlay();
                    }
                }
            });
            btnDownloadLatestJava.setCommand(new UiCommand(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run() {
                    try {
                        assert (desktop != null);
                        desktop.browse(new URI("http://www.oracle.com/technetwork/java/javase/downloads/jre8-downloads-2133155.html"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            SwingUtilities.invokeLater(() -> {
                SOverlayUtils.showOverlay();
                SwingUtilities.invokeLater(btnRemindMeLater::requestFocusInWindow);
            });
        }
        SoundSystem.instance.setBackgroundMusic(MusicPlaylist.MENUS);
    }

    private static boolean _addRemainingFiles(List<File> remainingFiles, List<File> dirRoots, Set<File> profileDirs, Set<File> doNotDeleteDirs) {
        LinkedList<File> stack = new LinkedList<File>(dirRoots);
        HashSet<File> seenDirs = new HashSet<File>();
        boolean ret = false;
        while (!stack.isEmpty()) {
            File cur = (File)stack.peek();
            if (profileDirs.contains(cur)) {
                stack.pop();
                continue;
            }
            if (seenDirs.contains(cur)) {
                cur = (File)stack.pop();
                if (!cur.exists() || doNotDeleteDirs.contains(cur)) continue;
                cur.delete();
                continue;
            }
            seenDirs.add(cur);
            File[] curListing = cur.listFiles();
            if (null == curListing) continue;
            for (File f : curListing) {
                if (f.isDirectory()) {
                    if (".svn".equals(f.getName())) continue;
                    stack.push(f);
                    continue;
                }
                if (null == remainingFiles) {
                    return true;
                }
                remainingFiles.add(f);
                ret = true;
            }
        }
        return ret;
    }

    public SplashFrame getSplash() {
        return this.frmSplash;
    }

    public FFrame getFrame() {
        return this.frmDocument;
    }

    public FSkin.SkinnedLayeredPane getLpnDocument() {
        return this.lpnDocument;
    }

    public FNavigationBar getNavigationBar() {
        return this.navigationBar;
    }

    public FPanel getPnlInsets() {
        return this.pnlInsets;
    }

    public JPanel getPnlContent() {
        return this.pnlContent;
    }

    public JPanel getPnlPreview() {
        return this.pnlPreview;
    }

    public JPanel getPnlTabOverflow() {
        return this.pnlTabOverflow;
    }

    public List<DragCell> getDragCells() {
        ArrayList<DragCell> clone = new ArrayList<DragCell>(this.allCells);
        return clone;
    }

    public void addDragCell(DragCell pnl0) {
        this.allCells.add(pnl0);
        this.pnlContent.add(pnl0);
    }

    public void removeDragCell(DragCell pnl0) {
        this.allCells.remove(pnl0);
        this.pnlContent.remove(pnl0);
    }

    public void removeAllDragCells() {
        this.allCells.clear();
        this.pnlContent.removeAll();
    }

    private static void cacheUIStates() {
        VHomeUI.SINGLETON_INSTANCE.instantiate();
        VDeckEditorUI.SINGLETON_INSTANCE.instantiate();
        VBazaarUI.SINGLETON_INSTANCE.instantiate();
    }

    public void incrementSplashProgessBar(int value) {
        if (this.frmSplash == null) {
            return;
        }
        this.frmSplash.getProgressBar().setValueThreadSafe(value);
    }

    public void setSplashProgessBarMessage(String message) {
        this.setSplashProgessBarMessage(message, 0);
    }

    public void setSplashProgessBarMessage(String message, int cnt) {
        if (this.frmSplash == null) {
            return;
        }
        FProgressBar progressBar = this.frmSplash.getProgressBar();
        SwingUtilities.invokeLater(() -> {
            if (cnt > 0) {
                progressBar.reset();
                progressBar.setMaximum(cnt);
            }
            progressBar.setShowETA(false);
            progressBar.setShowCount(cnt > 0);
            progressBar.setDescription(message);
        });
    }

    public void refreshAllCellLayouts(boolean showTabs) {
        for (DragCell cell : this.allCells) {
            cell.doCellLayout(showTabs);
        }
    }

    static {
        DIALOG_BACKDROP_LAYER = JLayeredPane.MODAL_LAYER - 1;
        NAVIGATION_BAR_LAYER = DIALOG_BACKDROP_LAYER - 1;
        NAVIGATION_BAR_REVEAL_LAYER = NAVIGATION_BAR_LAYER - 1;
        OVERLAY_LAYER = NAVIGATION_BAR_REVEAL_LAYER - 1;
        TARGETING_LAYER = OVERLAY_LAYER - 1;
    }

    class PreviewPanel
    extends JPanel {
        public PreviewPanel() {
            this.setOpaque(false);
            this.setVisible(false);
            this.setBorder(new LineBorder(Color.DARK_GRAY, 2));
        }

        @Override
        public void paintComponent(Graphics g2) {
            super.paintComponent(g2);
            g2.setColor(new Color(0, 0, 0, 50));
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

