/*
 * Decompiled with CFR 0.152.
 */
package forge.view;

import forge.gui.framework.ILocalRepaint;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import forge.view.FDialog;
import forge.view.FFrame;
import forge.view.ITitleBarOwner;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;

public abstract class FTitleBarBase
extends FSkin.SkinnedMenuBar {
    protected static final int visibleHeight = 27;
    protected static final FSkin.SkinColor foreColor = FSkin.getColor(FSkin.Colors.CLR_TEXT);
    protected static final FSkin.SkinColor backColor = FSkin.getColor(FSkin.Colors.CLR_THEME2);
    protected static final FSkin.SkinColor bottomEdgeColor = FSkin.getColor(FSkin.Colors.CLR_BORDERS).stepColor(0);
    protected static final FSkin.SkinColor buttonBorderColor = backColor.stepColor(-80);
    protected static final FSkin.SkinColor buttonHoverColor = backColor.stepColor(40);
    protected static final FSkin.SkinColor buttonDownColor = backColor.stepColor(-40);
    protected static final FSkin.SkinColor buttonToggleColor = backColor.stepColor(-30);
    protected final ITitleBarOwner owner;
    protected final SpringLayout layout = new SpringLayout();
    protected final LockTitleBarButton btnLockTitleBar = new LockTitleBarButton();
    protected final MinimizeButton btnMinimize = new MinimizeButton();
    protected final FullScreenButton btnFullScreen = new FullScreenButton();
    protected final MaximizeButton btnMaximize = new MaximizeButton();
    protected final CloseButton btnClose = new CloseButton();

    protected FTitleBarBase(ITitleBarOwner owner0) {
        this.owner = owner0;
        this.setVisible(false);
        this.setLayout(this.layout);
        this.setBackground(backColor);
    }

    protected void addControls() {
        if (this.owner instanceof FFrame) {
            this.add(this.btnClose);
            this.layout.putConstraint("East", (Component)this.btnClose, 0, "East", (Component)this);
            this.layout.putConstraint("South", (Component)this.btnClose, 0, "South", (Component)this);
            this.add(this.btnMaximize);
            this.layout.putConstraint("East", (Component)this.btnMaximize, 0, "West", (Component)this.btnClose);
            this.layout.putConstraint("South", (Component)this.btnMaximize, 0, "South", (Component)this.btnClose);
            this.add(this.btnFullScreen);
            this.layout.putConstraint("East", (Component)this.btnFullScreen, 0, "West", (Component)this.btnMaximize);
            this.layout.putConstraint("South", (Component)this.btnFullScreen, 0, "South", (Component)this.btnMaximize);
            this.add(this.btnMinimize);
            this.layout.putConstraint("East", (Component)this.btnMinimize, 0, "West", (Component)this.btnFullScreen);
            this.layout.putConstraint("South", (Component)this.btnMinimize, 0, "South", (Component)this.btnFullScreen);
            this.add(this.btnLockTitleBar);
            this.layout.putConstraint("East", (Component)this.btnLockTitleBar, 0, "West", (Component)this.btnMinimize);
            this.layout.putConstraint("South", (Component)this.btnLockTitleBar, 0, "South", (Component)this.btnMinimize);
        } else {
            int offset = this.owner instanceof FDialog && ((FDialog)this.owner).allowResize() ? 0 : -1;
            this.add(this.btnClose);
            this.layout.putConstraint("East", (Component)this.btnClose, offset, "East", (Component)this);
            this.layout.putConstraint("South", (Component)this.btnClose, 0, "South", (Component)this);
        }
    }

    public abstract void setTitle(String var1);

    public abstract void setIconImage(Image var1);

    public void updateButtons() {
        boolean fullScreen = this.owner.isFullScreen();
        this.btnLockTitleBar.setVisible(fullScreen);
        this.btnMaximize.setVisible(!fullScreen);
        if (fullScreen) {
            this.layout.putConstraint("East", (Component)this.btnFullScreen, 0, "West", (Component)this.btnClose);
            this.btnFullScreen.setToolTipText(Localizer.getInstance().getMessage("lblExitFullScreen", new Object[0]) + " (F11)");
            if (this.owner.getLockTitleBar()) {
                this.btnLockTitleBar.setToolTipText(Localizer.getInstance().getMessage("lblUnlockTitleBar", new Object[0]));
            } else {
                this.btnLockTitleBar.setToolTipText(Localizer.getInstance().getMessage("lblLockTitleBar", new Object[0]));
            }
            this.btnLockTitleBar.repaintSelf();
        } else {
            this.layout.putConstraint("East", (Component)this.btnFullScreen, 0, "West", (Component)this.btnMaximize);
            this.btnFullScreen.setToolTipText(Localizer.getInstance().getMessage("lblFullScreen", new Object[0]) + " (F11)");
            if (this.owner.isMaximized()) {
                this.btnMaximize.setToolTipText(Localizer.getInstance().getMessage("lblRestoreDown", new Object[0]));
            } else {
                this.btnMaximize.setToolTipText(Localizer.getInstance().getMessage("lblMaximize", new Object[0]));
            }
            this.btnMaximize.repaintSelf();
        }
        this.btnFullScreen.repaintSelf();
    }

    @Override
    public void setVisible(boolean visible) {
        this.setPreferredSize(new Dimension(this.owner.getWidth(), visible ? 27 : 0));
        this.revalidate();
    }

    public class CloseButton
    extends TitleBarButton {
        private CloseButton() {
            this.setToolTipText(Localizer.getInstance().getMessage("lblClose", new Object[0]));
        }

        @Override
        protected void onClick() {
            WindowEvent wev = new WindowEvent((Window)((Object)FTitleBarBase.this.owner), 201);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(wev);
        }

        @Override
        public void paintComponent(Graphics g2) {
            int offset;
            super.paintComponent(g2);
            int thickness = 2;
            int x1 = offset = 7;
            int y1 = offset;
            int x2 = this.getWidth() - offset - 1;
            int y2 = this.getHeight() - offset - 1;
            FSkin.SkinColor iconColor = foreColor;
            if (!this.isEnabled()) {
                iconColor = iconColor.alphaColor(100);
            }
            Graphics2D g2d = (Graphics2D)g2;
            FSkin.setGraphicsColor(g2d, iconColor);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setStroke(new BasicStroke(thickness));
            g2d.drawLine(x1, y1, x2, y2);
            g2d.drawLine(x2, y1, x1, y2);
        }
    }

    public class MaximizeButton
    extends TitleBarButton {
        private MaximizeButton() {
        }

        @Override
        protected void onClick() {
            FTitleBarBase.this.owner.setMaximized(!FTitleBarBase.this.owner.isMaximized());
        }

        @Override
        public void paintComponent(Graphics g2) {
            super.paintComponent(g2);
            int thickness = 2;
            int offsetX = 7;
            int offsetY = 8;
            int x = offsetX;
            int y = offsetY;
            int width = this.getWidth() - 2 * offsetX;
            int height = this.getHeight() - 2 * offsetY;
            Graphics2D g2d = (Graphics2D)g2;
            FSkin.setGraphicsColor(g2d, foreColor);
            g2d.setStroke(new BasicStroke(thickness));
            if (FTitleBarBase.this.owner.isMaximized()) {
                g2d.drawRect(--x, y += 2, --width, --height);
                g2d.drawLine(x += 3, y -= 3, x, y + 2);
                g2d.drawLine(x, y, x + width, y);
                g2d.drawLine(x += width, y, x, y + height);
                g2d.drawLine(x - 2, y += height, x, y);
            } else {
                g2d.drawRect(x, y, width, height);
            }
        }
    }

    public class FullScreenButton
    extends TitleBarButton {
        private FullScreenButton() {
        }

        @Override
        protected void onClick() {
            FTitleBarBase.this.owner.setFullScreen(!FTitleBarBase.this.owner.isFullScreen());
        }

        @Override
        public void paintComponent(Graphics g2) {
            super.paintComponent(g2);
            int thickness = 2;
            int offset = 6;
            int arrowLength = 4;
            int x1 = offset;
            int y1 = offset;
            int x2 = this.getWidth() - offset - 1;
            int y2 = this.getHeight() - offset - 1;
            Graphics2D g2d = (Graphics2D)g2;
            FSkin.setGraphicsColor(g2d, foreColor);
            if (FTitleBarBase.this.owner.isFullScreen()) {
                g2d.drawLine(x1 + arrowLength, y1, x1 + arrowLength, y1 + arrowLength);
                g2d.drawLine(x1, y1 + arrowLength, x1 + arrowLength, y1 + arrowLength);
                g2d.drawLine(x2 - arrowLength, y1, x2 - arrowLength, y1 + arrowLength);
                g2d.drawLine(x2, y1 + arrowLength, x2 - arrowLength, y1 + arrowLength);
                g2d.drawLine(x1 + arrowLength, y2, x1 + arrowLength, y2 - arrowLength);
                g2d.drawLine(x1, y2 - arrowLength, x1 + arrowLength, y2 - arrowLength);
                g2d.drawLine(x2 - arrowLength, y2, x2 - arrowLength, y2 - arrowLength);
                g2d.drawLine(x2, y2 - arrowLength, x2 - arrowLength, y2 - arrowLength);
            } else {
                g2d.drawLine(--x1, --y1, x1, y1 + arrowLength);
                g2d.drawLine(x1, y1, x1 + arrowLength, y1);
                g2d.drawLine(++x2, y1, x2, y1 + arrowLength);
                g2d.drawLine(x2, y1, x2 - arrowLength, y1);
                g2d.drawLine(x1, ++y2, x1, y2 - arrowLength);
                g2d.drawLine(x1, y2, x1 + arrowLength, y2);
                g2d.drawLine(x2, y2, x2, y2 - arrowLength);
                g2d.drawLine(x2, y2, x2 - arrowLength, y2);
                ++x1;
                --x2;
                ++y1;
                --y2;
            }
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setStroke(new BasicStroke(thickness));
            g2d.drawLine(x1, y1, x1 + --arrowLength, y1 + arrowLength);
            g2d.drawLine(x2, y1, x2 - arrowLength, y1 + arrowLength);
            g2d.drawLine(x1, y2, x1 + arrowLength, y2 - arrowLength);
            g2d.drawLine(x2, y2, x2 - arrowLength, y2 - arrowLength);
        }
    }

    public class MinimizeButton
    extends TitleBarButton {
        private MinimizeButton() {
            this.setToolTipText(Localizer.getInstance().getMessage("lblMinimize", new Object[0]));
        }

        @Override
        protected void onClick() {
            FTitleBarBase.this.owner.setMinimized(true);
        }

        @Override
        public void paintComponent(Graphics g2) {
            super.paintComponent(g2);
            int thickness = 2;
            int offsetX = 8;
            int offsetY = 7;
            int x1 = offsetX;
            int x2 = this.getWidth() - offsetX;
            int y = this.getHeight() - offsetY - thickness;
            Graphics2D g2d = (Graphics2D)g2;
            FSkin.setGraphicsColor(g2d, foreColor);
            g2d.setStroke(new BasicStroke(thickness));
            g2d.drawLine(x1, y, x2, y);
        }
    }

    public class LockTitleBarButton
    extends TitleBarButton {
        private LockTitleBarButton() {
        }

        @Override
        protected void onClick() {
            FTitleBarBase.this.owner.setLockTitleBar(!FTitleBarBase.this.owner.getLockTitleBar());
        }

        @Override
        protected boolean isToggled() {
            return FTitleBarBase.this.owner.getLockTitleBar();
        }

        @Override
        public void paintComponent(Graphics g2) {
            super.paintComponent(g2);
            int knobWidth = 5;
            int knobHeight = 7;
            int pinHeight = 4;
            int centerX = this.getWidth() / 2;
            int x1 = centerX - knobWidth / 2;
            int x2 = x1 + knobWidth - 1;
            int y1 = (this.getHeight() - knobHeight) / 2 - 1;
            int y2 = y1 + knobHeight - 1;
            FSkin.setGraphicsColor(g2, foreColor);
            g2.drawRect(x1, y1, knobWidth - 1, knobHeight - 1);
            g2.drawLine(x2 - 1, y1 + 1, x2 - 1, y2 - 1);
            g2.drawLine(x1 - 1, y2, x2 + 1, y2);
            g2.drawLine(centerX, y2, centerX, y2 + pinHeight);
        }
    }

    public abstract class TitleBarButton
    extends FSkin.SkinnedLabel
    implements ILocalRepaint {
        private boolean pressed;
        private boolean hovered;

        private TitleBarButton() {
            this.setPreferredSize(new Dimension(25, 25));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (!TitleBarButton.this.isEnabled()) {
                        return;
                    }
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        TitleBarButton.this.pressed = true;
                        TitleBarButton.this.repaintSelf();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (TitleBarButton.this.pressed && SwingUtilities.isLeftMouseButton(e)) {
                        TitleBarButton.this.pressed = false;
                        if (TitleBarButton.this.hovered) {
                            TitleBarButton.this.repaintSelf();
                            TitleBarButton.this.onClick();
                        }
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (!TitleBarButton.this.isEnabled()) {
                        return;
                    }
                    TitleBarButton.this.hovered = true;
                    TitleBarButton.this.repaintSelf();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (TitleBarButton.this.hovered) {
                        TitleBarButton.this.hovered = false;
                        TitleBarButton.this.repaintSelf();
                    }
                }
            });
        }

        protected abstract void onClick();

        @Override
        public void setEnabled(boolean enabled0) {
            if (!enabled0 && this.hovered) {
                this.hovered = false;
            }
            super.setEnabled(enabled0);
        }

        @Override
        public void repaintSelf() {
            Container window = FTitleBarBase.this.getParent().getParent().getParent();
            if (window instanceof FDialog && !((FDialog)window).allowResize()) {
                window.repaint(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            } else {
                this.repaint(0, 0, this.getWidth(), this.getHeight());
            }
        }

        protected boolean isToggled() {
            return false;
        }

        @Override
        public void paintComponent(Graphics g2) {
            if (this.hovered) {
                if (this.pressed) {
                    FSkin.setGraphicsColor(g2, buttonDownColor);
                    g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g2.translate(1, 1);
                } else {
                    FSkin.setGraphicsColor(g2, buttonHoverColor);
                    g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
            } else if (this.isToggled()) {
                int width = this.getWidth() - 2;
                int height = this.getHeight() - 2;
                FSkin.setGraphicsColor(g2, buttonToggleColor);
                g2.fillRect(1, 1, width, height);
                FSkin.setGraphicsColor(g2, buttonBorderColor);
                g2.drawRect(1, 1, width - 1, height - 1);
            }
        }
    }
}

