/*
 * Decompiled with CFR 0.152.
 */
package forge.view;

import forge.toolbox.FSkin;
import forge.view.FTitleBarBase;
import forge.view.ITitleBarOwner;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class FTitleBar
extends FTitleBarBase {
    private static final FSkin.SkinFont skinFont = FSkin.getFont();
    private final FSkin.SkinnedLabel lblTitle = new FSkin.SkinnedLabel();

    public FTitleBar(ITitleBarOwner owner0) {
        super(owner0);
        this.setBorder(new FSkin.MatteSkinBorder(0, 0, 1, 0, bottomEdgeColor));
        owner0.setJMenuBar(this);
        this.setTitle(owner0.getTitle());
        this.setIconImage(owner0.getIconImage());
        this.lblTitle.setForeground(foreColor);
        this.lblTitle.setFont(skinFont);
        this.addControls();
    }

    @Override
    protected void addControls() {
        this.add(this.lblTitle);
        this.layout.putConstraint("West", (Component)this.lblTitle, 5, "West", (Component)this);
        this.layout.putConstraint("South", (Component)this.lblTitle, -5, "South", (Component)this);
        super.addControls();
    }

    @Override
    public void setTitle(String title) {
        this.lblTitle.setText(title);
        this.updatePreferredSize();
    }

    @Override
    public void setIconImage(Image image) {
        if (image != null) {
            this.lblTitle.setIcon(new ImageIcon(image.getScaledInstance(16, 16, 4)));
        } else {
            this.lblTitle.setIcon((Icon)null);
        }
        this.updatePreferredSize();
    }

    private void updatePreferredSize() {
        int width = skinFont.measureTextWidth(JOptionPane.getRootFrame().getGraphics(), this.lblTitle.getText());
        if (this.lblTitle.getIcon() != null) {
            width += this.lblTitle.getIcon().getIconWidth() + this.lblTitle.getIconTextGap();
        }
        this.setPreferredSize(new Dimension((width += this.btnClose.getPreferredSize().width) + 10, 27));
    }
}

