/*
 * Decompiled with CFR 0.152.
 */
package forge.view;

import com.google.common.collect.Lists;
import forge.Singletons;
import forge.gui.framework.FScreen;
import forge.gui.framework.ILocalRepaint;
import forge.localinstance.properties.ForgePreferences;
import forge.menus.ForgeMenu;
import forge.menus.LayoutMenu;
import forge.toolbox.FButton;
import forge.toolbox.FDigitalClock;
import forge.toolbox.FSkin;
import forge.util.Localizer;
import forge.util.ReflectionUtil;
import forge.view.FFrame;
import forge.view.FTitleBarBase;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;

public class FNavigationBar
extends FTitleBarBase {
    private static final ForgeMenu forgeMenu = Singletons.getControl().getForgeMenu();
    private static final int revealSpeed = 300;
    private static final int revealDelay = 150;
    private static final int initialHideDelay = 500;
    private final FButton btnForge = new FButton("Forge");
    private final List<NavigationTab> tabs = Lists.newArrayList();
    private final FDigitalClock clock = new FDigitalClock();
    private final JPanel pnlReveal = new JPanel();
    private NavigationTab selectedTab;
    private int revealDir = 0;
    private long timeMenuHidden = 0L;
    private Timer incrementRevealTimer;
    private Timer checkForRevealChangeTimer;
    private boolean hidden;

    public FNavigationBar(FFrame f) {
        super(f);
        this.setBorder(new FSkin.MatteSkinBorder(0, 0, 2, 0, bottomEdgeColor));
        this.setLocation(0, -27);
        this.setPreferredSize(new Dimension(this.owner.getWidth(), 27));
        this.btnForge.setFocusable(false);
        this.btnForge.setPreferredSize(new Dimension(100, 23));
        this.btnForge.setForeground(foreColor);
        this.clock.setForeground(foreColor);
        this.addControls();
        this.setupPnlReveal();
        this.updateBtnCloseTooltip();
    }

    public void updateBtnCloseTooltip() {
        Localizer localizer = Localizer.getInstance();
        switch (Singletons.getControl().getCloseAction()) {
            case NONE: {
                this.btnClose.setToolTipText(localizer.getMessage("lblClose", new Object[0]));
                break;
            }
            case CLOSE_SCREEN: {
                this.btnClose.setToolTipText(this.selectedTab.screen.getCloseButtonTooltip());
                break;
            }
            case EXIT_FORGE: {
                this.btnClose.setToolTipText(localizer.getMessage("lblExitForge", new Object[0]));
            }
        }
    }

    @Override
    protected void addControls() {
        this.add(this.btnForge);
        this.layout.putConstraint("West", (Component)this.btnForge, 1, "West", (Component)this);
        this.layout.putConstraint("South", (Component)this.btnForge, -1, "South", (Component)this);
        this.addForgeButtonListeners();
        this.addNavigationTab(FScreen.HOME_SCREEN);
        this.addNavigationTab(FScreen.DECK_EDITOR_CONSTRUCTED);
        if (ForgePreferences.DEV_MODE) {
            this.addNavigationTab(FScreen.WORKSHOP_SCREEN);
        }
        super.addControls();
        this.add(this.clock);
        this.layout.putConstraint("East", (Component)this.clock, -6, "West", (Component)this.btnLockTitleBar);
        this.layout.putConstraint("South", (Component)this.clock, -5, "South", (Component)this);
        this.updateClockVisibility();
    }

    private NavigationTab addNavigationTab(FScreen screen) {
        NavigationTab tab = new NavigationTab(screen);
        if (this.tabs.size() == 0) {
            tab.setSelected(true);
            this.selectedTab = tab;
            this.layout.putConstraint("West", (Component)tab, 1, "East", (Component)this.btnForge);
        } else {
            this.layout.putConstraint("West", (Component)tab, 1, "East", (Component)this.tabs.get(this.tabs.size() - 1));
        }
        this.layout.putConstraint("South", (Component)tab, 0, "South", (Component)this);
        this.tabs.add(tab);
        this.add(tab);
        return tab;
    }

    private NavigationTab getTab(FScreen screen) {
        for (NavigationTab tab : this.tabs) {
            if (tab.screen != screen) continue;
            return tab;
        }
        return null;
    }

    public boolean canSwitch(FScreen toScreen) {
        return this.selectedTab == null || this.selectedTab.screen.onSwitching(toScreen);
    }

    public void updateSelectedTab() {
        FScreen screen = Singletons.getControl().getCurrentScreen();
        NavigationTab tab = this.getTab(screen);
        if (tab == null) {
            tab = this.addNavigationTab(screen);
        } else if (tab == this.selectedTab) {
            return;
        }
        if (this.selectedTab != null) {
            this.selectedTab.setSelected(false);
        }
        tab.setSelected(true);
        this.selectedTab = tab;
        this.updateBtnCloseTooltip();
    }

    public void closeSelectedTab() {
        this.closeTab(this.selectedTab);
    }

    public void closeTab(FScreen screen) {
        NavigationTab tab = this.getTab(screen);
        if (tab != null) {
            this.closeTab(tab);
        }
    }

    private void closeTab(NavigationTab tab) {
        int index;
        if (tab == null) {
            return;
        }
        if (!tab.screen.onClosing()) {
            return;
        }
        if (tab.selected) {
            this.selectedTab = null;
            Singletons.getControl().setCurrentScreen(FScreen.HOME_SCREEN, true);
        }
        if ((index = this.tabs.indexOf(tab)) != -1) {
            this.tabs.remove(index);
            this.remove(tab);
            if (index < this.tabs.size()) {
                this.layout.putConstraint("West", (Component)this.tabs.get(index), 1, "East", index > 0 ? (Component)this.tabs.get(index - 1) : this.btnForge);
                this.revalidate();
            }
            this.repaint();
        }
    }

    @Override
    public void updateButtons() {
        super.updateButtons();
        this.updateClockVisibility();
        LayoutMenu.updateFullScreenItemText();
    }

    private void updateClockVisibility() {
        this.clock.setVisible(this.owner.isFullScreen());
    }

    private void addForgeButtonListeners() {
        this.btnForge.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (FNavigationBar.this.btnForge.isEnabled() && System.currentTimeMillis() - FNavigationBar.this.timeMenuHidden > 250L) {
                    FNavigationBar.this.showForgeMenu(true);
                }
            }
        });
    }

    public void showForgeMenu(boolean hideIfAlreadyShown) {
        if (!this.btnForge.isToggled() && forgeMenu.getPopupMenu().isEnabled()) {
            this.btnForge.setToggled(true);
            forgeMenu.getPopupMenu().show(this, 1, this.getHeight());
        } else if (hideIfAlreadyShown) {
            forgeMenu.hide();
        }
    }

    public void onForgeMenuHidden() {
        this.btnForge.setToggled(false);
        this.timeMenuHidden = System.currentTimeMillis();
    }

    private void setupPnlReveal() {
        this.pnlReveal.setLocation(0, 0);
        this.pnlReveal.setVisible(this.hidden);
        this.pnlReveal.setOpaque(false);
        this.pnlReveal.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (FNavigationBar.this.revealDir == 0) {
                    FNavigationBar.this.startReveal();
                }
            }
        });
        this.incrementRevealTimer = new Timer(11, e -> this.incrementReveal());
        this.checkForRevealChangeTimer = new Timer(150, e -> this.checkForRevealChange());
    }

    private void startReveal() {
        if (this.getLocation().y == 0) {
            return;
        }
        if (this.revealDir == 0) {
            this.incrementRevealTimer.setInitialDelay(150);
            this.incrementRevealTimer.start();
            this.checkForRevealChangeTimer.stop();
        }
        this.revealDir = 1;
    }

    private void stopReveal() {
        if (this.getLocation().y == -27) {
            return;
        }
        if (this.revealDir == 0) {
            this.incrementRevealTimer.setInitialDelay(150);
            this.incrementRevealTimer.start();
            this.checkForRevealChangeTimer.stop();
        }
        this.revealDir = -1;
    }

    private void incrementReveal() {
        int newY = this.getLocation().y + this.revealDir * 2;
        switch (this.revealDir) {
            case 0: {
                this.incrementRevealTimer.stop();
                return;
            }
            case 1: {
                if (newY < 0) break;
                newY = 0;
                this.revealDir = 0;
                this.incrementRevealTimer.stop();
                this.checkForRevealChangeTimer.setInitialDelay(0);
                this.checkForRevealChangeTimer.start();
                break;
            }
            case -1: {
                if (newY > -27) break;
                newY = -27;
                this.revealDir = 0;
                this.incrementRevealTimer.stop();
            }
        }
        this.setLocation(0, newY);
        this.checkForRevealChange();
    }

    private void checkForRevealChange() {
        if (this.hidden && this.getHeight() > 0 && !this.btnForge.isToggled()) {
            Rectangle screenBounds = new Rectangle(this.getLocationOnScreen(), this.getSize());
            if (screenBounds.contains(MouseInfo.getPointerInfo().getLocation())) {
                this.startReveal();
            } else {
                this.stopReveal();
            }
        }
    }

    public void setMenuShortcutsEnabled(boolean enabled0) {
        forgeMenu.getPopupMenu().setEnabled(enabled0);
    }

    @Override
    public void setEnabled(boolean enabled0) {
        this.btnForge.setEnabled(enabled0);
        this.setMenuShortcutsEnabled(enabled0);
        for (NavigationTab tab : this.tabs) {
            tab.setEnabled(enabled0);
        }
        this.btnClose.setEnabled(enabled0);
    }

    @Override
    public void setVisible(boolean visible) {
        boolean bl = this.hidden = !visible;
        if (this.pnlReveal != null) {
            this.revealDir = 0;
            this.incrementRevealTimer.stop();
            this.checkForRevealChangeTimer.stop();
            this.pnlReveal.setVisible(this.hidden);
        }
        if (visible || this.getLocation().y < 0) {
            this.setLocation(0, visible ? 0 : -27);
        } else if (this.pnlReveal != null) {
            this.checkForRevealChangeTimer.setInitialDelay(500);
            this.checkForRevealChangeTimer.start();
        }
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.pnlReveal.setSize(width, 1);
    }

    public JPanel getPnlReveal() {
        return this.pnlReveal;
    }

    @Override
    public void setTitle(String title) {
    }

    @Override
    public void setIconImage(Image image) {
    }

    public void updateTitle(FScreen screen) {
        for (NavigationTab tab : this.tabs) {
            if (tab.screen != screen) continue;
            tab.updateTitle();
        }
    }

    private final class NavigationTab
    extends FSkin.SkinnedLabel
    implements ILocalRepaint {
        private static final int fontSize = 14;
        private static final int unhoveredAlpha = 150;
        private final FScreen screen;
        private final CloseButton btnClose;
        private FSkin.SkinColor backColor;
        private boolean selected;
        private boolean hovered;

        private NavigationTab(FScreen screen0) {
            int closeButtonOffset;
            super(screen0.getTabCaption());
            this.selected = false;
            this.hovered = false;
            this.screen = screen0;
            this.setOpaque(false);
            this.setIcon(screen0.getTabIcon());
            this.setForeground(FTitleBarBase.foreColor.alphaColor(150));
            this.setFont(FSkin.getRelativeFont(14));
            if (this.screen.allowTabClose()) {
                this.btnClose = new CloseButton();
                this.btnClose.setToolTipText(this.screen.getCloseButtonTooltip());
                closeButtonOffset = this.btnClose.getPreferredSize().width;
                SpringLayout tabLayout = new SpringLayout();
                this.setLayout(tabLayout);
                this.add(this.btnClose);
                tabLayout.putConstraint("West", (Component)this.btnClose, 4, "East", (Component)this);
                tabLayout.putConstraint("South", (Component)this.btnClose, -2, "South", (Component)this);
            } else {
                this.btnClose = null;
                closeButtonOffset = 0;
            }
            this.setBorder(new EmptyBorder(2, 3, 2, 7 + closeButtonOffset));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (!NavigationTab.this.isEnabled()) {
                        return;
                    }
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        if (!NavigationTab.this.selected) {
                            Singletons.getControl().setCurrentScreen(NavigationTab.this.screen);
                        }
                    } else if (SwingUtilities.isMiddleMouseButton(e) && NavigationTab.this.screen.allowTabClose()) {
                        FNavigationBar.this.closeTab(NavigationTab.this);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (!NavigationTab.this.isEnabled()) {
                        return;
                    }
                    NavigationTab.this.hovered = true;
                    NavigationTab.this.repaintSelf();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (NavigationTab.this.hovered && (NavigationTab.this.btnClose == null || !NavigationTab.this.btnClose.getBounds().contains(e.getPoint()))) {
                        NavigationTab.this.hovered = false;
                        NavigationTab.this.repaintSelf();
                    }
                }
            });
        }

        private void setSelected(boolean selected0) {
            if (this.selected == selected0) {
                return;
            }
            this.selected = selected0;
            this.setFont(selected0 ? FSkin.getRelativeBoldFont(14) : FSkin.getRelativeFont(14));
            this.repaintSelf();
        }

        @Override
        public void setIcon(Icon icon) {
            ImageIcon imageIcon = ReflectionUtil.safeCast(icon, ImageIcon.class);
            if (imageIcon != null) {
                super.setIcon(new ImageIcon(imageIcon.getImage().getScaledInstance(20, 20, 4)));
            } else {
                super.setIcon((Icon)null);
            }
        }

        @Override
        public void setEnabled(boolean enabled0) {
            if (!enabled0 && this.hovered) {
                this.hovered = false;
            }
            if (this.btnClose != null) {
                this.btnClose.setEnabled(enabled0);
            }
            super.setEnabled(enabled0);
        }

        @Override
        public void repaintSelf() {
            Dimension d = this.getSize();
            this.setForeground(this.selected ? FTitleBarBase.bottomEdgeColor.getHighContrastColor() : (this.hovered ? FTitleBarBase.foreColor : FTitleBarBase.foreColor.alphaColor(150)));
            this.repaint(0, 0, d.width, d.height);
            if (this.btnClose != null) {
                this.btnClose.repaintSelf();
            }
        }

        @Override
        public void paintComponent(Graphics g2) {
            Graphics2D g2d = (Graphics2D)g2;
            int width = this.getWidth() - 1;
            int height = 26;
            int radius = 6;
            this.backColor = this.selected ? FTitleBarBase.bottomEdgeColor : (this.hovered ? FTitleBarBase.buttonHoverColor : FTitleBarBase.buttonHoverColor.alphaColor(150));
            FSkin.setGraphicsGradientPaint(g2d, 0.0f, 0.0f, this.backColor.stepColor(30), 0.0f, 26.0f, this.backColor);
            g2.fillRoundRect(0, 0, width, 26, 6, 6);
            FSkin.setGraphicsColor(g2, FTitleBarBase.buttonBorderColor);
            g2.drawRoundRect(0, 0, width, 26, 6, 6);
            super.paintComponent(g2);
        }

        private void updateTitle() {
            this.setText(this.screen.getTabCaption());
        }

        private class CloseButton
        extends JLabel
        implements ILocalRepaint {
            private boolean pressed;
            private boolean hovered;

            private CloseButton() {
                this.setPreferredSize(new Dimension(17, 17));
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (!CloseButton.this.isEnabled()) {
                            return;
                        }
                        if (SwingUtilities.isLeftMouseButton(e)) {
                            CloseButton.this.pressed = true;
                            CloseButton.this.repaintSelf();
                        }
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        if (CloseButton.this.pressed && SwingUtilities.isLeftMouseButton(e)) {
                            CloseButton.this.pressed = false;
                            if (CloseButton.this.hovered) {
                                CloseButton.this.repaintSelf();
                                FNavigationBar.this.closeTab(NavigationTab.this);
                            }
                        }
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        if (!CloseButton.this.isEnabled()) {
                            return;
                        }
                        CloseButton.this.hovered = true;
                        CloseButton.this.repaintSelf();
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        if (CloseButton.this.hovered) {
                            CloseButton.this.hovered = false;
                            CloseButton.this.repaintSelf();
                        }
                    }
                });
            }

            @Override
            public void setEnabled(boolean enabled0) {
                if (!enabled0 && this.hovered) {
                    this.hovered = false;
                }
                super.setEnabled(enabled0);
            }

            @Override
            public void repaintSelf() {
                Dimension d = this.getSize();
                this.repaint(0, 0, d.width, d.height);
            }

            @Override
            public void paintComponent(Graphics g2) {
                super.paintComponent(g2);
                if (this.hovered) {
                    if (this.pressed) {
                        FSkin.setGraphicsColor(g2, NavigationTab.this.backColor.stepColor(-40));
                        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                        g2.translate(1, 1);
                    } else {
                        FSkin.setGraphicsColor(g2, NavigationTab.this.backColor.getContrastColor(20));
                        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                    }
                }
                int thickness = 2;
                int offset = 4;
                int x1 = 4;
                int y1 = 4;
                int x2 = this.getWidth() - 4 - 1;
                int y2 = this.getHeight() - 4 - 1;
                Graphics2D g2d = (Graphics2D)g2;
                FSkin.SkinColor iconColor = NavigationTab.this.getSkin().getForeground();
                if (!NavigationTab.this.isEnabled()) {
                    iconColor = iconColor.alphaColor(100);
                }
                FSkin.setGraphicsColor(g2d, iconColor);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.drawLine(4, 4, x2, y2);
                g2d.drawLine(x2, 4, 4, y2);
            }
        }
    }
}

