/*
 * Decompiled with CFR 0.152.
 */
package forge.view;

import forge.Singletons;
import forge.gamemodes.match.HostedMatch;
import forge.gui.framework.SDisplayUtil;
import forge.gui.framework.SResizingUtil;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.sound.SoundSystem;
import forge.toolbox.FSkin;
import forge.view.FTitleBarBase;
import forge.view.FView;
import forge.view.ITitleBarOwner;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class FFrame
extends FSkin.SkinnedFrame
implements ITitleBarOwner {
    private static final int borderThickness = 3;
    private Point locBeforeMove;
    private Dimension sizeBeforeResize;
    private Point mouseDownLoc;
    private boolean moveInProgress;
    private int resizeCursor;
    private FTitleBarBase titleBar;
    private boolean minimized;
    private boolean maximized;
    private boolean fullScreen;
    private boolean hideBorder;
    private boolean lockTitleBar;
    private boolean hideTitleBar;
    private boolean isMainFrame;
    private boolean paused;
    private Rectangle normalBounds;

    public FFrame() {
        this.setUndecorated(true);
    }

    public void initialize(FTitleBarBase titleBar0) {
        this.isMainFrame = FView.SINGLETON_INSTANCE.getFrame() == this;
        this.hideBorder = true;
        this.hideTitleBar = true;
        this.lockTitleBar = this.isMainFrame && FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_LOCK_TITLE_BAR);
        this.addResizeSupport();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                FFrame.this.resume();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                if (e.getOppositeWindow() == null) {
                    FFrame.this.pause();
                    if (FFrame.this.fullScreen) {
                        FFrame.this.setMinimized(true);
                    }
                }
            }
        });
        this.addWindowStateListener(e -> this.setState(e.getNewState()));
        this.titleBar = titleBar0;
        this.addMoveSupport();
    }

    private void pause() {
        if (this.paused || !this.isMainFrame) {
            return;
        }
        SoundSystem.instance.pause();
        for (HostedMatch hostedMatch : Singletons.getControl().getCurrentMatches()) {
            hostedMatch.pause();
        }
        this.paused = true;
    }

    private void resume() {
        if (!this.paused || !this.isMainFrame) {
            return;
        }
        SoundSystem.instance.resume();
        for (HostedMatch hostedMatch : Singletons.getControl().getCurrentMatches()) {
            hostedMatch.resume();
        }
        this.paused = false;
    }

    public FTitleBarBase getTitleBar() {
        return this.titleBar;
    }

    @Override
    public boolean getLockTitleBar() {
        return this.lockTitleBar;
    }

    @Override
    public void setLockTitleBar(boolean lockTitleBar0) {
        if (this.lockTitleBar == lockTitleBar0) {
            return;
        }
        this.lockTitleBar = lockTitleBar0;
        if (this.isMainFrame) {
            ForgePreferences prefs = FModel.getPreferences();
            prefs.setPref(ForgePreferences.FPref.UI_LOCK_TITLE_BAR, lockTitleBar0);
            prefs.save();
        }
        this.updateTitleBar();
    }

    public boolean isTitleBarHidden() {
        return this.hideTitleBar;
    }

    private void updateTitleBar() {
        this.titleBar.updateButtons();
        if (this.hideTitleBar == (this.fullScreen && !this.lockTitleBar)) {
            return;
        }
        this.hideTitleBar = !this.hideTitleBar;
        this.titleBar.setVisible(!this.hideTitleBar);
        if (this.isMainFrame) {
            SResizingUtil.resizeWindow();
        }
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        if (this.titleBar != null) {
            this.titleBar.setTitle(title);
        }
    }

    @Override
    public void setIconImage(Image image) {
        super.setIconImage(image);
        if (this.titleBar != null) {
            this.titleBar.setIconImage(image);
        }
    }

    @Override
    public void setLocation(Point point) {
        this.resetState();
        super.setLocation(point);
    }

    @Override
    public void setLocation(int x, int y) {
        this.resetState();
        super.setLocation(x, y);
    }

    @Override
    public void setSize(Dimension size) {
        this.resetState();
        super.setSize(size);
    }

    @Override
    public void setSize(int width, int height) {
        this.resetState();
        super.setSize(width, height);
    }

    private void resetState() {
        if (this.minimized || this.maximized || this.fullScreen) {
            this.minimized = false;
            this.maximized = false;
            if (this.fullScreen) {
                SDisplayUtil.setFullScreenWindow(this, false);
                this.fullScreen = false;
            }
            this.updateState();
        }
    }

    public void setWindowLayout(int x, int y, int width, int height, boolean maximized0, boolean fullScreen0) {
        this.normalBounds = new Rectangle(x, y, width, height);
        this.maximized = maximized0;
        this.fullScreen = fullScreen0;
        this.updateState();
    }

    public Rectangle getNormalBounds() {
        return this.normalBounds;
    }

    public void updateNormalBounds() {
        if (this.minimized || this.maximized || this.fullScreen) {
            return;
        }
        this.normalBounds = this.getBounds();
    }

    @Override
    public boolean isMinimized() {
        return this.minimized;
    }

    @Override
    public void setMinimized(boolean minimized0) {
        if (this.minimized == minimized0) {
            return;
        }
        this.minimized = minimized0;
        this.updateState();
        if (minimized0) {
            this.pause();
        } else {
            this.resume();
        }
    }

    @Override
    public boolean isMaximized() {
        return this.maximized;
    }

    @Override
    public void setMaximized(boolean maximized0) {
        if (this.maximized == maximized0) {
            return;
        }
        this.maximized = maximized0;
        this.updateState();
    }

    @Override
    public boolean isFullScreen() {
        return this.fullScreen;
    }

    @Override
    public void setFullScreen(boolean fullScreen0) {
        if (this.fullScreen == fullScreen0) {
            return;
        }
        this.fullScreen = fullScreen0;
        if (!fullScreen0) {
            SDisplayUtil.setFullScreenWindow(this, false);
        }
        this.updateState();
    }

    private void updateState() {
        if (this.minimized) {
            super.setExtendedState(1);
            return;
        }
        this.updateBorder();
        this.updateTitleBar();
        super.setExtendedState(0);
        if (this.fullScreen) {
            if (SDisplayUtil.setFullScreenWindow(this, true)) {
                return;
            }
            this.fullScreen = false;
            this.updateBorder();
            this.updateTitleBar();
        }
        if (this.maximized) {
            this.setBounds(SDisplayUtil.getScreenMaximizedBounds(this.normalBounds));
        } else {
            this.setBounds(this.normalBounds);
        }
    }

    private void updateBorder() {
        if (this.minimized || this.hideBorder == (this.maximized || this.fullScreen)) {
            return;
        }
        boolean bl = this.hideBorder = !this.hideBorder;
        if (this.hideBorder) {
            this.setBorder((Border)null);
        } else {
            this.setBorder(new FSkin.CompoundSkinBorder(BorderFactory.createLineBorder(Color.BLACK, 1), (FSkin.SkinBorder)new FSkin.LineSkinBorder(FSkin.getColor(FSkin.Colors.CLR_BORDERS), 2)));
        }
    }

    @Override
    public synchronized void setState(int state) {
        this.setMinimized(state == 1);
        if (state == 6) {
            this.setMaximized(true);
        }
    }

    @Override
    public void setExtendedState(int state) {
        if (this.isActive()) {
            this.minimized = (state & 1) == 1;
            this.maximized = (state & 6) == 6;
            this.updateState();
        }
    }

    private void addMoveSupport() {
        this.titleBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && !FFrame.this.fullScreen) {
                    if (e.getClickCount() == 1) {
                        FFrame.this.locBeforeMove = FFrame.this.getLocation();
                        FFrame.this.mouseDownLoc = e.getLocationOnScreen();
                    } else {
                        FFrame.this.setMaximized(!FFrame.this.isMaximized());
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    FFrame.this.locBeforeMove = null;
                    FFrame.this.mouseDownLoc = null;
                    FFrame.this.moveInProgress = false;
                }
            }
        });
        this.titleBar.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (FFrame.this.mouseDownLoc != null) {
                    Point loc = e.getLocationOnScreen();
                    int dx = loc.x - ((FFrame)FFrame.this).mouseDownLoc.x;
                    int dy = loc.y - ((FFrame)FFrame.this).mouseDownLoc.y;
                    if (!FFrame.this.moveInProgress) {
                        if (FFrame.this.isMaximized() && dx * dx + dy * dy < 25) {
                            return;
                        }
                        FFrame.this.moveInProgress = true;
                    }
                    FFrame.this.setLocation(((FFrame)FFrame.this).locBeforeMove.x + dx, ((FFrame)FFrame.this).locBeforeMove.y + dy);
                }
            }
        });
    }

    private void setResizeCursor(int resizeCursor0) {
        this.resizeCursor = resizeCursor0;
        this.getRootPane().setCursor(Cursor.getPredefinedCursor(resizeCursor0));
    }

    private void addResizeSupport() {
        JRootPane resizeBorders = this.getRootPane();
        resizeBorders.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (FFrame.this.resizeCursor != 0 && SwingUtilities.isLeftMouseButton(e)) {
                    FFrame.this.locBeforeMove = FFrame.this.getLocation();
                    FFrame.this.sizeBeforeResize = FFrame.this.getSize();
                    FFrame.this.mouseDownLoc = e.getLocationOnScreen();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    FFrame.this.locBeforeMove = null;
                    FFrame.this.sizeBeforeResize = null;
                    FFrame.this.mouseDownLoc = null;
                    FFrame.this.setResizeCursor(0);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (FFrame.this.mouseDownLoc == null) {
                    FFrame.this.setResizeCursor(0);
                }
            }
        });
        resizeBorders.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (FFrame.this.mouseDownLoc == null && !FFrame.this.maximized) {
                    int grabArea = 6;
                    Point loc = e.getPoint();
                    if (loc.x < 6) {
                        if (loc.y < 6) {
                            FFrame.this.setResizeCursor(6);
                        } else if (loc.y >= FFrame.this.getHeight() - 6) {
                            FFrame.this.setResizeCursor(4);
                        } else {
                            FFrame.this.setResizeCursor(10);
                        }
                    } else if (loc.x >= FFrame.this.getWidth() - 6) {
                        if (loc.y < 6) {
                            FFrame.this.setResizeCursor(7);
                        } else if (loc.y >= FFrame.this.getHeight() - 6) {
                            FFrame.this.setResizeCursor(5);
                        } else {
                            FFrame.this.setResizeCursor(11);
                        }
                    } else if (loc.y < 6) {
                        FFrame.this.setResizeCursor(8);
                    } else if (loc.y >= FFrame.this.getHeight() - 6) {
                        FFrame.this.setResizeCursor(9);
                    } else {
                        FFrame.this.setResizeCursor(0);
                    }
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (FFrame.this.mouseDownLoc == null) {
                    return;
                }
                Point loc = e.getLocationOnScreen();
                int dx = loc.x - ((FFrame)FFrame.this).mouseDownLoc.x;
                int dy = loc.y - ((FFrame)FFrame.this).mouseDownLoc.y;
                int width = ((FFrame)FFrame.this).sizeBeforeResize.width;
                int height = ((FFrame)FFrame.this).sizeBeforeResize.height;
                switch (FFrame.this.resizeCursor) {
                    case 11: {
                        width += dx;
                        break;
                    }
                    case 10: {
                        width -= dx;
                        break;
                    }
                    case 9: {
                        height += dy;
                        break;
                    }
                    case 8: {
                        height -= dy;
                        break;
                    }
                    case 5: {
                        width += dx;
                        height += dy;
                        break;
                    }
                    case 7: {
                        width += dx;
                        height -= dy;
                        break;
                    }
                    case 4: {
                        width -= dx;
                        height += dy;
                        break;
                    }
                    case 6: {
                        width -= dx;
                        height -= dy;
                    }
                }
                Dimension minSize = FFrame.this.getMinimumSize();
                Dimension maxSize = FFrame.this.getMaximumSize();
                if (width < minSize.width) {
                    dx += width - minSize.width;
                    width = minSize.width;
                } else if (width > maxSize.width) {
                    dx -= width - maxSize.width;
                    width = maxSize.width;
                }
                if (height < minSize.height) {
                    dy += height - minSize.height;
                    height = minSize.height;
                } else if (height > maxSize.height) {
                    dy -= height - maxSize.height;
                    height = maxSize.height;
                }
                int x = ((FFrame)FFrame.this).locBeforeMove.x;
                int y = ((FFrame)FFrame.this).locBeforeMove.y;
                switch (FFrame.this.resizeCursor) {
                    case 4: 
                    case 10: {
                        x += dx;
                        break;
                    }
                    case 7: 
                    case 8: {
                        y += dy;
                        break;
                    }
                    case 6: {
                        x += dx;
                        y += dy;
                    }
                }
                FFrame.this.setBounds(x, y, width, height);
            }
        });
    }
}

