/*
 * Decompiled with CFR 0.152.
 */
package forge.view;

import forge.Singletons;
import forge.localinstance.skin.FSkinProp;
import forge.toolbox.FMouseAdapter;
import forge.toolbox.FPanel;
import forge.toolbox.FSkin;
import forge.util.OperatingSystem;
import forge.view.FTitleBar;
import forge.view.ITitleBarOwner;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.geom.RoundRectangle2D;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public class FDialog
extends FSkin.SkinnedDialog
implements ITitleBarOwner,
KeyEventDispatcher {
    private static final int borderThickness = 3;
    private static final FSkin.SkinColor borderColor = FSkin.getColor(FSkin.Colors.CLR_BORDERS);
    private static final int cornerDiameter = 20;
    private static final boolean isSetShapeSupported;
    private static final boolean antiAliasBorder;
    private Point locBeforeMove;
    private Dimension sizeBeforeResize;
    private Point mouseDownLoc;
    private int resizeCursor;
    private final FTitleBar titleBar;
    private final FPanel innerPanel;
    private JComponent defaultFocus;
    private final boolean allowResize;
    private static final Stack<FDialog> openModals;
    private static final BackdropPanel backdropPanel;

    public FDialog() {
        this(true, false, "dialog");
    }

    public FDialog(boolean modal0, boolean allowResize0, String insets) {
        super(JOptionPane.getRootFrame(), modal0);
        this.allowResize = allowResize0;
        this.setUndecorated(true);
        this.setIconImage(FSkin.getIcon(FSkinProp.ICO_FAVICON));
        this.innerPanel = new FPanel(new MigLayout("insets " + insets + ", gap 0, center, fill"));
        this.innerPanel.setBackgroundTexture(FSkin.getIcon(FSkinProp.BG_TEXTURE));
        this.innerPanel.setBackgroundTextureOverlay(FSkin.getColor(FSkin.Colors.CLR_THEME));
        this.innerPanel.setBorderToggle(false);
        this.innerPanel.setOpaque(false);
        super.setContentPane(this.innerPanel);
        this.titleBar = new FTitleBar(this);
        this.titleBar.setVisible(true);
        this.addMoveSupport();
        if (this.allowResize) {
            this.setBorder(new FSkin.CompoundSkinBorder(BorderFactory.createLineBorder(Color.BLACK, 1), (FSkin.SkinBorder)new FSkin.LineSkinBorder(FSkin.getColor(FSkin.Colors.CLR_BORDERS), 2)));
            this.addResizeSupport();
        }
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                if (FDialog.this.defaultFocus != null) {
                    FDialog.this.defaultFocus.grabFocus();
                    FDialog.this.defaultFocus = null;
                }
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        });
        if (isSetShapeSupported && !this.allowResize) {
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int arc = 16;
                    FDialog.this.setShape(new RoundRectangle2D.Float(0.0f, 0.0f, FDialog.this.getWidth(), FDialog.this.getHeight(), 16.0f, 16.0f));
                }
            });
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (e.getID() == 401 && e.getKeyCode() == 27) {
            WindowEvent wev = new WindowEvent(this, 201);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(wev);
            return true;
        }
        return false;
    }

    @Override
    public void paint(Graphics g2) {
        super.paint(g2);
        if (this.allowResize) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g2.create();
        if (antiAliasBorder) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        FSkin.setGraphicsColor(g2d, borderColor);
        if (isSetShapeSupported) {
            g2d.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 20, 20);
        } else {
            g2d.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        g2d.dispose();
    }

    @Override
    public void dispose() {
        this.setVisible(false);
        super.dispose();
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.isVisible() == visible) {
            return;
        }
        if (visible) {
            FMouseAdapter.forceMouseUp();
            if (openModals.isEmpty()) {
                this.setLocationRelativeTo(JOptionPane.getRootFrame());
            } else {
                this.setLocationRelativeTo(openModals.peek());
            }
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
            if (this.isModal()) {
                if (openModals.isEmpty()) {
                    backdropPanel.setVisible(true);
                    Singletons.getView().getNavigationBar().setMenuShortcutsEnabled(false);
                }
                openModals.push(this);
            }
        } else {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
            if (this.isModal()) {
                openModals.pop();
                if (openModals.isEmpty()) {
                    backdropPanel.setVisible(false);
                    Singletons.getView().getNavigationBar().setMenuShortcutsEnabled(true);
                }
            }
        }
        super.setVisible(visible);
    }

    public void setDefaultFocus(JComponent comp) {
        this.defaultFocus = comp;
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        if (this.titleBar != null) {
            this.titleBar.setTitle(title);
        }
    }

    @Override
    public void setIconImage(Image image) {
        super.setIconImage(image);
        if (this.titleBar != null) {
            this.titleBar.setIconImage(image);
        }
    }

    public boolean allowResize() {
        return this.allowResize;
    }

    public FTitleBar getTitleBar() {
        return this.titleBar;
    }

    @Override
    public void setContentPane(Container contentPane) {
        if (this.innerPanel != null) {
            this.innerPanel.add((Component)contentPane, "w 100%!, h 100%!");
        }
        super.setContentPane(contentPane);
    }

    @Override
    public Component add(Component comp) {
        if (this.innerPanel != null) {
            return this.innerPanel.add(comp);
        }
        return super.add(comp);
    }

    @Override
    public void add(PopupMenu popup) {
        if (this.innerPanel != null) {
            this.innerPanel.add(popup);
            return;
        }
        super.add(popup);
    }

    public void add(Component comp, int x, int y, int w, int h2) {
        this.add(comp, "x " + x + ", y " + y + ", w " + w + ", h " + h2);
    }

    @Override
    public void add(Component comp, Object constraints) {
        if (this.innerPanel != null) {
            this.innerPanel.add(comp, constraints);
            return;
        }
        super.add(comp, constraints);
    }

    @Override
    public Component add(Component comp, int index) {
        if (this.innerPanel != null) {
            return this.innerPanel.add(comp, index);
        }
        return super.add(comp, index);
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        if (this.innerPanel != null) {
            this.innerPanel.add(comp, constraints, index);
            return;
        }
        super.add(comp, constraints, index);
    }

    @Override
    public Component add(String name, Component comp) {
        if (this.innerPanel != null) {
            return this.innerPanel.add(name, comp);
        }
        return super.add(name, comp);
    }

    private void addMoveSupport() {
        this.titleBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 1) {
                    FDialog.this.locBeforeMove = FDialog.this.getLocation();
                    FDialog.this.mouseDownLoc = e.getLocationOnScreen();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    FDialog.this.locBeforeMove = null;
                    FDialog.this.mouseDownLoc = null;
                }
            }
        });
        this.titleBar.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (FDialog.this.mouseDownLoc != null) {
                    Point loc = e.getLocationOnScreen();
                    int dx = loc.x - ((FDialog)FDialog.this).mouseDownLoc.x;
                    int dy = loc.y - ((FDialog)FDialog.this).mouseDownLoc.y;
                    FDialog.this.setLocation(((FDialog)FDialog.this).locBeforeMove.x + dx, ((FDialog)FDialog.this).locBeforeMove.y + dy);
                }
            }
        });
    }

    private void setResizeCursor(int resizeCursor0) {
        this.resizeCursor = resizeCursor0;
        this.getRootPane().setCursor(Cursor.getPredefinedCursor(resizeCursor0));
    }

    public boolean isResizing() {
        return this.sizeBeforeResize != null;
    }

    private void addResizeSupport() {
        JRootPane resizeBorders = this.getRootPane();
        resizeBorders.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (FDialog.this.resizeCursor != 0 && SwingUtilities.isLeftMouseButton(e)) {
                    FDialog.this.locBeforeMove = FDialog.this.getLocation();
                    FDialog.this.sizeBeforeResize = FDialog.this.getSize();
                    FDialog.this.mouseDownLoc = e.getLocationOnScreen();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    FDialog.this.locBeforeMove = null;
                    FDialog.this.sizeBeforeResize = null;
                    FDialog.this.mouseDownLoc = null;
                    FDialog.this.setResizeCursor(0);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (FDialog.this.mouseDownLoc == null) {
                    FDialog.this.setResizeCursor(0);
                }
            }
        });
        resizeBorders.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (FDialog.this.mouseDownLoc == null) {
                    int grabArea = 6;
                    Point loc = e.getPoint();
                    if (loc.x < 6) {
                        if (loc.y < 6) {
                            FDialog.this.setResizeCursor(6);
                        } else if (loc.y >= FDialog.this.getHeight() - 6) {
                            FDialog.this.setResizeCursor(4);
                        } else {
                            FDialog.this.setResizeCursor(10);
                        }
                    } else if (loc.x >= FDialog.this.getWidth() - 6) {
                        if (loc.y < 6) {
                            FDialog.this.setResizeCursor(7);
                        } else if (loc.y >= FDialog.this.getHeight() - 6) {
                            FDialog.this.setResizeCursor(5);
                        } else {
                            FDialog.this.setResizeCursor(11);
                        }
                    } else if (loc.y < 6) {
                        FDialog.this.setResizeCursor(8);
                    } else if (loc.y >= FDialog.this.getHeight() - 6) {
                        FDialog.this.setResizeCursor(9);
                    } else {
                        FDialog.this.setResizeCursor(0);
                    }
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (FDialog.this.mouseDownLoc == null) {
                    return;
                }
                Point loc = e.getLocationOnScreen();
                int dx = loc.x - ((FDialog)FDialog.this).mouseDownLoc.x;
                int dy = loc.y - ((FDialog)FDialog.this).mouseDownLoc.y;
                int width = ((FDialog)FDialog.this).sizeBeforeResize.width;
                int height = ((FDialog)FDialog.this).sizeBeforeResize.height;
                switch (FDialog.this.resizeCursor) {
                    case 11: {
                        width += dx;
                        break;
                    }
                    case 10: {
                        width -= dx;
                        break;
                    }
                    case 9: {
                        height += dy;
                        break;
                    }
                    case 8: {
                        height -= dy;
                        break;
                    }
                    case 5: {
                        width += dx;
                        height += dy;
                        break;
                    }
                    case 7: {
                        width += dx;
                        height -= dy;
                        break;
                    }
                    case 4: {
                        width -= dx;
                        height += dy;
                        break;
                    }
                    case 6: {
                        width -= dx;
                        height -= dy;
                    }
                }
                Dimension minSize = FDialog.this.getMinimumSize();
                Dimension maxSize = FDialog.this.getMaximumSize();
                if (width < minSize.width) {
                    dx += width - minSize.width;
                    width = minSize.width;
                } else if (width > maxSize.width) {
                    dx -= width - maxSize.width;
                    width = maxSize.width;
                }
                if (height < minSize.height) {
                    dy += height - minSize.height;
                    height = minSize.height;
                } else if (height > maxSize.height) {
                    dy -= height - maxSize.height;
                    height = maxSize.height;
                }
                int x = ((FDialog)FDialog.this).locBeforeMove.x;
                int y = ((FDialog)FDialog.this).locBeforeMove.y;
                switch (FDialog.this.resizeCursor) {
                    case 4: 
                    case 10: {
                        x += dx;
                        break;
                    }
                    case 7: 
                    case 8: {
                        y += dy;
                        break;
                    }
                    case 6: {
                        x += dx;
                        y += dy;
                    }
                }
                FDialog.this.setBounds(x, y, width, height);
            }
        });
    }

    @Override
    public boolean isMinimized() {
        return false;
    }

    @Override
    public void setMinimized(boolean b) {
    }

    @Override
    public boolean isMaximized() {
        return false;
    }

    @Override
    public void setMaximized(boolean b) {
    }

    @Override
    public boolean isFullScreen() {
        return false;
    }

    @Override
    public void setFullScreen(boolean b) {
    }

    @Override
    public boolean getLockTitleBar() {
        return false;
    }

    @Override
    public void setLockTitleBar(boolean b) {
    }

    @Override
    public Image getIconImage() {
        return this.getIconImages().isEmpty() ? null : this.getIconImages().get(0);
    }

    public static boolean isModalOpen() {
        return !openModals.isEmpty();
    }

    public static JPanel getBackdropPanel() {
        return backdropPanel;
    }

    static {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        isSetShapeSupported = gd.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.PERPIXEL_TRANSPARENT);
        antiAliasBorder = OperatingSystem.isWindows();
        openModals = new Stack();
        backdropPanel = new BackdropPanel();
    }

    private static class BackdropPanel
    extends JPanel {
        private static final FSkin.SkinColor backColor = FSkin.getColor(FSkin.Colors.CLR_OVERLAY).alphaColor(120);

        private BackdropPanel() {
            this.setOpaque(false);
            this.setVisible(false);
            this.setFocusable(false);
        }

        @Override
        public void paintComponent(Graphics g2) {
            super.paintComponent(g2);
            FSkin.setGraphicsColor(g2, backColor);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

