/*
 * Decompiled with CFR 0.152.
 */
package forge.util.storage;

import com.google.common.base.Function;
import forge.util.TextUtil;
import forge.util.storage.StorageReaderBase;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public abstract class StorageReaderFolder<T>
extends StorageReaderBase<T> {
    protected final File directory;
    public final List<String> objectsThatFailedToLoad = new ArrayList<String>();

    public File getDirectory() {
        return this.directory;
    }

    @Override
    public String getFullPath() {
        return this.directory.getPath();
    }

    public StorageReaderFolder(File itemDir0, Function<? super T, String> keySelector0) {
        super(keySelector0);
        this.directory = itemDir0;
        if (this.directory == null) {
            throw new IllegalArgumentException("No directory specified");
        }
        try {
            if (this.directory.isFile()) {
                throw new IOException("Not a directory");
            }
            this.directory.mkdirs();
            if (!this.directory.isDirectory()) {
                throw new IOException("Directory can't be created");
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("StorageReaderFolder.ctor() error, " + ex.getMessage());
        }
    }

    @Override
    public Map<String, T> readAll() {
        File[] files;
        Map result = this.createMap();
        for (File file : files = this.directory.listFiles(this.getFileFilter())) {
            try {
                T newDeck = this.read(file);
                if (null == newDeck) {
                    String msg = "An object stored in " + file.getPath() + " failed to load.\nPlease submit this as a bug with the mentioned file/directory attached.";
                    throw new RuntimeException(msg);
                }
                String newKey = (String)this.keySelector.apply(newDeck);
                if (result.containsKey(newKey)) {
                    newKey = newKey + "-" + file.getName();
                }
                if (result.containsKey(newKey)) {
                    System.err.println("StorageReaderFolder: Overwriting an object with key " + newKey);
                }
                result.put(newKey, newDeck);
            }
            catch (NoSuchElementException ex) {
                String message = TextUtil.concatWithSpace(file.getName(), "failed to load because ----", ex.getMessage());
                this.objectsThatFailedToLoad.add(message);
            }
        }
        return result;
    }

    protected abstract T read(File var1);

    protected abstract FilenameFilter getFileFilter();

    @Override
    public String getItemKey(T item) {
        return (String)this.keySelector.apply(item);
    }

    @Override
    public Iterable<File> getSubFolders() {
        File[] list = this.directory.listFiles(file -> file.isDirectory() && !file.isHidden());
        return Arrays.asList(list);
    }
}

