/*
 * Decompiled with CFR 0.152.
 */
package forge.util.storage;

import com.google.common.base.Function;
import forge.util.storage.IStorage;
import forge.util.storage.StorageBase;
import java.io.File;
import java.util.HashMap;

public class StorageNestedFolders<T>
extends StorageBase<IStorage<T>> {
    private final File thisFolder;

    public StorageNestedFolders(File thisFolder, Iterable<File> subfolders, Function<File, IStorage<T>> factory) {
        super("<Subfolders>", thisFolder.getPath(), new HashMap());
        this.thisFolder = thisFolder;
        for (File sf : subfolders) {
            IStorage<T> newUnit = factory.apply(sf);
            this.map.put(sf.getName(), newUnit);
        }
    }

    @Override
    public void add(IStorage<T> item) {
        File subdir = new File(this.thisFolder, item.getName());
        subdir.mkdir();
        throw new UnsupportedOperationException("method is not implemented");
    }

    @Override
    public void delete(String itemName) {
        File subdir = new File(this.thisFolder, itemName);
        IStorage f = (IStorage)this.map.remove(itemName);
        if (f != null) {
            subdir.delete();
        }
    }
}

