/*
 * Decompiled with CFR 0.152.
 */
package forge.util.maps;

import forge.util.maps.MapToAmount;
import java.util.LinkedHashMap;
import java.util.Map;

public class LinkedHashMapToAmount<T>
extends LinkedHashMap<T, Integer>
implements MapToAmount<T> {
    private static final long serialVersionUID = 1438913784333297606L;

    public static <T> LinkedHashMapToAmount<T> emptyMap() {
        return new LinkedHashMapToAmount<T>(0);
    }

    public LinkedHashMapToAmount() {
    }

    public LinkedHashMapToAmount(int arg0, float arg1) {
        super(arg0, arg1);
    }

    public LinkedHashMapToAmount(int arg0) {
        super(arg0);
    }

    public LinkedHashMapToAmount(MapToAmount<T> arg0) {
        super(arg0);
    }

    @Override
    public Integer put(T key, Integer value) {
        if (value == null) {
            throw new NullPointerException("Trying to put a key in a HashMapToAmount to null.");
        }
        return super.put(key, value);
    }

    @Override
    public void add(T item) {
        this.add(item, 1);
    }

    @Override
    public void add(T item, int amount) {
        if (amount <= 0) {
            return;
        }
        Integer cur = (Integer)this.get(item);
        int newVal = cur == null ? amount : amount + cur;
        this.put(item, newVal);
    }

    @Override
    public void addAll(Iterable<T> items) {
        for (T i : items) {
            this.add(i, 1);
        }
    }

    @Override
    public boolean substract(T item) {
        return this.substract(item, 1);
    }

    @Override
    public boolean substract(T item, int amount) {
        Integer cur = (Integer)this.get(item);
        if (cur == null) {
            return false;
        }
        int newVal = cur - amount;
        if (newVal > 0) {
            this.put(item, newVal);
        } else {
            this.remove(item);
        }
        return true;
    }

    @Override
    public void substractAll(Iterable<T> items) {
        for (T i : items) {
            this.substract(i);
        }
    }

    @Override
    public int countAll() {
        int c = 0;
        for (Map.Entry kv : this.entrySet()) {
            c += ((Integer)kv.getValue()).intValue();
        }
        return c;
    }

    @Override
    public int count(T item) {
        Integer cur = (Integer)this.get(item);
        return cur == null ? 0 : cur;
    }
}

