/*
 * Decompiled with CFR 0.152.
 */
package forge.util.maps;

import com.google.common.base.Supplier;
import forge.util.maps.MapOfLists;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HashMapOfLists<K, V>
extends HashMap<K, Collection<V>>
implements MapOfLists<K, V> {
    private final Supplier<? extends Collection<V>> factory;
    private static final long serialVersionUID = 3029089910183132930L;

    public HashMapOfLists(Supplier<? extends Collection<V>> factory) {
        this.factory = factory;
    }

    public HashMapOfLists(int initialCapacity, float loadFactor, Supplier<? extends Collection<V>> factory) {
        super(initialCapacity, loadFactor);
        this.factory = factory;
    }

    public HashMapOfLists(int initialCapacity, Supplier<? extends Collection<V>> factory) {
        super(initialCapacity);
        this.factory = factory;
    }

    public HashMapOfLists(Map<? extends K, ? extends List<V>> m4, Supplier<? extends Collection<V>> factory) {
        super(m4);
        this.factory = factory;
    }

    @Override
    public Collection<V> ensureCollectionFor(K key) {
        Collection<V> value = (Collection<V>)this.get(key);
        if (value == null) {
            value = this.factory.get();
            this.put(key, value);
        }
        return value;
    }

    @Override
    public void add(K key, V element) {
        this.ensureCollectionFor(key).add(element);
    }

    @Override
    public void addAll(K key, Collection<V> elements) {
        this.ensureCollectionFor(key).addAll(elements);
    }
}

