/*
 * Decompiled with CFR 0.152.
 */
package forge.util.collect;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import forge.util.collect.FCollectionReader;
import forge.util.collect.FCollectionView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang3.ArrayUtils;

public class FCollection<T>
implements List<T>,
FCollectionView<T>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -1664555336364294106L;
    private static final FCollection<?> EMPTY = new EmptyFCollection();
    private final Set<T> set = Sets.newHashSet();
    private final LinkedList<T> list = Lists.newLinkedList();

    public static <T> FCollection<T> getEmpty() {
        return EMPTY;
    }

    public FCollection() {
    }

    public FCollection(T e) {
        this.add(e);
    }

    public FCollection(T[] c) {
        this.addAll((Collection<? extends T>)Arrays.asList(c));
    }

    public FCollection(Iterable<? extends T> i) {
        this.addAll(i);
    }

    public FCollection(FCollectionReader<T> reader) {
        reader.readAll(this);
    }

    public static boolean hasElements(Iterable<?> iterable) {
        return iterable != null && !Iterables.isEmpty(iterable);
    }

    public static <T> boolean hasElement(Collection<T> collection, T element) {
        return collection != null && collection.contains(element);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof FCollection && this.hashCode() == obj.hashCode();
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    public String toString() {
        return this.list.toString();
    }

    public final FCollection<T> clone() {
        return new FCollection<T>(this.list);
    }

    @Override
    public T getFirst() {
        return this.list.getFirst();
    }

    @Override
    public T getLast() {
        return this.list.getLast();
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    public Set<T> asSet() {
        return this.set;
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(T e) {
        if (this.set.add(e)) {
            this.list.add(e);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (this.set.remove(o)) {
            this.list.remove(o);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        if (this.list.removeIf(filter)) {
            this.set.removeIf(filter);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.addAll((Iterable<? extends T>)c);
    }

    @Override
    public boolean addAll(Iterable<? extends T> i) {
        boolean changed = false;
        for (T e : i) {
            changed |= this.add(e);
        }
        return changed;
    }

    public boolean addAll(T[] c) {
        boolean changed = false;
        for (T e : c) {
            changed |= this.add(e);
        }
        return changed;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        if (c == null) {
            return false;
        }
        ArrayList<T> list = c instanceof List ? (ArrayList<T>)c : Lists.newArrayList(c);
        boolean changed = false;
        for (int i = list.size() - 1; i >= 0; --i) {
            changed |= this.insert(index, list.get(i));
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.removeAll((Iterable<?>)c);
    }

    @Override
    public boolean removeAll(Iterable<?> c) {
        boolean changed = false;
        for (Object o : c) {
            changed |= this.remove(o);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.set.retainAll(c)) {
            this.list.retainAll(c);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.set.isEmpty()) {
            return;
        }
        this.set.clear();
        this.list.clear();
    }

    @Override
    public T get(int index) {
        return this.list.get(index);
    }

    @Override
    public T set(int index, T element) {
        return this.list.set(index, element);
    }

    @Override
    public void add(int index, T element) {
        this.insert(index, element);
    }

    private boolean insert(int index, T element) {
        if (this.set.add(element)) {
            this.list.add(index, element);
            return true;
        }
        int oldIndex = this.list.indexOf(element);
        if (index == oldIndex) {
            return false;
        }
        if (index > oldIndex) {
            --index;
        }
        this.list.remove(oldIndex);
        this.list.add(index, element);
        return true;
    }

    @Override
    public T remove(int index) {
        T removedItem = this.list.remove(index);
        if (removedItem != null) {
            this.set.remove(removedItem);
        }
        return removedItem;
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return ImmutableList.copyOf(this.list.subList(fromIndex, toIndex));
    }

    public void sort() {
        this.sort((Comparator<? super T>)Ordering.usingToString());
    }

    @Override
    public void sort(Comparator<? super T> comparator) {
        this.list.sort(comparator);
    }

    @Override
    public Iterable<T> threadSafeIterable() {
        return Iterables.unmodifiableIterable(new LinkedList<T>(this.list));
    }

    @Override
    public T get(T obj) {
        if (obj == null) {
            return null;
        }
        for (T x : this) {
            if (!x.equals(obj)) continue;
            return x;
        }
        return obj;
    }

    public static class EmptyFCollection<T>
    extends FCollection<T> {
        private static final long serialVersionUID = 8667965158891635997L;

        @Override
        public final void add(int index, T element) {
        }

        @Override
        public final boolean add(T e) {
            return false;
        }

        @Override
        public final boolean addAll(Collection<? extends T> c) {
            return false;
        }

        @Override
        public final boolean addAll(int index, Collection<? extends T> c) {
            return false;
        }

        @Override
        public final boolean addAll(Iterable<? extends T> i) {
            return false;
        }

        @Override
        public final boolean addAll(T[] c) {
            return false;
        }

        @Override
        public final void clear() {
        }

        @Override
        public final boolean contains(Object o) {
            return false;
        }

        @Override
        public final boolean containsAll(Collection<?> c) {
            return c.isEmpty();
        }

        @Override
        public final T get(int index) {
            throw new IndexOutOfBoundsException("Any index is out of bounds for an empty collection");
        }

        @Override
        public final T getFirst() {
            throw new NoSuchElementException("Collection is empty");
        }

        @Override
        public final T getLast() {
            throw new NoSuchElementException("Collection is empty");
        }

        @Override
        public final int indexOf(Object o) {
            return -1;
        }

        @Override
        public final boolean isEmpty() {
            return true;
        }

        @Override
        public final Iterator<T> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public final int lastIndexOf(Object o) {
            return -1;
        }

        @Override
        public final ListIterator<T> listIterator() {
            return Collections.emptyListIterator();
        }

        @Override
        public final ListIterator<T> listIterator(int index) {
            return Collections.emptyListIterator();
        }

        @Override
        public final T remove(int index) {
            throw new IndexOutOfBoundsException("Any index is out of bounds for an empty collection");
        }

        @Override
        public final boolean remove(Object o) {
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return false;
        }

        @Override
        public final boolean removeAll(Iterable<?> c) {
            return false;
        }

        @Override
        public final boolean retainAll(Collection<?> c) {
            return false;
        }

        @Override
        public final T set(int index, T element) {
            throw new IndexOutOfBoundsException("Any index is out of bounds for an empty collection");
        }

        @Override
        public final int size() {
            return 0;
        }

        @Override
        public final void sort() {
        }

        @Override
        public final void sort(Comparator<? super T> comparator) {
        }

        @Override
        public final List<T> subList(int fromIndex, int toIndex) {
            if (fromIndex == 0 && toIndex == 0) {
                return this;
            }
            throw new IndexOutOfBoundsException("Any index is out of bounds for an empty collection");
        }

        @Override
        public final Iterable<T> threadSafeIterable() {
            return this;
        }

        @Override
        public final Object[] toArray() {
            return ArrayUtils.EMPTY_OBJECT_ARRAY;
        }

        @Override
        public final <T> T[] toArray(T[] a) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }

        @Override
        public final String toString() {
            return "[]";
        }
    }
}

