/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import forge.card.CardDb;
import forge.item.PaperCard;
import forge.util.Evaluator;
import forge.util.XmlWriter;
import java.io.File;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlReader {
    private Element currentElement;
    private static final PaperCardBuilder paperCardBuilder = new PaperCardBuilder();

    public XmlReader(String filename0) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = builder.parse(new File(filename0));
        this.currentElement = (Element)document.getFirstChild();
    }

    public String read(String key, String defaultValue) {
        if (this.currentElement.hasAttribute(key)) {
            return this.currentElement.getAttribute(key);
        }
        return defaultValue;
    }

    public <E extends Enum<E>> E read(String key, E defaultValue) {
        if (this.currentElement.hasAttribute(key)) {
            return Enum.valueOf(defaultValue.getDeclaringClass(), this.currentElement.getAttribute(key));
        }
        return defaultValue;
    }

    public int read(String key, int defaultValue) {
        if (this.currentElement.hasAttribute(key)) {
            return Integer.parseInt(this.currentElement.getAttribute(key));
        }
        return defaultValue;
    }

    public long read(String key, long defaultValue) {
        if (this.currentElement.hasAttribute(key)) {
            return Long.parseLong(this.currentElement.getAttribute(key));
        }
        return defaultValue;
    }

    public boolean read(String key, boolean defaultValue) {
        if (this.currentElement.hasAttribute(key)) {
            return Boolean.parseBoolean(this.currentElement.getAttribute(key));
        }
        return defaultValue;
    }

    public PaperCard read(String key, CardDb cardDb) {
        XmlReader.paperCardBuilder.setup(this, cardDb);
        return this.parseChildElements(key, paperCardBuilder);
    }

    public <T extends Collection<PaperCard>> void read(String key, T collectionToLoad, CardDb cardDb) {
        XmlReader.paperCardBuilder.setup(this, cardDb);
        this.parseChildElements(key, collectionToLoad, null, paperCardBuilder);
    }

    public <T extends Collection<PaperCard>> T read(String key, Class<T> collectionType, CardDb cardDb) {
        XmlReader.paperCardBuilder.setup(this, cardDb);
        return this.parseChildElements(key, null, collectionType, paperCardBuilder);
    }

    public <T extends XmlWriter.IXmlWritable> T read(String key, Class<T> type) {
        return (T)((XmlWriter.IXmlWritable)this.parseChildElements(key, new GenericBuilder(type)));
    }

    public <V extends XmlWriter.IXmlWritable, T extends Collection<V>> void read(String key, T collectionToLoad, Class<V> elementType) {
        this.parseChildElements(key, collectionToLoad, null, new GenericBuilder(elementType));
    }

    public <V extends XmlWriter.IXmlWritable, T extends Collection<V>> T read(String key, Class<T> collectionType, Class<V> elementType) {
        return this.parseChildElements(key, null, collectionType, new GenericBuilder(elementType));
    }

    public <V extends XmlWriter.IXmlWritable> void read(String key, final V[] array, final Class<V> elementType) {
        this.parseChildElements(key, new Evaluator<Void>(){

            @Override
            public Void evaluate() {
                final GenericBuilder builder = new GenericBuilder(elementType);
                return (Void)XmlReader.this.parseChildElements(null, new Evaluator<Void>(){

                    @Override
                    public Void evaluate() {
                        try {
                            Object value;
                            int arrayIndex = Integer.parseInt(XmlReader.this.currentElement.getTagName().substring(1));
                            if (arrayIndex >= 0 && arrayIndex < array.length && (value = builder.evaluate()) != null) {
                                array[arrayIndex] = value;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return null;
                    }
                });
            }
        });
    }

    public <V extends XmlWriter.IXmlWritable> void read(String key, final Map<String, V> map, final Class<V> valueType) {
        this.parseChildElements(key, new Evaluator<Void>(){

            @Override
            public Void evaluate() {
                final GenericBuilder builder = new GenericBuilder(valueType);
                return (Void)XmlReader.this.parseChildElements(null, new Evaluator<Void>(){

                    @Override
                    public Void evaluate() {
                        try {
                            String key = XmlReader.this.currentElement.getTagName();
                            Object value = builder.evaluate();
                            if (value != null) {
                                map.put(key, value);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return null;
                    }
                });
            }
        });
    }

    public <E extends Enum<E>, V extends XmlWriter.IXmlWritable> void read(String key, final EnumMap<E, V> enumMap, final Class<E> enumType, final Class<V> valueType) {
        this.parseChildElements(key, new Evaluator<Void>(){

            @Override
            public Void evaluate() {
                final GenericBuilder builder = new GenericBuilder(valueType);
                return (Void)XmlReader.this.parseChildElements(null, new Evaluator<Void>(){

                    @Override
                    public Void evaluate() {
                        try {
                            Object mapKey = Enum.valueOf(enumType, XmlReader.this.currentElement.getTagName());
                            Object value = builder.evaluate();
                            if (value != null) {
                                enumMap.put(mapKey, value);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return null;
                    }
                });
            }
        });
    }

    private <T> T parseChildElements(String findKey, Evaluator<T> handler) {
        Element parentElement = this.currentElement;
        NodeList childNodes = this.currentElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if (findKey != null && !element.getTagName().equals(findKey)) continue;
            this.currentElement = (Element)node;
            T result = handler.evaluate();
            this.currentElement = parentElement;
            if (findKey == null) continue;
            return result;
        }
        return null;
    }

    private <V, T extends Collection<V>> T parseChildElements(String key, final T collectionToLoad, final Class<T> collectionType, final Evaluator<V> builder) {
        Collection<Object> result = (Collection)this.parseChildElements(key, new Evaluator<T>(){

            @Override
            public T evaluate() {
                Collection result;
                if (collectionToLoad == null) {
                    try {
                        result = (Collection)collectionType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                } else {
                    result = collectionToLoad;
                }
                XmlReader.this.parseChildElements(null, new Evaluator<V>(){

                    @Override
                    public V evaluate() {
                        Object value = builder.evaluate();
                        if (value != null) {
                            result.add(value);
                        }
                        return value;
                    }
                });
                return result;
            }
        });
        if (result == null) {
            result = collectionToLoad;
        }
        return (T)result;
    }

    private class GenericBuilder<T extends XmlWriter.IXmlWritable>
    extends Evaluator<T> {
        private final Class<T> type;

        private GenericBuilder(Class<T> type0) {
            this.type = type0;
        }

        @Override
        public T evaluate() {
            try {
                return (T)((XmlWriter.IXmlWritable)this.type.getDeclaredConstructor(XmlReader.class).newInstance(XmlReader.this));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private static class PaperCardBuilder
    extends Evaluator<PaperCard> {
        private XmlReader xml;
        private CardDb cardDb;

        private PaperCardBuilder() {
        }

        private void setup(XmlReader xml0, CardDb cardDb0) {
            this.xml = xml0;
            this.cardDb = cardDb0;
        }

        @Override
        public PaperCard evaluate() {
            int artIndex;
            String setCode;
            String name = this.xml.read("name", "");
            PaperCard card = this.cardDb.getCard(name, setCode = this.xml.read("set", ""), artIndex = this.xml.read("art", 0));
            if (card == null) {
                card = this.cardDb.getCard(name);
            }
            return card;
        }
    }
}

