/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import forge.util.BuildInfo;
import forge.util.ImageFetcher;
import forge.util.TextUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;

public class SwingImageFetcher
extends ImageFetcher {
    @Override
    protected Runnable getDownloadTask(String[] downloadUrls, String destPath, Runnable notifyObservers) {
        return new SwingDownloadTask(downloadUrls, destPath, notifyObservers);
    }

    private static class SwingDownloadTask
    implements Runnable {
        private final String[] downloadUrls;
        private final String destPath;
        private final Runnable notifyObservers;

        public SwingDownloadTask(String[] downloadUrls, String destPath, Runnable notifyObservers) {
            this.downloadUrls = downloadUrls;
            this.destPath = destPath;
            this.notifyObservers = notifyObservers;
        }

        private void doFetch(String urlToDownload) throws IOException {
            String newdespath;
            String string = newdespath = urlToDownload.contains(".fullborder.jpg") || urlToDownload.startsWith("https://api.scryfall.com/cards/") ? TextUtil.fastReplace(this.destPath, ".full.jpg", ".fullborder.jpg") : this.destPath;
            if (!newdespath.contains(".full") && urlToDownload.startsWith("https://api.scryfall.com/cards/")) {
                newdespath = newdespath.replace(".jpg", ".fullborder.jpg");
            }
            URL url = new URL(urlToDownload);
            System.out.println("Attempting to fetch: " + url);
            BufferedImage image = ImageIO.read(url);
            File destFile = new File(newdespath + ".tmp");
            destFile.getParentFile().mkdirs();
            if (ImageIO.write((RenderedImage)image, "jpg", destFile)) {
                if (destFile.renameTo(new File(newdespath))) {
                    System.out.println("Saved image to " + newdespath);
                    SwingUtilities.invokeLater(this.notifyObservers);
                } else {
                    System.err.println("Failed to rename image to " + newdespath);
                }
            } else {
                System.err.println("Failed to save image from " + url + " as jpeg");
                if (ImageIO.write((RenderedImage)image, "png", destFile)) {
                    String newPath = newdespath.replace(".jpg", ".png");
                    if (destFile.renameTo(new File(newPath))) {
                        System.out.println("Saved image to " + newPath);
                        SwingUtilities.invokeLater(this.notifyObservers);
                    } else {
                        System.err.println("Failed to rename image to " + newPath);
                    }
                } else {
                    System.err.println("Failed to save image from " + url + " as png");
                }
            }
        }

        private String tofullBorder(String imageurl) {
            if (!imageurl.contains(".full.jpg")) {
                return imageurl;
            }
            try {
                URL url = new URL(imageurl);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("User-Agent", BuildInfo.getUserAgent());
                if (conn.getResponseCode() == 404) {
                    imageurl = TextUtil.fastReplace(imageurl, ".full.jpg", ".fullborder.jpg");
                }
                conn.disconnect();
                return imageurl;
            }
            catch (IOException ex) {
                return imageurl;
            }
        }

        @Override
        public void run() {
            for (String urlToDownload : this.downloadUrls) {
                try {
                    this.doFetch(this.tofullBorder(urlToDownload));
                    break;
                }
                catch (IOException e) {
                    System.err.println("Failed to download card [" + this.destPath + "] image: " + e.getMessage());
                    if (!urlToDownload.contains("tokens")) continue;
                    int setIndex = urlToDownload.lastIndexOf(95);
                    int typeIndex = urlToDownload.lastIndexOf(46);
                    String setlessFilename = urlToDownload.substring(0, setIndex);
                    String extension = urlToDownload.substring(typeIndex);
                    urlToDownload = setlessFilename + extension;
                    try {
                        this.doFetch(this.tofullBorder(urlToDownload));
                        break;
                    }
                    catch (IOException t2) {
                        System.err.println("Failed to download setless token [" + this.destPath + "]: " + e.getMessage());
                    }
                }
            }
        }
    }
}

