/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import com.google.common.base.Predicate;
import org.apache.commons.lang3.StringUtils;

public abstract class PredicateString<T>
implements Predicate<T> {
    private final StringOp operator;

    protected final boolean op(String op1, String op2) {
        switch (this.getOperator()) {
            case CONTAINS_IC: {
                return StringUtils.containsIgnoreCase(op1, op2);
            }
            case CONTAINS: {
                return StringUtils.contains((CharSequence)op1, op2);
            }
            case EQUALS: {
                return op1.equals(op2);
            }
            case EQUALS_IC: {
                return op1.equalsIgnoreCase(op2);
            }
        }
        return false;
    }

    public PredicateString(StringOp operator) {
        this.operator = operator;
    }

    public StringOp getOperator() {
        return this.operator;
    }

    public static PredicateString<String> contains(final String what) {
        return new PredicateString<String>(StringOp.CONTAINS){

            @Override
            public boolean apply(String subject) {
                return this.op(subject, what);
            }
        };
    }

    public static PredicateString<String> containsIgnoreCase(final String what) {
        return new PredicateString<String>(StringOp.CONTAINS_IC){

            @Override
            public boolean apply(String subject) {
                return this.op(subject, what);
            }
        };
    }

    public static PredicateString<String> equals(final String what) {
        return new PredicateString<String>(StringOp.EQUALS){

            @Override
            public boolean apply(String subject) {
                return this.op(subject, what);
            }
        };
    }

    public static enum StringOp {
        CONTAINS,
        CONTAINS_IC,
        EQUALS,
        EQUALS_IC;

    }
}

