/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import forge.gui.FThreads;
import forge.util.ThreadUtil;
import java.awt.Robot;
import java.util.concurrent.ScheduledFuture;

public class OperatingSystem {
    private static String os = System.getProperty("os.name").toLowerCase();
    private static boolean preventSleep;
    private static ScheduledFuture<?> delayedKeepAwakeTask;
    private static Runnable keepSystemAwake;

    public static boolean isWindows() {
        return os.contains("win");
    }

    public static boolean isMac() {
        return os.contains("mac");
    }

    public static boolean isUnix() {
        return os.contains("nix") || os.contains("nux") || os.contains("aix");
    }

    public static boolean isSolaris() {
        return os.contains("sunos");
    }

    public static void preventSystemSleep(boolean preventSleep0) {
        if (preventSleep == preventSleep0) {
            return;
        }
        preventSleep = preventSleep0;
        if (delayedKeepAwakeTask != null) {
            delayedKeepAwakeTask.cancel(false);
            delayedKeepAwakeTask = null;
        }
        if (preventSleep) {
            FThreads.invokeInEdtNowOrLater(keepSystemAwake);
        }
    }

    static {
        keepSystemAwake = new Runnable(){

            @Override
            public void run() {
                if (!preventSleep) {
                    return;
                }
                try {
                    Robot robot = new Robot();
                    if (OperatingSystem.isMac()) {
                        robot.keyPress(115);
                    } else {
                        robot.keyPress(61442);
                    }
                    delayedKeepAwakeTask = ThreadUtil.delay(30000, keepSystemAwake);
                }
                catch (Exception e) {
                    preventSleep = false;
                    delayedKeepAwakeTask = null;
                    e.printStackTrace();
                }
            }
        };
    }
}

