/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import forge.util.LocalizationChangeObserver;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Localizer {
    private static Localizer instance;
    private List<LocalizationChangeObserver> observers = new ArrayList<LocalizationChangeObserver>();
    private Locale locale;
    private ResourceBundle resourceBundle;
    private ResourceBundle englishBundle;
    private boolean silent = false;
    private boolean english = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Localizer getInstance() {
        if (instance != null) return instance;
        Class<Localizer> clazz = Localizer.class;
        synchronized (Localizer.class) {
            instance = new Localizer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setEnglish(boolean value) {
        this.english = value;
    }

    private Localizer() {
    }

    public void initialize(String localeID, String languagesDirectory) {
        this.setLanguage(localeID, languagesDirectory);
    }

    public String convert(String value, String fromEncoding, String toEncoding) throws UnsupportedEncodingException {
        return new String(value.getBytes(fromEncoding), toEncoding);
    }

    public String charset(String value, String[] charsets) {
        String probe = StandardCharsets.UTF_8.name();
        for (String c : charsets) {
            Charset charset = Charset.forName(c);
            if (charset == null) continue;
            try {
                if (!value.equals(this.convert(this.convert(value, charset.name(), probe), probe, charset.name()))) continue;
                return c;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return StandardCharsets.UTF_8.name();
    }

    public String getMessageorUseDefault(String key, String defaultValue, Object ... messageArguments) {
        try {
            this.silent = true;
            String value = this.getMessage(key, messageArguments);
            if (value.contains("INVALID PROPERTY:")) {
                return defaultValue;
            }
            return value;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String getEnglishMessage(String key, Object ... messageArguments) {
        return this.getMessage(true, key, messageArguments);
    }

    public String getMessage(String key, Object ... messageArguments) {
        return this.getMessage(false, key, messageArguments);
    }

    public String getMessage(boolean forcedEnglish, String key, Object ... messageArguments) {
        MessageFormat formatter;
        block13: {
            formatter = null;
            try {
                formatter = new MessageFormat(this.english || forcedEnglish ? this.englishBundle.getString(key) : this.resourceBundle.getString(key), this.english || forcedEnglish ? Locale.ENGLISH : this.locale);
            }
            catch (IllegalArgumentException | MissingResourceException e) {
                if (this.silent) break block13;
                e.printStackTrace();
            }
        }
        if (formatter == null) {
            if (!this.silent) {
                System.err.println("INVALID PROPERTY: '" + key + "' -- Translation missing from " + this.locale);
            }
            if (this.english || forcedEnglish) {
                return "INVALID PROPERTY: '" + key + "' -- Translation missing from English?";
            }
            try {
                formatter = new MessageFormat(this.englishBundle.getString(key), Locale.ENGLISH);
                forcedEnglish = true;
            }
            catch (IllegalArgumentException | MissingResourceException e) {
                if (!this.silent) {
                    e.printStackTrace();
                }
                return "INVALID PROPERTY: '" + key + "' -- Translation missing from English locale?";
            }
        }
        this.silent = false;
        formatter.setLocale(this.english || forcedEnglish ? Locale.ENGLISH : this.locale);
        String formattedMessage = "CHAR ENCODING ERROR";
        String[] charsets = new String[]{"ISO-8859-1", "UTF-8"};
        String detectedCharset = this.charset(this.english || forcedEnglish ? this.englishBundle.getString(key) : this.resourceBundle.getString(key), charsets);
        int argLength = messageArguments.length;
        Object[] syncEncodingMessageArguments = new Object[argLength];
        for (int i = 0; i < argLength; ++i) {
            String objCharset = this.charset(messageArguments[i].toString(), charsets);
            try {
                syncEncodingMessageArguments[i] = this.convert(messageArguments[i].toString(), objCharset, detectedCharset);
                continue;
            }
            catch (UnsupportedEncodingException ignored) {
                System.err.println("Cannot Convert '" + messageArguments[i].toString() + "' from '" + objCharset + "' To '" + detectedCharset + "'");
                return "encoding '" + key + "' translate string failure";
            }
        }
        try {
            formattedMessage = new String(formatter.format(syncEncodingMessageArguments).getBytes(detectedCharset), StandardCharsets.UTF_8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return formattedMessage;
    }

    public void setLanguage(String languageRegionID, String languagesDirectory) {
        String[] splitLocale = languageRegionID.split("-");
        Locale oldLocale = this.locale;
        this.locale = new Locale(splitLocale[0], splitLocale[1]);
        if (oldLocale == null || !oldLocale.equals(this.locale)) {
            File file = new File(languagesDirectory);
            URL[] urls = null;
            try {
                urls = new URL[]{file.toURI().toURL()};
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            URLClassLoader loader = new URLClassLoader(urls);
            try {
                this.resourceBundle = ResourceBundle.getBundle(languageRegionID, new Locale(splitLocale[0], splitLocale[1]), loader);
                this.englishBundle = ResourceBundle.getBundle("en-US", new Locale("en", "US"), loader);
            }
            catch (NullPointerException | MissingResourceException e) {
                this.resourceBundle = ResourceBundle.getBundle("en-US", new Locale("en_US"), loader);
                e.printStackTrace();
            }
            System.out.println("Language '" + this.resourceBundle.getBaseBundleName() + "' loaded successfully.");
            this.notifyObservers();
        }
    }

    public List<Language> getLanguages() {
        return null;
    }

    public void registerObserver(LocalizationChangeObserver observer) {
        this.observers.add(observer);
    }

    private void notifyObservers() {
        for (LocalizationChangeObserver observer : this.observers) {
            observer.localizationChanged();
        }
    }

    public static class Language {
        public String languageName;
        public String languageID;
    }
}

