/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import forge.ImageKeys;
import forge.StaticData;
import forge.card.CardEdition;
import forge.gui.FThreads;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.util.FileUtil;
import forge.util.ImageUtil;
import forge.util.TextUtil;
import forge.util.ThreadUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ImageFetcher {
    private static final HashMap<String, String> langCodeMap = new HashMap();
    private HashMap<String, HashSet<Callback>> currentFetches = new HashMap();
    private HashMap<String, String> tokenImages;

    private String getScryfallDownloadURL(PaperCard c, String face, boolean useArtCrop, boolean hasSetLookup, String imagePath, ArrayList<String> downloadUrls) {
        StaticData data = StaticData.instance();
        CardEdition edition = data.getEditions().get(c.getEdition());
        if (edition == null) {
            return null;
        }
        if (hasSetLookup) {
            Collection clones = StaticData.instance().getCommonCards().getAllCards(c.getName());
            for (PaperCard pc : clones) {
                String langCode;
                String setCode;
                CardEdition ed;
                if (clones.size() > 1) {
                    if (c.getEdition().equalsIgnoreCase(pc.getEdition()) || (ed = data.getEditions().get(pc.getEdition())) == null) continue;
                    setCode = ed.getScryfallCode();
                    langCode = ed.getCardsLangCode();
                    downloadUrls.add("https://api.scryfall.com/cards/" + ImageUtil.getScryfallDownloadUrl(pc, face, setCode, langCode, useArtCrop));
                    continue;
                }
                ed = data.getEditions().get(pc.getEdition());
                if (ed == null) continue;
                setCode = ed.getScryfallCode();
                langCode = ed.getCardsLangCode();
                downloadUrls.add("https://api.scryfall.com/cards/" + ImageUtil.getScryfallDownloadUrl(pc, face, setCode, langCode, useArtCrop));
            }
        } else {
            String setCode = edition.getScryfallCode();
            String langCode = edition.getCardsLangCode();
            String primaryUrl = ImageUtil.getScryfallDownloadUrl(c, face, setCode, langCode, useArtCrop);
            downloadUrls.add("https://api.scryfall.com/cards/" + primaryUrl);
            String alternateUrl = ImageUtil.getScryfallDownloadUrl(c, face, setCode, langCode, useArtCrop, true);
            if (alternateUrl != null && !alternateUrl.equals(primaryUrl)) {
                downloadUrls.add("https://api.scryfall.com/cards/" + alternateUrl);
            }
        }
        return null;
    }

    public void fetchImage(String imageKey, Callback callback) {
        Object paperCard;
        FThreads.assertExecutedByEdt(true);
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_DISABLE_CARD_IMAGES)) {
            return;
        }
        if (!FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_ENABLE_ONLINE_IMAGE_FETCHER)) {
            return;
        }
        if (imageKey.length() < 2) {
            return;
        }
        if (imageKey.startsWith("PLANECHASEBG:")) {
            ArrayList<String> downloadUrls = new ArrayList<String>();
            String filename = imageKey.substring("PLANECHASEBG:".length());
            downloadUrls.add("https://downloads.cardforge.org/images/planes/" + filename);
            FileUtil.ensureDirectoryExists(ForgeConstants.CACHE_PLANECHASE_PICS_DIR);
            File destFile = new File(ForgeConstants.CACHE_PLANECHASE_PICS_DIR, filename);
            if (destFile.exists()) {
                return;
            }
            this.setupObserver(destFile.getAbsolutePath(), callback, downloadUrls);
            return;
        }
        boolean useArtCrop = "Crop".equals(FModel.getPreferences().getPref(ForgePreferences.FPref.UI_CARD_ART_FORMAT));
        String prefix = imageKey.substring(0, 2);
        ArrayList<String> downloadUrls = new ArrayList<String>();
        File destFile = null;
        if (prefix.equals("c:")) {
            String cardCollectorNumber;
            paperCard = ImageUtil.getPaperCardFromImageKey(imageKey);
            if (paperCard == null) {
                System.err.println("Paper card not found for: " + imageKey);
                return;
            }
            if (((PaperCard)paperCard).getRules().isCustom()) {
                return;
            }
            if (useArtCrop && ((PaperCard)paperCard).getArtist().isEmpty()) {
                return;
            }
            String imagePath = ImageUtil.getImageRelativePath((PaperCard)paperCard, "", true, false);
            boolean hasSetLookup = ImageKeys.hasSetLookup(imagePath);
            String face = "";
            if (imageKey.endsWith("$alt")) {
                face = "back";
            } else if (imageKey.endsWith("$wspec")) {
                face = "white";
            } else if (imageKey.endsWith("$uspec")) {
                face = "blue";
            } else if (imageKey.endsWith("$bspec")) {
                face = "black";
            } else if (imageKey.endsWith("$rspec")) {
                face = "red";
            } else if (imageKey.endsWith("$gspec")) {
                face = "green";
            }
            String filename = "";
            switch (face) {
                case "back": {
                    filename = ((PaperCard)paperCard).getCardAltImageKey();
                    break;
                }
                case "white": {
                    filename = ((PaperCard)paperCard).getCardWSpecImageKey();
                    break;
                }
                case "blue": {
                    filename = ((PaperCard)paperCard).getCardUSpecImageKey();
                    break;
                }
                case "black": {
                    filename = ((PaperCard)paperCard).getCardBSpecImageKey();
                    break;
                }
                case "red": {
                    filename = ((PaperCard)paperCard).getCardRSpecImageKey();
                    break;
                }
                case "green": {
                    filename = ((PaperCard)paperCard).getCardGSpecImageKey();
                    break;
                }
                default: {
                    filename = ((PaperCard)paperCard).getCardImageKey();
                }
            }
            if (useArtCrop) {
                filename = TextUtil.fastReplace(filename, ".full", ".artcrop");
            }
            boolean updateLink = false;
            if ("back".equals(face)) {
                try {
                    filename = TextUtil.fastReplace(filename, "1.full", imageKey.substring(imageKey.lastIndexOf(124) + 1, imageKey.indexOf(36)) + ".full");
                    updateLink = true;
                }
                catch (Exception e) {
                    filename = ((PaperCard)paperCard).getCardAltImageKey();
                    updateLink = false;
                }
            }
            destFile = new File(ForgeConstants.CACHE_CARD_PICS_DIR, filename + ".jpg");
            if (!useArtCrop) {
                StringBuilder setDownload = new StringBuilder("https://downloads.cardforge.org/images/cards/");
                if (!hasSetLookup) {
                    if (!updateLink) {
                        setDownload.append(ImageUtil.getDownloadUrl((PaperCard)paperCard, face));
                    } else {
                        String url = ImageUtil.getDownloadUrl((PaperCard)paperCard, face);
                        setDownload.append(TextUtil.fastReplace(url, "1.full", imageKey.substring(imageKey.lastIndexOf(124) + 1, imageKey.indexOf(36)) + ".full"));
                    }
                    downloadUrls.add(setDownload.toString());
                } else {
                    Collection clones = StaticData.instance().getCommonCards().getAllCards(((PaperCard)paperCard).getName());
                    for (PaperCard pc : clones) {
                        StringBuilder set;
                        if (clones.size() > 1) {
                            if (((PaperCard)paperCard).getEdition().equalsIgnoreCase(pc.getEdition())) continue;
                            set = new StringBuilder("https://downloads.cardforge.org/images/cards/");
                            set.append(ImageUtil.getDownloadUrl(pc, face));
                            downloadUrls.add(set.toString());
                            continue;
                        }
                        set = new StringBuilder("https://downloads.cardforge.org/images/cards/");
                        set.append(ImageUtil.getDownloadUrl(pc, face));
                        downloadUrls.add(set.toString());
                    }
                }
            }
            if (!(cardCollectorNumber = ((PaperCard)paperCard).getCollectorNumber()).equals("N.A.")) {
                this.getScryfallDownloadURL((PaperCard)paperCard, face, useArtCrop, hasSetLookup, filename, downloadUrls);
            }
        } else if (prefix.equals("t:")) {
            String filename;
            String tokenUrl;
            if (this.tokenImages == null) {
                this.tokenImages = new HashMap();
                paperCard = FileUtil.readNameUrlFile(ForgeConstants.IMAGE_LIST_TOKENS_FILE).iterator();
                while (paperCard.hasNext()) {
                    Pair nameUrlPair = (Pair)paperCard.next();
                    this.tokenImages.put((String)nameUrlPair.getLeft(), (String)nameUrlPair.getRight());
                }
            }
            if ((tokenUrl = this.tokenImages.get(filename = imageKey.substring(2) + ".jpg")) == null) {
                CardEdition E;
                String[] tempdata = imageKey.split("[_](?=[^_]*$)");
                if (tempdata.length == 2 && (E = StaticData.instance().getEditions().get(tempdata[1])) != null && E.getType() == CardEdition.Type.CUSTOM_SET) {
                    return;
                }
                System.err.println("No specified file for '" + filename + "'.. Attempting to download from default Url");
                tokenUrl = String.format("%s%s", "https://downloads.cardforge.org/images/tokens/", filename);
            }
            destFile = new File(ForgeConstants.CACHE_TOKEN_PICS_DIR, filename);
            downloadUrls.add(tokenUrl);
        }
        if (downloadUrls.isEmpty()) {
            System.err.println("No download URLs for: " + imageKey);
            return;
        }
        if (destFile.exists()) {
            if (prefix.equals("c:") && (paperCard = ImageUtil.getPaperCardFromImageKey(imageKey)) != null) {
                ((PaperCard)paperCard).hasImage(true);
            }
            return;
        }
        this.setupObserver(destFile.getAbsolutePath(), callback, downloadUrls);
    }

    private void setupObserver(String destPath, Callback callback, ArrayList<String> downloadUrls) {
        HashSet<Callback> observers = this.currentFetches.get(destPath);
        if (observers != null) {
            observers.add(callback);
            return;
        }
        observers = new HashSet();
        observers.add(callback);
        this.currentFetches.put(destPath, observers);
        Runnable notifyObservers = () -> {
            FThreads.assertExecutedByEdt(true);
            for (Callback o : this.currentFetches.get(destPath)) {
                if (o == null) continue;
                o.onImageFetched();
            }
            this.currentFetches.remove(destPath);
        };
        try {
            ThreadUtil.getServicePool().submit(this.getDownloadTask(downloadUrls.toArray(new String[0]), destPath, notifyObservers));
        }
        catch (RejectedExecutionException re) {
            re.printStackTrace();
        }
    }

    protected abstract Runnable getDownloadTask(String[] var1, String var2, Runnable var3);

    static {
        langCodeMap.put("en-US", "en");
        langCodeMap.put("es-ES", "es");
        langCodeMap.put("fr-FR", "fr");
        langCodeMap.put("de-DE", "de");
        langCodeMap.put("it-IT", "it");
        langCodeMap.put("pt-BR", "pt");
        langCodeMap.put("ja-JP", "ja");
        langCodeMap.put("ko-KR", "ko");
        langCodeMap.put("ru-RU", "ru");
        langCodeMap.put("zh-CN", "zhs");
        langCodeMap.put("zh-HK", "zht");
    }

    public static interface Callback {
        public void onImageFetched();
    }
}

