/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;

public class BagRandomizer<T>
implements Iterable<T> {
    private static Random random = new SecureRandom();
    private T[] bag;
    private int currentPosition = 0;

    public BagRandomizer(T[] items) throws IllegalArgumentException {
        if (items.length == 0) {
            throw new IllegalArgumentException("Must include at least one item!");
        }
        this.bag = items;
        this.shuffleBag();
    }

    public BagRandomizer(Iterable<T> items) throws IllegalArgumentException {
        ArrayList<T> list = new ArrayList<T>();
        for (T item : items) {
            list.add(item);
        }
        if (list.size() == 0) {
            throw new IllegalArgumentException("Must include at least one item!");
        }
        this.bag = list.toArray();
        this.shuffleBag();
    }

    public T getNextItem() {
        if (this.currentPosition >= this.bag.length) {
            this.shuffleBag();
            this.currentPosition = 0;
        }
        return this.bag[this.currentPosition++];
    }

    private void shuffleBag() {
        int n = this.bag.length;
        for (int i = 0; i < n; ++i) {
            int r = (int)(random.nextDouble() * (double)(i + 1));
            T swap = this.bag[r];
            this.bag[r] = this.bag[i];
            this.bag[i] = swap;
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new BagRandomizerIterator();
    }

    private class BagRandomizerIterator<T>
    implements Iterator<T> {
        private BagRandomizerIterator() {
        }

        @Override
        public boolean hasNext() {
            return BagRandomizer.this.bag.length > 0;
        }

        @Override
        public T next() {
            return BagRandomizer.this.getNextItem();
        }
    }
}

