/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import forge.util.MyRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class Aggregates {
    public static final <T> Integer max(Iterable<T> source, Function<T, Integer> valueAccessor) {
        if (source == null) {
            return null;
        }
        int max = Integer.MIN_VALUE;
        for (T c : source) {
            int value = valueAccessor.apply(c);
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    public static final <T> Integer min(Iterable<T> source, Function<T, Integer> valueAccessor) {
        if (source == null) {
            return null;
        }
        int max = Integer.MAX_VALUE;
        for (T c : source) {
            int value = valueAccessor.apply(c);
            if (value >= max) continue;
            max = value;
        }
        return max;
    }

    public static final <T> T itemWithMax(Iterable<T> source, Function<T, Integer> valueAccessor) {
        if (source == null) {
            return null;
        }
        int max = Integer.MIN_VALUE;
        T result = null;
        for (T c : source) {
            int value = valueAccessor.apply(c);
            if (value <= max) continue;
            max = value;
            result = c;
        }
        return result;
    }

    public static final <T> List<T> listWithMin(Iterable<T> source, Function<T, Integer> valueAccessor) {
        if (source == null) {
            return null;
        }
        int min2 = Integer.MAX_VALUE;
        ArrayList<T> result = Lists.newArrayList();
        for (T c : source) {
            int value = valueAccessor.apply(c);
            if (value == min2) {
                result.add(c);
            }
            if (value >= min2) continue;
            min2 = value;
            result.clear();
            result.add(c);
        }
        return result;
    }

    public static final <T> int sum(Iterable<T> source, Function<T, Integer> valueAccessor) {
        int result = 0;
        if (source != null) {
            for (T c : source) {
                result += valueAccessor.apply(c).intValue();
            }
        }
        return result;
    }

    public static final <T> T random(T[] source) {
        if (source == null) {
            return null;
        }
        switch (source.length) {
            case 0: {
                return null;
            }
            case 1: {
                return source[0];
            }
        }
        return source[MyRandom.getRandom().nextInt(source.length)];
    }

    public static final <T> T random(Iterable<T> source) {
        if (source == null) {
            return null;
        }
        if (source instanceof List) {
            List src = (List)source;
            int len = src.size();
            switch (len) {
                case 0: {
                    return null;
                }
                case 1: {
                    return (T)src.get(0);
                }
            }
            return (T)src.get(MyRandom.getRandom().nextInt(len));
        }
        T candidate = null;
        int lowest = Integer.MAX_VALUE;
        for (T item : source) {
            int next = MyRandom.getRandom().nextInt();
            if (next >= lowest) continue;
            lowest = next;
            candidate = item;
        }
        return candidate;
    }

    public static final <T> List<T> random(Iterable<T> source, int count) {
        return Aggregates.random(source, count, new ArrayList());
    }

    public static final <T, L extends List<T>> L random(Iterable<T> source, int count, L list) {
        int i = 0;
        for (T item : source) {
            if (++i <= count) {
                list.add(item);
                continue;
            }
            int j = MyRandom.getRandom().nextInt(i);
            if (j >= count) continue;
            list.set(j, item);
        }
        return list;
    }

    public static final <T> T removeRandom(List<T> source) {
        if (source == null || source.isEmpty()) {
            return null;
        }
        int index = source.size() > 1 ? MyRandom.getRandom().nextInt(source.size()) : 0;
        return source.remove(index);
    }

    public static int randomInt(int min2, int max) {
        return MyRandom.getRandom().nextInt(max - min2 + 1) + min2;
    }

    public static final <K, U> Iterable<U> uniqueByLast(Iterable<U> source, Function<U, K> fnUniqueKey) {
        Hashtable<K, U> uniques = new Hashtable<K, U>();
        for (U c : source) {
            uniques.put(fnUniqueKey.apply(c), c);
        }
        return uniques.values();
    }

    public static <T> T itemWithMin(Iterable<T> source, Function<T, Integer> valueAccessor) {
        if (source == null) {
            return null;
        }
        int max = Integer.MAX_VALUE;
        T result = null;
        for (T c : source) {
            int value = valueAccessor.apply(c);
            if (value >= max) continue;
            max = value;
            result = c;
        }
        return result;
    }

    public static <TItem, TField> TItem firstFieldEquals(List<TItem> source, Function<TItem, TField> valueAccessor, TField valueEquals) {
        if (source == null) {
            return null;
        }
        if (valueEquals == null) {
            for (TItem c : source) {
                if (null != valueAccessor.apply(c)) continue;
                return c;
            }
        } else {
            for (TItem c : source) {
                if (!valueEquals.equals(valueAccessor.apply(c))) continue;
                return c;
            }
        }
        return null;
    }

    public static <T, U> Iterable<Map.Entry<U, Integer>> groupSumBy(Iterable<Map.Entry<T, Integer>> source, Function<T, U> fnGetField) {
        HashMap<U, Integer> result = new HashMap<U, Integer>();
        for (Map.Entry<T, Integer> kv : source) {
            U k = fnGetField.apply(kv.getKey());
            Integer v = kv.getValue();
            Integer sum = (Integer)result.get(k);
            int n = v == null ? 0 : v;
            int s2 = sum == null ? 0 : sum;
            result.put(k, s2 + n);
        }
        return result.entrySet();
    }
}

