/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import forge.util.MyRandom;
import java.util.List;

public abstract class AbstractGeneticAlgorithm<T> {
    protected List<T> population;
    private int targetPopulationSize;
    private float pruneRatio = 0.5f;
    public int generationCount = 0;

    public void initializePopulation(List<T> population) {
        this.population = population;
        this.targetPopulationSize = population.size();
    }

    protected abstract void evaluateFitness();

    protected abstract T expandPool();

    public void pruneWeakest() {
        this.population = this.population.subList(0, Float.valueOf((float)this.population.size() * this.pruneRatio).intValue());
    }

    protected void generateChildren() {
        int prunedSize = this.population.size();
        while (this.population.size() < this.targetPopulationSize) {
            int randomIndex = Double.valueOf((double)prunedSize * Math.pow(MyRandom.getRandom().nextDouble(), 0.25) / 2.0).intValue();
            float rand = MyRandom.getRandom().nextFloat();
            if (rand > 0.85f) {
                T child = this.mutateObject(this.population.get(randomIndex));
                if (child == null) continue;
                this.population.add(child);
                continue;
            }
            if (rand > 0.7f) {
                int secondIndex = randomIndex;
                while (secondIndex != randomIndex) {
                    secondIndex = Double.valueOf((double)prunedSize * Math.pow(MyRandom.getRandom().nextDouble(), 0.25) / 2.0).intValue();
                }
                T child = this.createChild(this.population.get(randomIndex), this.population.get(secondIndex));
                if (child == null) continue;
                this.population.add(child);
                continue;
            }
            this.population.add(this.expandPool());
        }
    }

    protected abstract T mutateObject(T var1);

    protected abstract T createChild(T var1, T var2);

    public void run() {
        while (true) {
            this.evaluateFitness();
            this.pruneWeakest();
            ++this.generationCount;
            if (!this.shouldContinue()) break;
            this.generateChildren();
        }
    }

    public List<T> listFinalPopulation() {
        this.pruneWeakest();
        return this.population;
    }

    protected abstract boolean shouldContinue();
}

