/*
 * Decompiled with CFR 0.152.
 */
package forge.trackable;

import forge.trackable.TrackableCollection;
import forge.trackable.TrackableIndex;
import forge.trackable.TrackableObject;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

public class TrackableSerializer {
    public static final char DELIMITER = '\u0005';
    private final BufferedWriter bw;

    public TrackableSerializer(String filename) throws IOException {
        this.bw = new BufferedWriter(new FileWriter(filename));
    }

    public void write(String value) {
        try {
            this.bw.write(value + '\u0005');
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void write(boolean value) {
        this.write(value ? "1" : "0");
    }

    public void write(int value) {
        this.write(Integer.toString(value));
    }

    public void write(byte value) {
        this.write(Byte.toString(value));
    }

    public void write(long value) {
        this.write(Long.toString(value));
    }

    public void write(float value) {
        this.write(Float.toString(value));
    }

    public void write(double value) {
        this.write(Double.toString(value));
    }

    public void write(TrackableIndex<? extends TrackableObject> index) {
        this.write(index.size());
        for (TrackableObject o : index.values()) {
            o.serialize(this);
        }
    }

    public void write(TrackableCollection<? extends TrackableObject> collection) {
        this.write(collection.size());
        for (TrackableObject trackableObject : collection) {
            this.write(trackableObject.getId());
        }
    }
}

