/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox.special;

import com.google.common.base.Function;
import forge.game.player.PlayerView;
import forge.localinstance.skin.FSkinProp;
import forge.toolbox.FLabel;
import forge.toolbox.FMouseAdapter;
import forge.toolbox.FSkin;
import forge.trackable.TrackableProperty;
import forge.util.Localizer;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class PlayerDetailsPanel
extends JPanel {
    private static final long serialVersionUID = -6531759554646891983L;
    private final PlayerView player;
    private final DetailLabel lblHand = new DetailLabel(FSkinProp.IMG_ZONE_HAND, Localizer.getInstance().getMessage("lblHandNOfMax", "%s", "%s"));
    private final DetailLabel lblGraveyard = new DetailLabel(FSkinProp.IMG_ZONE_GRAVEYARD, Localizer.getInstance().getMessage("lblGraveyardNCardsNTypes", "%s", "%s"));
    private final DetailLabel lblLibrary = new DetailLabel(FSkinProp.IMG_ZONE_LIBRARY, Localizer.getInstance().getMessage("lblLibraryNCards", "%s"));
    private final DetailLabel lblExile = new DetailLabel(FSkinProp.IMG_ZONE_EXILE, Localizer.getInstance().getMessage("lblExileNCards", "%s"));
    private final DetailLabel lblFlashback = new DetailLabel(FSkinProp.IMG_ZONE_FLASHBACK, Localizer.getInstance().getMessage("lblFlashbackNCards", "%s"));
    private final DetailLabel lblCommand = new DetailLabel(FSkinProp.IMG_PLANESWALKER, Localizer.getInstance().getMessage("lblCommandZoneNCards", "%s"));
    private final DetailLabel lblAnte = new DetailLabel(FSkinProp.IMG_ZONE_ANTE, Localizer.getInstance().getMessage("lblAnteZoneNCards", "%s"));
    private final DetailLabel lblSideboard = new DetailLabel(FSkinProp.IMG_ZONE_SIDEBOARD, Localizer.getInstance().getMessage("lblSideboardNCards", "%s"));
    private final List<Pair<DetailLabel, Byte>> manaLabels = new ArrayList<Pair<DetailLabel, Byte>>();

    public PlayerDetailsPanel(PlayerView player0) {
        this.player = player0;
        this.manaLabels.add(Pair.of(new DetailLabel(FSkinProp.IMG_MANA_W, Localizer.getInstance().getMessage("lblWhiteManaOfN", "%s")), (byte)1));
        this.manaLabels.add(Pair.of(new DetailLabel(FSkinProp.IMG_MANA_U, Localizer.getInstance().getMessage("lblBlueManaOfN", "%s")), (byte)2));
        this.manaLabels.add(Pair.of(new DetailLabel(FSkinProp.IMG_MANA_B, Localizer.getInstance().getMessage("lblBlackManaOfN", "%s")), (byte)4));
        this.manaLabels.add(Pair.of(new DetailLabel(FSkinProp.IMG_MANA_R, Localizer.getInstance().getMessage("lblRedManaOfN", "%s")), (byte)8));
        this.manaLabels.add(Pair.of(new DetailLabel(FSkinProp.IMG_MANA_G, Localizer.getInstance().getMessage("lblGreenManaOfN", "%s")), (byte)16));
        this.manaLabels.add(Pair.of(new DetailLabel(FSkinProp.IMG_MANA_COLORLESS, Localizer.getInstance().getMessage("lblColorlessManaOfN", "%s")), (byte)32));
        this.setOpaque(false);
        this.setLayout(new MigLayout("insets 0, gap 0, wrap"));
        this.populateDetails();
        this.updateZones();
        this.updateManaPool();
    }

    private void populateDetails() {
        FSkin.SkinnedPanel row1 = new FSkin.SkinnedPanel(new MigLayout("insets 0, gap 0"));
        FSkin.SkinnedPanel row2 = new FSkin.SkinnedPanel(new MigLayout("insets 0, gap 0"));
        FSkin.SkinnedPanel row3 = new FSkin.SkinnedPanel(new MigLayout("insets 0, gap 0"));
        FSkin.SkinnedPanel row4 = new FSkin.SkinnedPanel(new MigLayout("insets 0, gap 0"));
        FSkin.SkinnedPanel row5 = new FSkin.SkinnedPanel(new MigLayout("insets 0, gap 0"));
        FSkin.SkinnedPanel row6 = new FSkin.SkinnedPanel(new MigLayout("insets 0, gap 0"));
        FSkin.SkinnedPanel row7 = new FSkin.SkinnedPanel(new MigLayout("insets 0, gap 0"));
        row1.setBackground(FSkin.getColor(FSkin.Colors.CLR_ZEBRA));
        row2.setOpaque(false);
        row3.setBackground(FSkin.getColor(FSkin.Colors.CLR_ZEBRA));
        row4.setOpaque(false);
        row5.setBackground(FSkin.getColor(FSkin.Colors.CLR_ZEBRA));
        row6.setOpaque(false);
        row7.setBackground(FSkin.getColor(FSkin.Colors.CLR_ZEBRA));
        String constraintsCell = "w 50%-4px!, h 100%!, gapleft 2px, gapright 2px";
        row1.add((Component)this.lblHand, "w 50%-4px!, h 100%!, gapleft 2px, gapright 2px");
        row1.add((Component)this.lblLibrary, "w 50%-4px!, h 100%!, gapleft 2px, gapright 2px");
        row2.add((Component)this.lblGraveyard, "w 50%-4px!, h 100%!, gapleft 2px, gapright 2px");
        row2.add((Component)this.lblExile, "w 50%-4px!, h 100%!, gapleft 2px, gapright 2px");
        row3.add((Component)this.lblFlashback, "w 50%-4px!, h 100%!, gapleft 2px, gapright 2px");
        row3.add((Component)this.lblCommand, "w 50%-4px!, h 100%!, gapleft 2px, gapright 2px");
        row4.add((Component)this.lblAnte, "w 50%-4px!, h 100%!, gapleft 2px, gapright 2px");
        row4.add((Component)this.lblSideboard, "w 50%-4px!, h 100%!, gapleft 2px, gapright 2px");
        row5.add((Component)this.manaLabels.get(0).getLeft(), "w 50%-4px!, h 100%!, gapleft 2px, gapright 2px");
        row5.add((Component)this.manaLabels.get(1).getLeft(), "w 50%-4px!, h 100%!, gapleft 2px, gapright 2px");
        row6.add((Component)this.manaLabels.get(2).getLeft(), "w 50%-4px!, h 100%!, gapleft 2px, gapright 2px");
        row6.add((Component)this.manaLabels.get(3).getLeft(), "w 50%-4px!, h 100%!, gapleft 2px, gapright 2px");
        row7.add((Component)this.manaLabels.get(4).getLeft(), "w 50%-4px!, h 100%!, gapleft 2px, gapright 2px");
        row7.add((Component)this.manaLabels.get(5).getLeft(), "w 50%-4px!, h 100%!, gapleft 2px, gapright 2px");
        String constraintsRow = "w 100%!, h 14%!";
        this.add((Component)row1, "w 100%!, h 14%!, gap 0 0 2% 0");
        this.add((Component)row2, "w 100%!, h 14%!");
        this.add((Component)row3, "w 100%!, h 14%!");
        this.add((Component)row4, "w 100%!, h 14%!");
        this.add((Component)row5, "w 100%!, h 14%!");
        this.add((Component)row6, "w 100%!, h 14%!");
        this.add((Component)row7, "w 100%!, h 14%!");
    }

    public Component getLblLibrary() {
        return this.lblLibrary;
    }

    public void updateZones() {
        String handSize = String.valueOf(this.player.getHandSize());
        String graveyardSize = String.valueOf(this.player.getGraveyardSize());
        String deliriumCount = String.valueOf(this.player.getZoneTypes(TrackableProperty.Graveyard));
        String librarySize = String.valueOf(this.player.getLibrarySize());
        String flashbackSize = String.valueOf(this.player.getFlashbackSize());
        String exileSize = String.valueOf(this.player.getExileSize());
        String commandSize = String.valueOf(this.player.getCommandSize());
        String anteSize = String.valueOf(this.player.getAnteSize());
        String sideboardSize = String.valueOf(this.player.getSideboardSize());
        this.lblHand.setText(handSize);
        this.lblHand.setToolTip(handSize, this.player.getMaxHandString());
        this.lblGraveyard.setText(graveyardSize);
        this.lblGraveyard.setToolTip(graveyardSize, deliriumCount);
        this.lblLibrary.setText(librarySize);
        this.lblLibrary.setToolTip(librarySize);
        this.lblFlashback.setText(flashbackSize);
        this.lblFlashback.setToolTip(flashbackSize);
        this.lblExile.setText(exileSize);
        this.lblExile.setToolTip(exileSize);
        this.lblCommand.setText(commandSize);
        this.lblCommand.setToolTip(commandSize);
        this.lblAnte.setText(anteSize);
        this.lblAnte.setToolTip(anteSize);
        this.lblSideboard.setText(sideboardSize);
        this.lblSideboard.setToolTip(sideboardSize);
    }

    public void updateManaPool() {
        for (Pair<DetailLabel, Byte> label : this.manaLabels) {
            String mana = String.valueOf(this.player.getMana(label.getRight()));
            label.getKey().setText(mana);
            label.getKey().setToolTip(mana);
        }
    }

    public void setupMouseActions(final Runnable handAction, final Runnable libraryAction, final Runnable exileAction, final Runnable graveAction, final Runnable flashBackAction, final Runnable commandAction, final Runnable anteAction, final Runnable sideboardAction, final Function<Byte, Boolean> manaAction) {
        this.lblGraveyard.addMouseListener(new FMouseAdapter(){

            @Override
            public void onLeftClick(MouseEvent e) {
                graveAction.run();
            }
        });
        this.lblExile.addMouseListener(new FMouseAdapter(){

            @Override
            public void onLeftClick(MouseEvent e) {
                exileAction.run();
            }
        });
        this.lblLibrary.addMouseListener(new FMouseAdapter(){

            @Override
            public void onLeftClick(MouseEvent e) {
                libraryAction.run();
            }
        });
        this.lblHand.addMouseListener(new FMouseAdapter(){

            @Override
            public void onLeftClick(MouseEvent e) {
                handAction.run();
            }
        });
        this.lblFlashback.addMouseListener(new FMouseAdapter(){

            @Override
            public void onLeftClick(MouseEvent e) {
                flashBackAction.run();
            }
        });
        this.lblCommand.addMouseListener(new FMouseAdapter(){

            @Override
            public void onLeftClick(MouseEvent e) {
                commandAction.run();
            }
        });
        this.lblAnte.addMouseListener(new FMouseAdapter(){

            @Override
            public void onLeftClick(MouseEvent e) {
                anteAction.run();
            }
        });
        this.lblSideboard.addMouseListener(new FMouseAdapter(){

            @Override
            public void onLeftClick(MouseEvent e) {
                sideboardAction.run();
            }
        });
        for (final Pair<DetailLabel, Byte> labelPair : this.manaLabels) {
            labelPair.getLeft().addMouseListener(new FMouseAdapter(){

                @Override
                public void onLeftClick(MouseEvent e) {
                    Byte mana = (Byte)labelPair.getRight();
                    while (((Boolean)manaAction.apply(mana)).booleanValue() && e.isShiftDown()) {
                    }
                }
            });
        }
    }

    private class DetailLabel
    extends FLabel {
        private final String tooltip;

        private DetailLabel(FSkinProp icon, String tooltip) {
            super(new FLabel.Builder().icon(FSkin.getImage(icon)).opaque(false).fontSize(14).hoverable().fontStyle(1).iconInBackground().fontAlign(4));
            this.tooltip = tooltip;
            this.setFocusable(false);
        }

        @Override
        public void setText(String text0) {
            super.setText(text0);
            this.autoSizeFont();
        }

        public void setToolTip(String ... args) {
            super.setToolTipText(String.format(this.tooltip, args));
        }

        @Override
        protected void resetIcon() {
            super.resetIcon();
            this.autoSizeFont();
        }

        private void autoSizeFont() {
            String text = this.getText();
            if (StringUtils.isEmpty(text)) {
                return;
            }
            Graphics g2 = this.getGraphics();
            if (g2 == null) {
                return;
            }
            int max = this.getMaxTextWidth();
            FSkin.SkinFont font = null;
            for (int fontSize = 14; fontSize > 5 && (font = FSkin.getBoldFont(fontSize)).measureTextWidth(g2, text) > max; --fontSize) {
            }
            if (font != null) {
                this.setFont(font);
            }
        }
    }
}

