/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox.special;

import forge.toolbox.FSkin;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;

public class PhaseLabel
extends JLabel {
    private boolean enabled = true;
    private boolean active = false;
    private boolean hover = false;

    public PhaseLabel(String txt) {
        super(txt);
        this.setHorizontalTextPosition(0);
        this.setHorizontalAlignment(0);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PhaseLabel.this.enabled = !PhaseLabel.this.enabled;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                PhaseLabel.this.hover = true;
                PhaseLabel.this.repaintOnlyThisLabel();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PhaseLabel.this.hover = false;
                PhaseLabel.this.repaintOnlyThisLabel();
            }
        });
    }

    @Override
    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setActive(boolean b) {
        this.active = b;
        this.repaintOnlyThisLabel();
    }

    public boolean getActive() {
        return this.active;
    }

    public void repaintOnlyThisLabel() {
        Dimension d = this.getSize();
        this.repaint(0, 0, d.width, d.height);
    }

    @Override
    public void paintComponent(Graphics g2) {
        int w = this.getWidth();
        int h2 = this.getHeight();
        FSkin.SkinColor c = this.hover ? FSkin.getColor(FSkin.Colors.CLR_HOVER) : (this.active && this.enabled ? FSkin.getColor(FSkin.Colors.CLR_PHASE_ACTIVE_ENABLED) : (!this.active && this.enabled ? FSkin.getColor(FSkin.Colors.CLR_PHASE_INACTIVE_ENABLED) : (this.active && !this.enabled ? FSkin.getColor(FSkin.Colors.CLR_PHASE_ACTIVE_DISABLED) : FSkin.getColor(FSkin.Colors.CLR_PHASE_INACTIVE_DISABLED))));
        FSkin.setGraphicsColor(g2, c);
        g2.fillRoundRect(1, 1, w - 2, h2 - 2, 5, 5);
        super.paintComponent(g2);
    }
}

