/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox.special;

import forge.game.phase.PhaseType;
import forge.toolbox.special.PhaseLabel;
import forge.util.Localizer;
import java.awt.Component;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class PhaseIndicator
extends JPanel {
    private static final long serialVersionUID = -863730022835609252L;
    private PhaseLabel lblUpkeep = new PhaseLabel("UP");
    private PhaseLabel lblDraw = new PhaseLabel("DR");
    private PhaseLabel lblMain1 = new PhaseLabel("M1");
    private PhaseLabel lblBeginCombat = new PhaseLabel("BC");
    private PhaseLabel lblDeclareAttackers = new PhaseLabel("DA");
    private PhaseLabel lblDeclareBlockers = new PhaseLabel("DB");
    private PhaseLabel lblFirstStrike = new PhaseLabel("FS");
    private PhaseLabel lblCombatDamage = new PhaseLabel("CD");
    private PhaseLabel lblEndCombat = new PhaseLabel("EC");
    private PhaseLabel lblMain2 = new PhaseLabel("M2");
    private PhaseLabel lblEndTurn = new PhaseLabel("ET");
    private PhaseLabel lblCleanup = new PhaseLabel("CL");

    public PhaseIndicator() {
        this.setOpaque(false);
        this.setLayout(new MigLayout("insets 0 0 1% 0, gap 0, wrap"));
        this.populatePhase();
    }

    private void populatePhase() {
        Localizer localizer = Localizer.getInstance();
        String constraints = "w 94%!, h 7.2%, gaptop 1%, gapleft 3%";
        this.lblUpkeep.setToolTipText(localizer.getMessage("htmlPhaseUpkeepTooltip", new Object[0]));
        this.add((Component)this.lblUpkeep, "w 94%!, h 7.2%, gaptop 1%, gapleft 3%");
        this.lblDraw.setToolTipText(localizer.getMessage("htmlPhaseDrawTooltip", new Object[0]));
        this.add((Component)this.lblDraw, "w 94%!, h 7.2%, gaptop 1%, gapleft 3%");
        this.lblMain1.setToolTipText(localizer.getMessage("htmlPhaseMain1Tooltip", new Object[0]));
        this.add((Component)this.lblMain1, "w 94%!, h 7.2%, gaptop 1%, gapleft 3%");
        this.lblBeginCombat.setToolTipText(localizer.getMessage("htmlPhaseBeginCombatTooltip", new Object[0]));
        this.add((Component)this.lblBeginCombat, "w 94%!, h 7.2%, gaptop 1%, gapleft 3%");
        this.lblDeclareAttackers.setToolTipText(localizer.getMessage("htmlPhaseDeclareAttackersTooltip", new Object[0]));
        this.add((Component)this.lblDeclareAttackers, "w 94%!, h 7.2%, gaptop 1%, gapleft 3%");
        this.lblDeclareBlockers.setToolTipText(localizer.getMessage("htmlPhaseDeclareBlockersTooltip", new Object[0]));
        this.add((Component)this.lblDeclareBlockers, "w 94%!, h 7.2%, gaptop 1%, gapleft 3%");
        this.lblFirstStrike.setToolTipText(localizer.getMessage("htmlPhaseFirstStrikeDamageTooltip", new Object[0]));
        this.add((Component)this.lblFirstStrike, "w 94%!, h 7.2%, gaptop 1%, gapleft 3%");
        this.lblCombatDamage.setToolTipText(localizer.getMessage("htmlPhaseCombatDamageTooltip", new Object[0]));
        this.add((Component)this.lblCombatDamage, "w 94%!, h 7.2%, gaptop 1%, gapleft 3%");
        this.lblEndCombat.setToolTipText(localizer.getMessage("htmlPhaseEndCombatTooltip", new Object[0]));
        this.add((Component)this.lblEndCombat, "w 94%!, h 7.2%, gaptop 1%, gapleft 3%");
        this.lblMain2.setToolTipText(localizer.getMessage("htmlPhaseMain2Tooltip", new Object[0]));
        this.add((Component)this.lblMain2, "w 94%!, h 7.2%, gaptop 1%, gapleft 3%");
        this.lblEndTurn.setToolTipText(localizer.getMessage("htmlPhaseEndTurnTooltip", new Object[0]));
        this.add((Component)this.lblEndTurn, "w 94%!, h 7.2%, gaptop 1%, gapleft 3%");
        this.lblCleanup.setToolTipText(localizer.getMessage("htmlPhaseCleanupTooltip", new Object[0]));
        this.add((Component)this.lblCleanup, "w 94%!, h 7.2%, gaptop 1%, gapleft 3%");
    }

    public PhaseLabel getLabelFor(PhaseType s2) {
        switch (s2) {
            case UPKEEP: {
                return this.getLblUpkeep();
            }
            case DRAW: {
                return this.getLblDraw();
            }
            case MAIN1: {
                return this.getLblMain1();
            }
            case COMBAT_BEGIN: {
                return this.getLblBeginCombat();
            }
            case COMBAT_DECLARE_ATTACKERS: {
                return this.getLblDeclareAttackers();
            }
            case COMBAT_DECLARE_BLOCKERS: {
                return this.getLblDeclareBlockers();
            }
            case COMBAT_DAMAGE: {
                return this.getLblCombatDamage();
            }
            case COMBAT_FIRST_STRIKE_DAMAGE: {
                return this.getLblFirstStrike();
            }
            case COMBAT_END: {
                return this.getLblEndCombat();
            }
            case MAIN2: {
                return this.getLblMain2();
            }
            case END_OF_TURN: {
                return this.getLblEndTurn();
            }
            case CLEANUP: {
                return this.getLblCleanup();
            }
        }
        return null;
    }

    public void resetPhaseButtons() {
        this.getLblUpkeep().setActive(false);
        this.getLblDraw().setActive(false);
        this.getLblMain1().setActive(false);
        this.getLblBeginCombat().setActive(false);
        this.getLblDeclareAttackers().setActive(false);
        this.getLblDeclareBlockers().setActive(false);
        this.getLblFirstStrike().setActive(false);
        this.getLblCombatDamage().setActive(false);
        this.getLblEndCombat().setActive(false);
        this.getLblMain2().setActive(false);
        this.getLblEndTurn().setActive(false);
        this.getLblCleanup().setActive(false);
    }

    public PhaseLabel getLblUpkeep() {
        return this.lblUpkeep;
    }

    public PhaseLabel getLblDraw() {
        return this.lblDraw;
    }

    public PhaseLabel getLblMain1() {
        return this.lblMain1;
    }

    public PhaseLabel getLblBeginCombat() {
        return this.lblBeginCombat;
    }

    public PhaseLabel getLblDeclareAttackers() {
        return this.lblDeclareAttackers;
    }

    public PhaseLabel getLblDeclareBlockers() {
        return this.lblDeclareBlockers;
    }

    public PhaseLabel getLblCombatDamage() {
        return this.lblCombatDamage;
    }

    public PhaseLabel getLblFirstStrike() {
        return this.lblFirstStrike;
    }

    public PhaseLabel getLblEndCombat() {
        return this.lblEndCombat;
    }

    public PhaseLabel getLblMain2() {
        return this.lblMain2;
    }

    public PhaseLabel getLblEndTurn() {
        return this.lblEndTurn;
    }

    public PhaseLabel getLblCleanup() {
        return this.lblCleanup;
    }
}

