/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox.special;

import forge.StaticData;
import forge.game.card.Card;
import forge.game.card.CardView;
import forge.game.keyword.Keyword;
import forge.gui.SOverlayUtils;
import forge.item.PaperCard;
import forge.localinstance.skin.FSkinProp;
import forge.toolbox.FOverlay;
import forge.toolbox.FSkin;
import forge.toolbox.imaging.FImagePanel;
import forge.toolbox.imaging.FImageUtil;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.Timer;
import net.miginfocom.swing.MigLayout;

public enum CardZoomer {
    SINGLETON_INSTANCE;

    private final JPanel overlay = FOverlay.SINGLETON_INSTANCE.getPanel();
    private JPanel pnlMain;
    private FImagePanel imagePanel;
    private final FSkin.SkinnedLabel lblFlipcard = new FSkin.SkinnedLabel();
    private CardView.CardStateView thisCard;
    private boolean mayFlip;
    private boolean isInAltState;
    private boolean isSplitRotated = false;
    private boolean isButtonMode = false;
    private boolean isOpen = false;
    private long lastClosedTime;
    private Timer mouseWheelCoolDownTimer;
    private boolean isMouseWheelEnabled = false;

    private CardZoomer() {
        this.lblFlipcard.setIcon(FSkin.getIcon(FSkinProp.ICO_FLIPCARD));
        this.setMouseButtonListener();
        this.setMouseWheelListener();
        this.setKeyListeners();
    }

    public void setCard(CardView.CardStateView card, boolean mayFlip) {
        this.thisCard = card;
        this.mayFlip = mayFlip;
        this.isInAltState = card != null && card == card.getCard().getAlternateState();
    }

    private void setKeyListeners() {
        this.overlay.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!CardZoomer.this.isButtonMode && e.getKeyCode() == 27) {
                    CardZoomer.this.closeZoomer();
                }
                if (e.getKeyCode() == 17) {
                    CardZoomer.this.toggleCardImage();
                }
            }
        });
    }

    private void setMouseButtonListener() {
        this.overlay.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                CardZoomer.this.closeZoomer();
            }
        });
    }

    private void setMouseWheelListener() {
        this.overlay.addMouseWheelListener(e -> {
            if (!this.isButtonMode && this.isMouseWheelEnabled) {
                this.isMouseWheelEnabled = false;
                if (e.getWheelRotation() > 0) {
                    this.closeZoomer();
                } else {
                    this.toggleCardImage();
                    this.startMouseWheelCoolDownTimer(250);
                }
            }
        });
    }

    public void doMouseWheelZoom() {
        this.isButtonMode = false;
        this.displayCard();
        this.startMouseWheelCoolDownTimer(200);
    }

    public void doMouseButtonZoom() {
        if (this.isOpen || System.currentTimeMillis() - this.lastClosedTime < 250L) {
            return;
        }
        this.isButtonMode = true;
        this.displayCard();
    }

    public boolean isZoomerOpen() {
        return this.isOpen;
    }

    private void displayCard() {
        if (this.thisCard == null) {
            return;
        }
        this.isMouseWheelEnabled = false;
        this.setLayout();
        this.setImage();
        SOverlayUtils.showOverlay();
        this.isOpen = true;
    }

    private void setFlipIndicator() {
        if (this.thisCard != null && this.mayFlip) {
            this.imagePanel.setLayout(new MigLayout("insets 0, w 100%!, h 100%!"));
            this.imagePanel.add((Component)this.lblFlipcard, "pos (100% - 100px) 0");
        }
    }

    private void setImage() {
        this.imagePanel = new FImagePanel();
        BufferedImage xlhqImage = FImageUtil.getImageXlhq(this.thisCard);
        this.imagePanel.setImage(xlhqImage == null ? FImageUtil.getImage(this.thisCard) : xlhqImage, this.getInitialRotation(), FImagePanel.AutoSizeImageMode.SOURCE);
        this.pnlMain.removeAll();
        this.pnlMain.add((Component)this.imagePanel, "w 80%!, h 80%!");
        this.pnlMain.validate();
        this.setFlipIndicator();
    }

    private int getInitialRotation() {
        if (this.thisCard == null) {
            return 0;
        }
        if (this.thisCard.getCard().isSplitCard()) {
            PaperCard pc;
            boolean isAftermath;
            String cardName = this.thisCard.getCard().getName();
            if (cardName.isEmpty()) {
                cardName = this.thisCard.getCard().getAlternateState().getName();
            }
            boolean bl = isAftermath = (pc = StaticData.instance().getCommonCards().getCard(cardName)) != null && Card.getCardForUi(pc).hasKeyword(Keyword.AFTERMATH);
            return this.thisCard.getCard().isFaceDown() || this.isSplitRotated ? 0 : (isAftermath ? 270 : 90);
        }
        return this.thisCard.getType().isPlane() || this.thisCard.getType().isPhenomenon() ? 90 : 0;
    }

    private void setLayout() {
        this.overlay.removeAll();
        this.pnlMain = new JPanel();
        this.pnlMain.setOpaque(false);
        this.overlay.setLayout(new MigLayout("insets 0, w 100%!, h 100%!"));
        this.pnlMain.setLayout(new MigLayout("insets 0, wrap, ax center, ay center"));
        this.overlay.add((Component)this.pnlMain, "w 100%!, h 100%!");
    }

    public void closeZoomer() {
        if (!this.isOpen) {
            return;
        }
        this.stopMouseWheelCoolDownTimer();
        this.isOpen = false;
        SOverlayUtils.hideOverlay();
        this.lastClosedTime = System.currentTimeMillis();
    }

    private void startMouseWheelCoolDownTimer(int millisecsDelay) {
        this.isMouseWheelEnabled = false;
        this.createMouseWheelCoolDownTimer(millisecsDelay);
        this.mouseWheelCoolDownTimer.setInitialDelay(millisecsDelay);
        this.mouseWheelCoolDownTimer.restart();
    }

    private void createMouseWheelCoolDownTimer(int millisecsDelay) {
        if (this.mouseWheelCoolDownTimer == null) {
            this.mouseWheelCoolDownTimer = new Timer(millisecsDelay, e -> {
                this.isMouseWheelEnabled = true;
            });
        }
    }

    private void stopMouseWheelCoolDownTimer() {
        if (this.mouseWheelCoolDownTimer != null && this.mouseWheelCoolDownTimer.isRunning()) {
            this.mouseWheelCoolDownTimer.stop();
        }
    }

    private void toggleCardImage() {
        if (this.thisCard != null) {
            if (this.mayFlip) {
                this.toggleFlipCard();
            } else if (this.thisCard.getCard().isSplitCard()) {
                this.toggleSplitCardRotation();
            }
        }
    }

    private void toggleFlipCard() {
        try {
            this.isInAltState = !this.isInAltState;
            this.thisCard = this.thisCard.getCard().getState(this.isInAltState);
            this.imagePanel.setRotation(this.thisCard.getCard().isFlipCard() && this.isInAltState ? 180 : 0);
            this.setImage();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void toggleSplitCardRotation() {
        this.isSplitRotated = !this.isSplitRotated;
        this.setImage();
    }
}

