/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox.imaging;

import forge.ImageCache;
import forge.ImageKeys;
import forge.game.card.CardView;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.toolbox.CardFaceSymbols;
import forge.toolbox.FSkin;
import forge.util.ImageUtil;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import javax.imageio.ImageIO;

public final class FImageUtil {
    private FImageUtil() {
    }

    public static BufferedImage getImage(CardView.CardStateView card) {
        BufferedImage image = ImageCache.getOriginalImage(card.getImageKey(), true, card.getCard());
        int foilIndex = card.getFoilIndex();
        if (image != null && foilIndex > 0) {
            image = FImageUtil.getImageWithFoilEffect(image, foilIndex);
        }
        return image;
    }

    public static BufferedImage getImageXlhq(CardView.CardStateView state) {
        String key = state.getImageKey();
        if (key.isEmpty() || key.length() < 3) {
            return null;
        }
        String prefix = key.substring(0, 2);
        if (!prefix.equals("c:") && !prefix.equals("t:")) {
            return null;
        }
        boolean altState = key.endsWith("$alt");
        String specColor = "";
        if (key.endsWith("$wspec")) {
            specColor = "white";
        } else if (key.endsWith("$uspec")) {
            specColor = "blue";
        } else if (key.endsWith("$bspec")) {
            specColor = "black";
        } else if (key.endsWith("$rspec")) {
            specColor = "red";
        } else if (key.endsWith("$gspec")) {
            specColor = "green";
        }
        String imageKey = key;
        if (prefix.equals("c:")) {
            PaperCard card = ImageUtil.getPaperCardFromImageKey(key);
            if (altState) {
                imageKey = card.getCardAltImageKey();
            } else if (!specColor.isEmpty()) {
                switch (specColor) {
                    case "white": {
                        imageKey = card.getCardWSpecImageKey();
                        break;
                    }
                    case "blue": {
                        imageKey = card.getCardUSpecImageKey();
                        break;
                    }
                    case "black": {
                        imageKey = card.getCardBSpecImageKey();
                        break;
                    }
                    case "red": {
                        imageKey = card.getCardRSpecImageKey();
                        break;
                    }
                    case "green": {
                        imageKey = card.getCardGSpecImageKey();
                    }
                }
            } else {
                imageKey = card.getCardImageKey();
            }
        }
        if (altState) {
            imageKey = imageKey.substring(0, imageKey.length() - "$alt".length());
            imageKey = imageKey + "full.jpg";
        } else if (!specColor.isEmpty()) {
            imageKey = imageKey.substring(0, imageKey.length() - "$wspec".length());
            imageKey = imageKey + "full.jpg";
        }
        File file = ImageKeys.getImageFile(imageKey);
        BufferedImage img = null;
        if (file != null) {
            Path path = file.toPath();
            String modPath = "";
            if (prefix.equals("c:")) {
                modPath = path.getRoot().toString() + path.subpath(0, path.getNameCount() - 2).toString() + File.separator + "XLHQ" + File.separator + path.subpath(path.getNameCount() - 2, path.getNameCount());
            } else if (prefix.equals("t:")) {
                modPath = path.getRoot().toString() + path.subpath(0, path.getNameCount() - 1).toString() + File.separator + "XLHQ" + File.separator + path.subpath(path.getNameCount() - 1, path.getNameCount());
            }
            File xlhqFile = new File(modPath.replace(".full.jpg", ".xlhq.jpg"));
            if (xlhqFile.exists()) {
                try {
                    img = ImageIO.read(xlhqFile);
                    int foilIndex = state.getFoilIndex();
                    if (img != null && foilIndex > 0) {
                        img = FImageUtil.getImageWithFoilEffect(img, foilIndex);
                    }
                    return img;
                }
                catch (IOException ex) {
                    System.err.println("IO exception caught when trying to open a XLHQ image: " + xlhqFile.getName());
                }
            }
        }
        return null;
    }

    private static BufferedImage getImageWithFoilEffect(BufferedImage plainImage, int foilIndex) {
        if (!FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_OVERLAY_FOIL_EFFECT)) {
            return plainImage;
        }
        ColorModel cm = plainImage.getColorModel();
        BufferedImage foilImage = new BufferedImage(cm, plainImage.copyData(plainImage.getRaster().createCompatibleWritableRaster()), cm.isAlphaPremultiplied(), null);
        String fl = String.format("foil%02d", foilIndex);
        CardFaceSymbols.drawOther(foilImage.getGraphics(), fl, 0, 0, foilImage.getWidth(), foilImage.getHeight());
        return foilImage;
    }

    public static FSkin.SkinIcon getMenuIcon(FSkin.SkinIcon sourceIcon) {
        return sourceIcon.resize(16, 16);
    }

    public static int getRotationToNearest(int requestedRotation, int nearestRotation) {
        requestedRotation -= 360 * (requestedRotation / 360);
        return (int)(Math.rint((double)requestedRotation / (double)nearestRotation) * (double)nearestRotation);
    }

    public static double getBestFitScale(int containedW, int containedH, int containerW, int containerH) {
        double scaleX = (double)containerW / (double)containedW;
        double scaleY = (double)containerH / (double)containedH;
        return Math.min(scaleX, scaleY);
    }

    public static double getBestFitScale(Dimension contained, Dimension container) {
        return FImageUtil.getBestFitScale(contained.width, contained.height, container.width, container.height);
    }
}

