/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox.imaging;

import com.mortennobel.imagescaling.DimensionConstrain;
import com.mortennobel.imagescaling.ResampleOp;
import forge.gui.GuiBase;
import forge.toolbox.imaging.FImageUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.Timer;

public class FImagePanel
extends JPanel {
    AutoSizeImageMode autoSizeMode = AutoSizeImageMode.PANEL;
    private BufferedImage sourceImage = null;
    private BufferedImage scaledImage = null;
    private boolean isResampleEnabled = true;
    private double imageScale = 1.0;
    private int degreesOfRotation = 0;
    private float alpha = 0.0f;
    private boolean isResizing = false;
    private Timer resizingTimer = this.createResizingTimer(100);

    public FImagePanel() {
        this.setOpaque(false);
        this.setResizeListener();
    }

    private Timer createResizingTimer(int timerDelay) {
        return new Timer(timerDelay, ev -> this.doResizedFinished());
    }

    private void doResizedFinished() {
        this.resizingTimer.stop();
        this.isResizing = false;
        this.isResampleEnabled = true;
        this.repaint();
    }

    private void setResizeListener() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                FImagePanel.this.isResizing = true;
                FImagePanel.this.resizingTimer.restart();
            }
        });
    }

    public void setImage(BufferedImage image, int initialRotation, AutoSizeImageMode autoSizeMode) {
        if (this.sourceImage != image || this.degreesOfRotation != initialRotation || this.autoSizeMode != autoSizeMode) {
            this.isResampleEnabled = true;
            this.autoSizeMode = autoSizeMode;
            if (initialRotation > 0) {
                this.setRotation(initialRotation);
            }
            this.sourceImage = image;
            this.repaint();
        }
    }

    public void setImage(BufferedImage image, AutoSizeImageMode autoSizeMode) {
        this.setImage(image, 0, autoSizeMode);
    }

    public void setImage(BufferedImage image, int initialRotation) {
        this.setImage(image, initialRotation, this.autoSizeMode);
    }

    public void setImage(BufferedImage image) {
        this.setImage(image, 0);
    }

    public void setDashedBorder(boolean showBorder) {
        this.setBorder(showBorder ? BorderFactory.createDashedBorder(null) : null);
    }

    public void setRotation(int degrees2) {
        if (this.degreesOfRotation != degrees2) {
            this.degreesOfRotation = FImageUtil.getRotationToNearest(degrees2, 90);
            this.isResampleEnabled = true;
            this.repaint();
        }
    }

    public int getRotation() {
        return this.degreesOfRotation;
    }

    private Dimension getSourceImageSize() {
        Dimension originalSize = new Dimension(this.sourceImage.getWidth(), this.sourceImage.getHeight());
        Dimension rotatedSize = new Dimension(this.sourceImage.getHeight(), this.sourceImage.getWidth());
        boolean isOriginalOrientation = this.degreesOfRotation % 180 == 0;
        return isOriginalOrientation ? originalSize : rotatedSize;
    }

    @Override
    protected void paintComponent(Graphics g2) {
        if (this.sourceImage != null) {
            this.setImageScale();
            if (this.isResizing) {
                this.doPerformancePaint(g2);
            } else {
                this.doQualityPaint(g2);
            }
        }
    }

    private void doQualityPaint(Graphics g2) {
        BufferedImage resampledImage = this.getResampledImage();
        if (resampledImage != null) {
            Graphics2D g2d = (Graphics2D)g2;
            if (this.alpha > 0.0f) {
                g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
            }
            g2d.drawImage(resampledImage, this.getAffineTransform(resampledImage, false), null);
        }
    }

    private BufferedImage getResampledImage() {
        if (this.imageScale != 1.0) {
            if (this.isResampleEnabled) {
                this.isResampleEnabled = false;
                DimensionConstrain constrain = DimensionConstrain.createRelativeDimension((float)this.imageScale);
                ResampleOp resampler = new ResampleOp(constrain);
                this.scaledImage = resampler.filter(this.sourceImage, null);
            }
        } else {
            this.scaledImage = this.sourceImage;
        }
        return this.scaledImage;
    }

    private void doPerformancePaint(Graphics g2) {
        Graphics2D g2d = (Graphics2D)g2;
        this.setRenderingHints(g2d);
        if (this.alpha > 0.0f) {
            g2d.setColor(new Color(92, 92, 92));
            g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
        }
        g2d.drawImage(this.sourceImage, this.getAffineTransform(this.sourceImage, true), null);
    }

    private void setRenderingHints(Graphics2D g2d) {
        if (!this.isResizing) {
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
    }

    private AffineTransform getAffineTransform(BufferedImage image, boolean createScaleTransform) {
        AffineTransform at = new AffineTransform();
        at.translate(this.getWidth() / 2, this.getHeight() / 2);
        at.rotate(Math.toRadians(this.degreesOfRotation));
        float screenScale = GuiBase.getInterface().getScreenScale();
        if (createScaleTransform) {
            at.scale(this.imageScale / (double)screenScale, this.imageScale / (double)screenScale);
        } else {
            at.scale(1.0f / screenScale, 1.0f / screenScale);
        }
        at.translate(-image.getWidth() / 2, -image.getHeight() / 2);
        return at;
    }

    public void setAutosizeMode(AutoSizeImageMode autoSizeMode) {
        this.autoSizeMode = autoSizeMode;
        this.repaint();
    }

    private void setImageScale() {
        if (this.sourceImage != null && this.autoSizeMode != AutoSizeImageMode.OFF) {
            double newScale = FImageUtil.getBestFitScale(this.getSourceImageSize(), this.getSize());
            if ((newScale *= (double)GuiBase.getInterface().getScreenScale()) != this.imageScale) {
                this.isResampleEnabled = true;
                this.imageScale = newScale;
                if (newScale == 0.0) {
                    this.imageScale = 1.0;
                }
                if (this.autoSizeMode == AutoSizeImageMode.SOURCE && newScale > 1.0) {
                    this.imageScale = 1.0;
                }
            }
        }
    }

    public void setAlpha(float alphaValue) {
        this.alpha = alphaValue;
    }

    public static enum AutoSizeImageMode {
        OFF,
        PANEL,
        SOURCE;

    }
}

