/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox.imaging;

import forge.card.CardRarity;
import forge.card.CardStateName;
import forge.card.mana.ManaCost;
import forge.game.card.CardView;
import forge.gui.GuiBase;
import forge.gui.card.CardDetailUtil;
import forge.localinstance.properties.ForgePreferences;
import forge.localinstance.skin.FSkinProp;
import forge.model.FModel;
import forge.toolbox.CardFaceSymbols;
import forge.toolbox.FSkin;
import forge.util.CardTranslation;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class FCardImageRenderer {
    private static boolean isInitialed = false;
    private static final float BASE_IMAGE_WIDTH = 488.0f;
    private static final float BASE_IMAGE_HEIGHT = 680.0f;
    private static final float NAME_BOX_TINT = 0.2f;
    private static final float TEXT_BOX_TINT = 0.1f;
    private static final float PT_BOX_TINT = 0.2f;
    private static float CARD_ART_RATIO;
    private static int PT_BOX_WIDTH;
    private static int HEADER_PADDING;
    private static int TYPE_PADDING;
    private static int BLACK_BORDER_THICKNESS;
    private static int BOX_LINE_THICKNESS;
    private static int ART_INSET;
    private static int OUTER_BORDER_THICKNESS;
    private static Font NAME_FONT;
    private static Font TYPE_FONT;
    private static Font TEXT_FONT;
    private static Font REMINDER_FONT;
    private static Font PT_FONT;
    private static Font ARTIST_FONT;
    private static int NAME_SIZE;
    private static int TYPE_SIZE;
    private static int TEXT_SIZE;
    private static int REMINDER_SIZE;
    private static int PT_SIZE;
    private static int ARTIST_SIZE;
    private static Map<Font, Font[]> cachedFonts;
    private static Color TEXT_COLOR;
    private static BreakIterator boundary;
    private static Pattern linebreakPattern;
    private static Pattern reminderPattern;
    private static Pattern reminderHidePattern;
    private static Pattern symbolPattern;
    private static final Color C_COMMON;
    private static final Color C_UNCOMMON;
    private static final Color C_RARE;
    private static final Color C_MYTHIC;
    private static final Color C_SPECIAL;

    private static void initialize() {
        Locale locale = new Locale(FModel.getPreferences().getPref(ForgePreferences.FPref.UI_LANGUAGE));
        boundary = BreakIterator.getLineInstance(locale);
        linebreakPattern = Pattern.compile("(\r\n\r\n)|(\n)");
        reminderPattern = Pattern.compile("\\((.+?)\\)");
        reminderHidePattern = Pattern.compile(" \\((.+?)\\)");
        symbolPattern = Pattern.compile("\\{([A-Z0-9]+)\\}|\\{([A-Z0-9]+)/([A-Z0-9]+)\\}");
        NAME_FONT = new Font("Serif", 1, 26);
        TYPE_FONT = new Font("Serif", 1, 22);
        if ("ja-JP".equals(FModel.getPreferences().getPref(ForgePreferences.FPref.UI_LANGUAGE)) || "zh-CN".equals(FModel.getPreferences().getPref(ForgePreferences.FPref.UI_LANGUAGE))) {
            TEXT_FONT = new Font("SansSerif", 0, 24);
            REMINDER_FONT = new Font("SansSerif", 0, 22);
        } else if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_CARD_IMAGE_RENDER_USE_SANS_SERIF_FONT)) {
            TEXT_FONT = new Font("SansSerif", 0, 24);
            REMINDER_FONT = new Font("SansSerif", 2, 24);
        } else {
            TEXT_FONT = new Font("Serif", 0, 24);
            REMINDER_FONT = new Font("Serif", 2, 24);
        }
        PT_FONT = NAME_FONT;
        ARTIST_FONT = new Font("Serif", 1, 20);
        float screenScale = GuiBase.getInterface().getScreenScale();
        int arrayMultiplier = Math.round(2.0f * screenScale);
        cachedFonts = new HashMap<Font, Font[]>();
        cachedFonts.put(NAME_FONT, new Font[NAME_FONT.getSize() * arrayMultiplier]);
        cachedFonts.put(TYPE_FONT, new Font[TYPE_FONT.getSize() * arrayMultiplier]);
        cachedFonts.put(TEXT_FONT, new Font[TEXT_FONT.getSize() * arrayMultiplier]);
        cachedFonts.put(REMINDER_FONT, new Font[REMINDER_FONT.getSize() * arrayMultiplier]);
        cachedFonts.put(ARTIST_FONT, new Font[ARTIST_FONT.getSize() * arrayMultiplier]);
        isInitialed = true;
    }

    private static Color tintColor(Color source, Color tint, float alpha) {
        float r = (float)(tint.getRed() - source.getRed()) * alpha + (float)source.getRed();
        float g2 = (float)(tint.getGreen() - source.getGreen()) * alpha + (float)source.getGreen();
        float b = (float)(tint.getBlue() - source.getBlue()) * alpha + (float)source.getBlue();
        return new Color(r / 255.0f, g2 / 255.0f, b / 255.0f, 1.0f);
    }

    private static Color[] tintColors(Color source, Color[] tints, float alpha) {
        Color[] tintedColors = new Color[tints.length];
        for (int i = 0; i < tints.length; ++i) {
            tintedColors[i] = FCardImageRenderer.tintColor(source, tints[i], alpha);
        }
        return tintedColors;
    }

    private static Color fromDetailColor(CardDetailUtil.DetailColors detailColor) {
        return new Color(detailColor.r, detailColor.g, detailColor.b);
    }

    private static Color getRarityColor(CardRarity rarity) {
        if (rarity == null) {
            return Color.MAGENTA;
        }
        switch (rarity) {
            case Uncommon: {
                return C_UNCOMMON;
            }
            case Rare: {
                return C_RARE;
            }
            case MythicRare: {
                return C_MYTHIC;
            }
            case Special: {
                return C_SPECIAL;
            }
        }
        return C_COMMON;
    }

    private static Font getFontBySize(Font orgFont, int newSize) {
        if (newSize == orgFont.getSize()) {
            return orgFont;
        }
        Font font = cachedFonts.get(orgFont)[newSize];
        if (font == null) {
            FCardImageRenderer.cachedFonts.get((Object)orgFont)[newSize] = font = orgFont.deriveFont((float)newSize);
        }
        return font;
    }

    private static void updateAreaSizes(float mainRatio, float subRatio) {
        NAME_SIZE = Math.round((float)NAME_FONT.getSize() * mainRatio);
        TYPE_SIZE = Math.round((float)TYPE_FONT.getSize() * subRatio);
        TEXT_SIZE = Math.round((float)TEXT_FONT.getSize() * mainRatio);
        REMINDER_SIZE = Math.round((float)REMINDER_FONT.getSize() * mainRatio);
        PT_SIZE = Math.round((float)PT_FONT.getSize() * mainRatio);
        ARTIST_SIZE = Math.round((float)ARTIST_FONT.getSize() * mainRatio);
        PT_BOX_WIDTH = Math.round(75.0f * mainRatio);
        HEADER_PADDING = Math.round(7.0f * mainRatio);
        TYPE_PADDING = Math.round(7.0f * subRatio) + (mainRatio == subRatio ? (NAME_SIZE - TYPE_SIZE) / 2 : 0);
        BOX_LINE_THICKNESS = Math.max(Math.round(2.0f * mainRatio), 1);
        BLACK_BORDER_THICKNESS = Math.round(10.0f * mainRatio);
        ART_INSET = Math.round((float)BLACK_BORDER_THICKNESS * 0.6f);
        OUTER_BORDER_THICKNESS = Math.round(1.2f * (float)BLACK_BORDER_THICKNESS) - ART_INSET;
    }

    public static void drawCardImage(Graphics2D g2, CardView card, boolean altState, int width, int height, BufferedImage art, String legalString) {
        boolean needTranslation;
        if (!isInitialed) {
            FCardImageRenderer.initialize();
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        float ratio = Math.min((float)width / 488.0f, (float)height / 680.0f);
        BLACK_BORDER_THICKNESS = Math.round(10.0f * ratio);
        g2.setColor(Color.BLACK);
        g2.fillRect(0, 0, width, height);
        if (legalString != null) {
            CardView.CardStateView state;
            TEXT_COLOR = Color.LIGHT_GRAY;
            int x = BLACK_BORDER_THICKNESS * 3;
            int y = height - BLACK_BORDER_THICKNESS * 3;
            int w = width;
            boolean hasPTBox = false;
            if (!card.isSplitCard() && !card.isFlipCard() && ((state = card.getState(card.isAdventureCard() ? false : altState)).isCreature() && !state.getKeywordKey().contains("Level up") || state.isPlaneswalker() || state.isBattle() || state.isVehicle())) {
                hasPTBox = true;
            }
            w = hasPTBox ? (w -= PT_BOX_WIDTH + BLACK_BORDER_THICKNESS * 5) : (w -= BLACK_BORDER_THICKNESS * 6);
            int h2 = BLACK_BORDER_THICKNESS * 3;
            FCardImageRenderer.drawVerticallyCenteredString(g2, legalString, new Rectangle(x, y, w, h2), ARTIST_FONT, ARTIST_SIZE);
        }
        width -= 2 * BLACK_BORDER_THICKNESS;
        height -= 2 * BLACK_BORDER_THICKNESS;
        g2.translate(BLACK_BORDER_THICKNESS, BLACK_BORDER_THICKNESS);
        TEXT_COLOR = Color.BLACK;
        if (card.isSplitCard()) {
            needTranslation = !"en-US".equals(FModel.getPreferences().getPref(ForgePreferences.FPref.UI_LANGUAGE));
            CardView.CardStateView leftState = card.getLeftSplitState();
            String leftText = needTranslation ? CardTranslation.getTranslatedOracle(leftState) : leftState.getOracleText();
            CardView.CardStateView rightState = card.getRightSplitState();
            String rightText = needTranslation ? CardTranslation.getTranslatedOracle(rightState) : rightState.getOracleText();
            boolean isAftermath = rightState.getKeywordKey().contains("Aftermath");
            BufferedImage leftArt = null;
            BufferedImage rightArt = null;
            if (isAftermath) {
                if (art != null) {
                    int leftWidth = Math.round((float)art.getWidth() * 0.61328125f);
                    leftArt = art.getSubimage(0, 0, leftWidth, art.getHeight());
                    rightArt = art.getSubimage(leftWidth, 0, art.getWidth() - leftWidth, art.getHeight());
                }
                int halfHeight = Math.round(370.0f * ratio);
                int halfWidth = Math.round(360.0f * ratio);
                CARD_ART_RATIO = 2.719f;
                FCardImageRenderer.updateAreaSizes(ratio, ratio);
                FCardImageRenderer.drawCardStateImage(g2, leftState, leftText, width, halfHeight, leftArt);
                CARD_ART_RATIO = 1.714f;
                int widthAdjust = OUTER_BORDER_THICKNESS;
                int heightAdjust = OUTER_BORDER_THICKNESS + PT_SIZE / 2;
                g2.translate((double)width - (double)widthAdjust, (double)halfWidth);
                g2.rotate(1.5707963267948966);
                FCardImageRenderer.drawCardStateImage(g2, rightState, rightText, height - halfWidth - heightAdjust, width, rightArt);
            } else {
                if (art != null) {
                    leftArt = art.getSubimage(0, 0, art.getWidth() / 2, art.getHeight());
                    rightArt = art.getSubimage(art.getWidth() / 2, 0, art.getWidth() / 2, art.getHeight());
                }
                CARD_ART_RATIO = 1.443f;
                FCardImageRenderer.updateAreaSizes(ratio, (float)height / 2.0f / (float)width * ratio);
                int widthAdjust = OUTER_BORDER_THICKNESS + PT_SIZE / 2;
                int heightAdjust = height - widthAdjust - BLACK_BORDER_THICKNESS;
                AffineTransform tf = g2.getTransform();
                g2.translate(0.0, (double)(height - widthAdjust));
                g2.rotate(-1.5707963267948966);
                FCardImageRenderer.drawCardStateImage(g2, leftState, leftText, heightAdjust / 2, width + widthAdjust, leftArt);
                g2.setTransform(tf);
                g2.translate(0.0, (double)(heightAdjust / 2));
                g2.rotate(-1.5707963267948966);
                FCardImageRenderer.drawCardStateImage(g2, rightState, rightText, heightAdjust / 2, width + widthAdjust, rightArt);
            }
        } else if (card.isFlipCard()) {
            needTranslation = !card.isToken() || card.getCloneOrigin() != null;
            CardView.CardStateView state = card.getState(false);
            String text = card.getText(state, needTranslation ? CardTranslation.getTranslationTexts(state) : null);
            CardView.CardStateView flipState = card.getState(true);
            String flipText = card.getText(flipState, needTranslation ? CardTranslation.getTranslationTexts(flipState) : null);
            CARD_ART_RATIO = 1.728f;
            FCardImageRenderer.updateAreaSizes(ratio, ratio);
            int heightAdjust = OUTER_BORDER_THICKNESS + PT_SIZE / 2;
            if (altState) {
                g2.translate(width, height);
                g2.rotate(Math.PI);
            }
            FCardImageRenderer.drawFlipCardImage(g2, state, text, flipState, flipText, width, height - heightAdjust, art);
        } else if (card.isAdventureCard()) {
            needTranslation = !card.isToken() || card.getCloneOrigin() != null;
            CardView.CardStateView state = card.getState(false);
            String text = card.getText(state, needTranslation ? CardTranslation.getTranslationTexts(state) : null);
            CardView.CardStateView advState = card.getState(true);
            String advText = card.getText(advState, needTranslation ? CardTranslation.getTranslationTexts(advState) : null);
            CARD_ART_RATIO = 1.37f;
            FCardImageRenderer.updateAreaSizes(ratio, ratio);
            FCardImageRenderer.drawAdvCardImage(g2, state, text, advState, advText, width, height, art);
        } else {
            needTranslation = !card.isToken() || card.getCloneOrigin() != null;
            CardView.CardStateView state = card.getState(altState);
            String text = card.getText(state, needTranslation ? CardTranslation.getTranslationTexts(state) : null);
            CARD_ART_RATIO = 1.37f;
            if (art != null && Math.abs((float)art.getWidth() / (float)art.getHeight() - CARD_ART_RATIO) > 0.1f) {
                CARD_ART_RATIO = (float)art.getWidth() / (float)art.getHeight();
            }
            FCardImageRenderer.updateAreaSizes(ratio, ratio);
            FCardImageRenderer.drawCardStateImage(g2, state, text, width, height, art);
        }
        g2.dispose();
    }

    private static void drawCardStateImage(Graphics2D g2, CardView.CardStateView state, String text, int w, int h2, BufferedImage art) {
        boolean isLevelup;
        int x = 0;
        int y = 0;
        List<CardDetailUtil.DetailColors> borderColors = CardDetailUtil.getBorderColors(state, true);
        Color[] colors = FCardImageRenderer.fillColorBackground(g2, borderColors, x, y, w, h2, BLACK_BORDER_THICKNESS);
        x += OUTER_BORDER_THICKNESS;
        y += OUTER_BORDER_THICKNESS;
        w -= 2 * OUTER_BORDER_THICKNESS;
        int headerHeight = NAME_SIZE + 2 * HEADER_PADDING;
        int typeBoxHeight = TYPE_SIZE + 2 * TYPE_PADDING;
        int ptBoxHeight = 0;
        if (state.isCreature() || state.isPlaneswalker() | state.isBattle() || state.isVehicle()) {
            ptBoxHeight = headerHeight;
        }
        int artWidth = w - 2 * ART_INSET;
        int artHeight = Math.round((float)artWidth / CARD_ART_RATIO);
        int textBoxHeight = h2 - headerHeight - artHeight - typeBoxHeight - OUTER_BORDER_THICKNESS - ART_INSET - PT_SIZE / 2;
        int artY = y + headerHeight;
        int typeY = artY + artHeight;
        int textY = typeY + typeBoxHeight;
        int ptY = textY + textBoxHeight;
        boolean isSaga = state.getType().hasSubtype("Saga");
        boolean isClass = state.getType().hasSubtype("Class") || state.getType().hasSubtype("Case");
        boolean isDungeon = state.getType().isDungeon();
        if (isSaga || isClass || isDungeon) {
            typeY = ptY - Math.round((float)typeBoxHeight * 1.2f);
            if (!isDungeon) {
                artWidth /= 2;
            }
            textBoxHeight = artHeight = typeY - artY;
            textY = artY;
        }
        if (!isDungeon) {
            Color[] artBoxColors = FCardImageRenderer.tintColors(Color.DARK_GRAY, colors, 0.2f);
            int artX = x + ART_INSET + (isSaga ? artWidth : 0);
            FCardImageRenderer.drawArt(g2, artBoxColors, artX, artY, artWidth, artHeight, art);
        }
        if (isLevelup = state.getKeywordKey().contains("Level up")) {
            int textBoxHeightDiv3 = Math.round((float)textBoxHeight / 3.0f);
            String[] paragraphs = linebreakPattern.split(text);
            StringBuilder sb = new StringBuilder();
            String text1 = "";
            String text2 = "";
            String text3 = "";
            String level2 = "";
            String level3 = "";
            String ptOverride2 = null;
            String ptOverride3 = null;
            for (String pg : paragraphs) {
                if (pg.matches("(.*[0-9]+-[0-9]+)|(.*[0-9]+\\+)")) {
                    pg = pg.replaceAll("([^0-9 ]+)(([0-9]+-[0-9]+)|([0-9]+\\+))", "$1 $2");
                    if (level2.isEmpty()) {
                        text1 = sb.toString();
                        level2 = pg;
                    } else {
                        text2 = sb.toString();
                        level3 = pg;
                    }
                    sb.setLength(0);
                    continue;
                }
                if (pg.matches("[0-9]+/[0-9]+")) {
                    if (ptOverride2 == null) {
                        ptOverride2 = pg;
                        continue;
                    }
                    ptOverride3 = pg;
                    continue;
                }
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(pg);
            }
            text3 = sb.toString();
            if (ptOverride2 == null) {
                for (String pg : paragraphs = linebreakPattern.split(state.getOracleText())) {
                    if (!pg.matches("[0-9]+/[0-9]+")) continue;
                    if (ptOverride2 == null) {
                        ptOverride2 = pg;
                        continue;
                    }
                    ptOverride3 = pg;
                }
            }
            int textX = x + ART_INSET;
            Color[] textBox1Colors = FCardImageRenderer.tintColors(Color.WHITE, colors, 0.1f);
            FCardImageRenderer.drawTextBox(g2, state, text1, textBox1Colors, textX, textY, artWidth, textBoxHeightDiv3, 2);
            Color[] pt1Colors = FCardImageRenderer.tintColors(Color.WHITE, colors, 0.2f);
            ptY = textY + (textBoxHeightDiv3 - ptBoxHeight) / 2;
            FCardImageRenderer.drawPTBox(g2, state, null, pt1Colors, x, ptY, w, ptBoxHeight);
            textY += textBoxHeightDiv3;
            ptY += textBoxHeightDiv3;
            int orgTextSize = TEXT_SIZE;
            int levelBoxWitdh = PT_BOX_WIDTH * 3 / 4;
            Color lighterGray = new Color(224, 224, 224);
            Color[] textBox2Colors = FCardImageRenderer.tintColors(lighterGray, colors, 0.25f);
            TEXT_SIZE = orgTextSize - 10;
            FCardImageRenderer.drawTextBox(g2, state, level2, textBox2Colors, textX, textY, levelBoxWitdh, textBoxHeightDiv3, 4);
            TEXT_SIZE = orgTextSize;
            FCardImageRenderer.drawTextBox(g2, state, text2, textBox2Colors, textX + levelBoxWitdh, textY, artWidth - levelBoxWitdh, textBoxHeightDiv3, 2);
            Color[] pt2Colors = FCardImageRenderer.tintColors(lighterGray, colors, 0.35000002f);
            FCardImageRenderer.drawPTBox(g2, state, ptOverride2, pt2Colors, x, ptY, w, ptBoxHeight);
            textY += textBoxHeightDiv3;
            ptY += textBoxHeightDiv3;
            textBoxHeightDiv3 = textBoxHeight - textBoxHeightDiv3 * 2;
            Color lightGray = new Color(160, 160, 160);
            Color[] textBox3Colors = FCardImageRenderer.tintColors(lightGray, colors, 0.4f);
            TEXT_SIZE = orgTextSize - 10;
            FCardImageRenderer.drawTextBox(g2, state, level3, textBox3Colors, textX, textY, levelBoxWitdh, textBoxHeightDiv3, 4);
            TEXT_SIZE = orgTextSize;
            FCardImageRenderer.drawTextBox(g2, state, text3, textBox3Colors, textX + levelBoxWitdh, textY, artWidth - levelBoxWitdh, textBoxHeightDiv3, 2);
            Color[] pt3Colors = FCardImageRenderer.tintColors(lightGray, colors, 0.5f);
            FCardImageRenderer.drawPTBox(g2, state, ptOverride3, pt3Colors, x, ptY, w, ptBoxHeight);
        } else {
            Color[] textBoxColors = FCardImageRenderer.tintColors(Color.WHITE, colors, 0.1f);
            int textX = x + ART_INSET + (isClass ? artWidth : 0);
            FCardImageRenderer.drawTextBox(g2, state, text, textBoxColors, textX, textY, artWidth, textBoxHeight, ptBoxHeight > 0 ? 1 : 0);
            if (ptBoxHeight > 0) {
                Color[] ptColors = FCardImageRenderer.tintColors(Color.WHITE, colors, 0.2f);
                FCardImageRenderer.drawPTBox(g2, state, null, ptColors, x, ptY -= ptBoxHeight / 2, w, ptBoxHeight);
            }
        }
        Color[] headerColors = FCardImageRenderer.tintColors(Color.WHITE, colors, 0.2f);
        FCardImageRenderer.drawHeader(g2, state, headerColors, x, y, w, headerHeight, true, true);
        FCardImageRenderer.drawTypeLine(g2, state, headerColors, x, typeY, w, typeBoxHeight, 0, true, true);
    }

    private static void drawFlipCardImage(Graphics2D g2, CardView.CardStateView state, String text, CardView.CardStateView flipState, String flipText, int w, int h2, BufferedImage art) {
        Color[] ptColors;
        int width = w;
        int height = h2;
        int x = 0;
        int y = 0;
        List<CardDetailUtil.DetailColors> borderColors = CardDetailUtil.getBorderColors(state, true);
        Color[] colors = FCardImageRenderer.fillColorBackground(g2, borderColors, x, y, w, h2, 0);
        x += OUTER_BORDER_THICKNESS;
        y += OUTER_BORDER_THICKNESS;
        int headerHeight = NAME_SIZE + 2 * HEADER_PADDING;
        int typeBoxHeight = TYPE_SIZE + 2 * TYPE_PADDING;
        int artWidth = (w -= 2 * OUTER_BORDER_THICKNESS) - 2 * ART_INSET;
        int artHeight = Math.round((float)artWidth / CARD_ART_RATIO);
        int textBoxHeight = ((h2 -= 2 * OUTER_BORDER_THICKNESS) - (headerHeight + typeBoxHeight) * 2 - artHeight) / 2;
        int ptBoxHeight = headerHeight;
        int textY = y + headerHeight;
        int typeY = textY + textBoxHeight;
        int artY = typeY + typeBoxHeight;
        int ptY = typeY + 1;
        Color[] artBoxColors = FCardImageRenderer.tintColors(Color.DARK_GRAY, colors, 0.2f);
        int artX = x + ART_INSET;
        FCardImageRenderer.drawArt(g2, artBoxColors, artX, artY, artWidth, artHeight, art);
        Color[] textBoxColors = FCardImageRenderer.tintColors(Color.WHITE, colors, 0.1f);
        int textX = x + ART_INSET;
        FCardImageRenderer.drawTextBox(g2, state, text, textBoxColors, textX, textY, artWidth, textBoxHeight, 0);
        Color[] headerColors = FCardImageRenderer.tintColors(Color.WHITE, colors, 0.2f);
        FCardImageRenderer.drawHeader(g2, state, headerColors, x, y, w, headerHeight, true, true);
        FCardImageRenderer.drawTypeLine(g2, state, headerColors, x, typeY, w, typeBoxHeight, state.isCreature() ? PT_BOX_WIDTH : 0, true, true);
        if (state.isCreature()) {
            ptColors = FCardImageRenderer.tintColors(Color.WHITE, colors, 0.2f);
            FCardImageRenderer.drawPTBox(g2, state, null, ptColors, x, ptY, w, ptBoxHeight);
        }
        g2.translate(width, height);
        g2.rotate(Math.PI);
        FCardImageRenderer.drawTextBox(g2, flipState, flipText, textBoxColors, textX, textY, artWidth, textBoxHeight, 0);
        FCardImageRenderer.drawHeader(g2, flipState, headerColors, x, y, w, headerHeight, false, true);
        FCardImageRenderer.drawTypeLine(g2, flipState, headerColors, x, typeY, w, typeBoxHeight, flipState.isCreature() ? PT_BOX_WIDTH : 0, false, true);
        if (flipState.isCreature()) {
            ptColors = FCardImageRenderer.tintColors(Color.WHITE, colors, 0.2f);
            FCardImageRenderer.drawPTBox(g2, flipState, null, ptColors, x, ptY, w, ptBoxHeight);
        }
    }

    private static void drawAdvCardImage(Graphics2D g2, CardView.CardStateView state, String text, CardView.CardStateView advState, String advText, int w, int h2, BufferedImage art) {
        int x = 0;
        int y = 0;
        List<CardDetailUtil.DetailColors> borderColors = CardDetailUtil.getBorderColors(state, true);
        Color[] colors = FCardImageRenderer.fillColorBackground(g2, borderColors, x, y, w, h2, BLACK_BORDER_THICKNESS);
        x += OUTER_BORDER_THICKNESS;
        y += OUTER_BORDER_THICKNESS;
        int headerHeight = NAME_SIZE + 2 * HEADER_PADDING;
        int typeBoxHeight = TYPE_SIZE + 2 * TYPE_PADDING;
        int ptBoxHeight = headerHeight;
        int artWidth = (w -= 2 * OUTER_BORDER_THICKNESS) - 2 * ART_INSET;
        int artHeight = Math.round((float)artWidth / CARD_ART_RATIO);
        int textBoxWidth = artWidth / 2;
        int textBoxHeight = h2 - headerHeight - artHeight - typeBoxHeight - OUTER_BORDER_THICKNESS - ART_INSET - PT_SIZE / 2;
        int artY = y + headerHeight;
        int typeY = artY + artHeight;
        int textY = typeY + typeBoxHeight;
        int ptY = textY + textBoxHeight;
        Color[] artBoxColors = FCardImageRenderer.tintColors(Color.DARK_GRAY, colors, 0.2f);
        int artX = x + ART_INSET;
        FCardImageRenderer.drawArt(g2, artBoxColors, artX, artY, artWidth, artHeight, art);
        Color[] textBoxColors = FCardImageRenderer.tintColors(Color.WHITE, colors, 0.1f);
        int textX = x + ART_INSET + textBoxWidth;
        FCardImageRenderer.drawTextBox(g2, state, text, textBoxColors, textX, textY, textBoxWidth, textBoxHeight, 1);
        Color[] headerColors = FCardImageRenderer.tintColors(Color.WHITE, colors, 0.2f);
        FCardImageRenderer.drawHeader(g2, state, headerColors, x, y, w, headerHeight, true, true);
        FCardImageRenderer.drawTypeLine(g2, state, headerColors, x, typeY, w, typeBoxHeight, 0, true, true);
        Color[] ptColors = FCardImageRenderer.tintColors(Color.WHITE, colors, 0.2f);
        FCardImageRenderer.drawPTBox(g2, state, null, ptColors, x, ptY - ptBoxHeight / 2, w, ptBoxHeight);
        int advHeaderHeight = typeBoxHeight - 2;
        int advTypeHeight = advHeaderHeight - 1;
        NAME_SIZE = TYPE_SIZE - 2;
        TYPE_SIZE = NAME_SIZE - 1;
        textX = x + ART_INSET;
        colors = FCardImageRenderer.fillColorBackground(g2, CardDetailUtil.getBorderColors(advState, true), 0, 0, 0, 0, BLACK_BORDER_THICKNESS);
        textBoxColors = FCardImageRenderer.tintColors(Color.WHITE, colors, 0.1f);
        Color[] advheaderColors = FCardImageRenderer.tintColors(Color.GRAY, colors, 0.6f);
        TEXT_COLOR = Color.WHITE;
        FCardImageRenderer.drawHeader(g2, advState, advheaderColors, textX, textY, textBoxWidth, advHeaderHeight, true, false);
        Color[] advTypeColors = FCardImageRenderer.tintColors(Color.DARK_GRAY, colors, 0.6f);
        FCardImageRenderer.drawTypeLine(g2, advState, advTypeColors, textX, textY + advHeaderHeight, textBoxWidth, advTypeHeight, 0, false, false);
        TEXT_COLOR = Color.BLACK;
        int yAdjust = advHeaderHeight + advTypeHeight;
        FCardImageRenderer.drawTextBox(g2, advState, advText, textBoxColors, textX, textY, textBoxWidth, textBoxHeight, yAdjust << 16);
    }

    private static Color[] fillColorBackground(Graphics2D g2, List<CardDetailUtil.DetailColors> backColors, int x, int y, int w, int h2, int borderThickness) {
        Color[] colors = new Color[backColors.size()];
        for (int i = 0; i < colors.length; ++i) {
            CardDetailUtil.DetailColors dc = backColors.get(i);
            colors[i] = new Color(dc.r, dc.g, dc.b);
        }
        FCardImageRenderer.fillRoundColorBackground(g2, colors, x, y, w, h2 - 2 * borderThickness, borderThickness * 12, borderThickness * 10);
        FCardImageRenderer.fillColorBackground(g2, colors, x, y, w, 10 * borderThickness);
        return colors;
    }

    private static void fillColorBackground(Graphics2D g2, Color[] colors, float x, float y, float w, float h2) {
        Paint oldPaint = g2.getPaint();
        switch (colors.length) {
            case 1: {
                g2.setColor(colors[0]);
                g2.fillRect(Math.round(x), Math.round(y), Math.round(w), Math.round(h2));
                break;
            }
            case 2: {
                GradientPaint gradient = new GradientPaint(x, y, colors[0], x + w, y, colors[1]);
                g2.setPaint(gradient);
                g2.fillRect(Math.round(x), Math.round(y), Math.round(w), Math.round(h2));
                break;
            }
            case 3: {
                float halfWidth = w / 2.0f;
                GradientPaint gradient1 = new GradientPaint(x, y, colors[0], x + halfWidth, y, colors[1]);
                g2.setPaint(gradient1);
                g2.fillRect(Math.round(x), Math.round(y), Math.round(halfWidth), Math.round(h2));
                GradientPaint gradient2 = new GradientPaint(x + halfWidth, y, colors[1], x + w, y, colors[2]);
                g2.setPaint(gradient2);
                g2.fillRect(Math.round(x + halfWidth), Math.round(y), Math.round(halfWidth), Math.round(h2));
            }
        }
        g2.setPaint(oldPaint);
    }

    private static void fillRoundColorBackground(Graphics2D g2, Color[] colors, float x, float y, float w, float h2, float arcWidth, float arcHeight) {
        Paint oldPaint = g2.getPaint();
        switch (colors.length) {
            case 1: {
                g2.setColor(colors[0]);
                g2.fillRoundRect(Math.round(x), Math.round(y), Math.round(w), Math.round(h2), Math.round(arcWidth), Math.round(arcHeight));
                break;
            }
            case 2: {
                GradientPaint gradient = new GradientPaint(x, y, colors[0], x + w, y, colors[1]);
                g2.setPaint(gradient);
                g2.fillRoundRect(Math.round(x), Math.round(y), Math.round(w), Math.round(h2), Math.round(arcWidth), Math.round(arcHeight));
                break;
            }
            case 3: {
                float halfWidth = w / 2.0f;
                GradientPaint gradient1 = new GradientPaint(x, y, colors[0], x + halfWidth, y, colors[1]);
                g2.setPaint(gradient1);
                g2.fillRoundRect(Math.round(x), Math.round(y), Math.round(halfWidth), Math.round(h2), Math.round(arcWidth), Math.round(arcHeight));
                g2.fillRect(Math.round(x + halfWidth - arcWidth), Math.round(y), Math.round(arcWidth), Math.round(h2));
                GradientPaint gradient2 = new GradientPaint(x + halfWidth, y, colors[1], x + w, y, colors[2]);
                g2.setPaint(gradient2);
                g2.fillRoundRect(Math.round(x + halfWidth), Math.round(y), Math.round(halfWidth), Math.round(h2), Math.round(arcWidth), Math.round(arcHeight));
                g2.fillRect(Math.round(x + halfWidth), Math.round(y), Math.round(arcWidth), Math.round(h2));
            }
        }
        g2.setPaint(oldPaint);
    }

    private static void drawVerticallyCenteredString(Graphics2D g2, String text, Rectangle area, Font originalFont, int size) {
        Font font = FCardImageRenderer.getFontBySize(originalFont, size);
        FontMetrics fontMetrics = g2.getFontMetrics(font);
        while (fontMetrics.stringWidth(text) > area.width) {
            font = FCardImageRenderer.getFontBySize(originalFont, --size);
            fontMetrics = g2.getFontMetrics(font);
        }
        int x = area.x;
        int y = area.y + (area.height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
        g2.setFont(font);
        g2.setColor(TEXT_COLOR);
        g2.drawString(text, x, y);
    }

    private static void drawHeader(Graphics2D g2, CardView.CardStateView state, Color[] colors, int x, int y, int w, int h2, boolean drawMana, boolean drawRoundRect) {
        int padding = h2 / 3;
        FCardImageRenderer.fillRoundColorBackground(g2, colors, x, y, w, h2, drawRoundRect ? (float)padding : 0.0f, drawRoundRect ? (float)h2 : 0.0f);
        if (drawRoundRect) {
            g2.setStroke(new BasicStroke(BOX_LINE_THICKNESS));
            g2.setColor(Color.BLACK);
            g2.drawRoundRect(x, y, w, h2, padding, h2);
        }
        if (drawMana) {
            ManaCost manaCost = state.getManaCost();
            int manaCostWidth = manaCost.getGlyphCount() * NAME_SIZE + HEADER_PADDING;
            CardFaceSymbols.draw(g2, manaCost, x + w - manaCostWidth, y + (h2 - NAME_SIZE) / 2 + 1, NAME_SIZE - 1);
            w -= padding + manaCostWidth;
        }
        FCardImageRenderer.drawVerticallyCenteredString(g2, CardTranslation.getTranslatedName(state.getName()), new Rectangle(x += padding, y, w -= 2 * padding, h2), NAME_FONT, NAME_SIZE);
    }

    private static void drawArt(Graphics2D g2, Color[] colors, int x, int y, int w, int h2, BufferedImage art) {
        if (art != null) {
            int artHeight;
            int artWidth = art.getWidth();
            if ((float)artWidth / (float)(artHeight = art.getHeight()) >= (float)w / (float)h2) {
                int newW = Math.round((float)artHeight * ((float)w / (float)h2));
                int newX = (artWidth - newW) / 2;
                g2.drawImage(art, x, y, x + w, y + h2, newX, 0, newX + newW, art.getHeight(), null);
            } else {
                int newH = Math.round((float)artWidth * ((float)h2 / (float)w));
                int newY = (artHeight - newH) / 2;
                g2.drawImage(art, x, y, x + w, y + h2, 0, newY, art.getWidth(), newY + newH, null);
            }
        } else {
            FCardImageRenderer.fillColorBackground(g2, colors, x, y, w, h2);
            FSkin.SkinIcon icon = FSkin.getIcon(FSkinProp.ICO_LOGO);
            float artWidth = (float)icon.getSizeForPaint(g2).getWidth();
            float artHeight = (float)icon.getSizeForPaint(g2).getHeight();
            if (artWidth / artHeight >= (float)w / (float)h2) {
                int newH = Math.round((float)w * (artHeight / artWidth));
                FSkin.drawImage(g2, icon, x, y + (h2 - newH) / 2, w, newH);
            } else {
                int newW = Math.round((float)h2 * (artWidth / artHeight));
                FSkin.drawImage(g2, icon, x + (w - newW) / 2, y, newW, h2);
            }
        }
        g2.setStroke(new BasicStroke(BOX_LINE_THICKNESS));
        g2.setColor(Color.BLACK);
        g2.drawRect(x, y, w, h2);
    }

    private static void drawTypeLine(Graphics2D g2, CardView.CardStateView state, Color[] colors, int x, int y, int w, int h2, int adjust, boolean drawRarity, boolean drawRoundRect) {
        int padding = h2 / 3;
        FCardImageRenderer.fillRoundColorBackground(g2, colors, x, y, w, h2, drawRoundRect ? (float)padding : 0.0f, drawRoundRect ? (float)h2 : 0.0f);
        if (drawRoundRect) {
            g2.setStroke(new BasicStroke(BOX_LINE_THICKNESS));
            g2.setColor(Color.BLACK);
            g2.drawRoundRect(x, y, w, h2, padding, h2);
        }
        w -= adjust;
        if (drawRarity) {
            int iconSize = Math.round((float)h2 * 0.9f);
            int iconPadding = (h2 - iconSize) / 2;
            w -= iconSize + iconPadding * 2;
            if (state.getRarity() == null) {
                FSkin.drawImage(g2, FSkin.getImage(FSkinProp.IMG_SETLOGO_SPECIAL), x + w + iconPadding, y + (h2 - iconSize + 1) / 2, iconSize, iconSize);
            } else if (state.getRarity() == CardRarity.Special) {
                FSkin.drawImage(g2, FSkin.getImage(FSkinProp.IMG_SETLOGO_SPECIAL), x + w + iconPadding, y + (h2 - iconSize + 1) / 2, iconSize, iconSize);
            } else if (state.getRarity() == CardRarity.MythicRare) {
                FSkin.drawImage(g2, FSkin.getImage(FSkinProp.IMG_SETLOGO_MYTHIC), x + w + iconPadding, y + (h2 - iconSize + 1) / 2, iconSize, iconSize);
            } else if (state.getRarity() == CardRarity.Rare) {
                FSkin.drawImage(g2, FSkin.getImage(FSkinProp.IMG_SETLOGO_RARE), x + w + iconPadding, y + (h2 - iconSize + 1) / 2, iconSize, iconSize);
            } else if (state.getRarity() == CardRarity.Uncommon) {
                FSkin.drawImage(g2, FSkin.getImage(FSkinProp.IMG_SETLOGO_UNCOMMON), x + w + iconPadding, y + (h2 - iconSize + 1) / 2, iconSize, iconSize);
            } else {
                FSkin.drawImage(g2, FSkin.getImage(FSkinProp.IMG_SETLOGO_COMMON), x + w + iconPadding, y + (h2 - iconSize + 1) / 2, iconSize, iconSize);
            }
        }
        x += padding;
        w -= padding;
        if (!state.getType().hasStringType("Room") || state.getState() != CardStateName.RightSplit) {
            String typeLine = CardDetailUtil.formatCardType(state, true).replace(" - ", " \u2014 ");
            FCardImageRenderer.drawVerticallyCenteredString(g2, typeLine, new Rectangle(x, y, w, h2), TYPE_FONT, TYPE_SIZE);
        }
    }

    private static void drawTextBox(Graphics2D g2, CardView.CardStateView state, String text, Color[] colors, int x, int y, int w, int h2, int textBoxFlags) {
        int yAdjust = textBoxFlags >> 16;
        if (state.isLand()) {
            CardDetailUtil.DetailColors modColors = CardDetailUtil.DetailColors.WHITE;
            if (state.isBasicLand()) {
                if (state.isForest()) {
                    modColors = CardDetailUtil.DetailColors.GREEN;
                } else if (state.isIsland()) {
                    modColors = CardDetailUtil.DetailColors.BLUE;
                } else if (state.isMountain()) {
                    modColors = CardDetailUtil.DetailColors.RED;
                } else if (state.isSwamp()) {
                    modColors = CardDetailUtil.DetailColors.BLACK;
                } else if (state.isPlains()) {
                    modColors = CardDetailUtil.DetailColors.LAND;
                }
            }
            Object bgColor = FCardImageRenderer.fromDetailColor(modColors);
            bgColor = FCardImageRenderer.tintColor(Color.WHITE, (Color)bgColor, 0.2f);
            Paint oldPaint = g2.getPaint();
            g2.setColor((Color)bgColor);
            g2.fillRect(Math.round(x), Math.round(y), Math.round(w), Math.round(h2));
            g2.setPaint(oldPaint);
        } else {
            FCardImageRenderer.fillColorBackground(g2, colors, x, y + yAdjust, w, h2 - yAdjust);
        }
        g2.setStroke(new BasicStroke(BOX_LINE_THICKNESS));
        g2.setColor(Color.BLACK);
        g2.drawRect(x, y, w, h2);
        if (state.isBasicLand()) {
            String imageKey;
            switch (state.getName().replaceFirst("^Snow-Covered ", "")) {
                case "Plains": {
                    imageKey = "W";
                    break;
                }
                case "Island": {
                    imageKey = "U";
                    break;
                }
                case "Swamp": {
                    imageKey = "B";
                    break;
                }
                case "Mountain": {
                    imageKey = "R";
                    break;
                }
                case "Forest": {
                    imageKey = "G";
                    break;
                }
                default: {
                    imageKey = "C";
                }
            }
            int iconSize = Math.round((float)h2 * 0.75f);
            CardFaceSymbols.drawWatermark(imageKey, g2, x + (w - iconSize) / 2, y + (h2 - iconSize) / 2, iconSize);
        } else {
            if (StringUtils.isEmpty(text)) {
                return;
            }
            int padding = TEXT_SIZE / 4;
            x += padding;
            w -= 2 * padding;
            if ((textBoxFlags & 2) == 2) {
                w -= PT_BOX_WIDTH;
            }
            FCardImageRenderer.drawTextBoxText(g2, text, x, y + yAdjust, w, h2 - yAdjust, textBoxFlags);
        }
    }

    private static void drawPTBox(Graphics2D g2, CardView.CardStateView state, String ptOverride, Color[] colors, int x, int y, int w, int h2) {
        Color[] pwColor;
        ArrayList<String> pieces = new ArrayList<String>();
        if (state.isCreature()) {
            if (ptOverride != null) {
                String[] pt = ptOverride.split("/");
                pieces.add(pt[0]);
                pieces.add("/");
                pieces.add(pt[1]);
            } else {
                pieces.add(String.valueOf(state.getPower()));
                pieces.add("/");
                pieces.add(String.valueOf(state.getToughness()));
            }
        } else if (state.isPlaneswalker()) {
            pwColor = new Color[]{Color.BLACK};
            colors = pwColor;
            TEXT_COLOR = Color.WHITE;
            pieces.add(String.valueOf(state.getLoyalty()));
        } else if (state.isBattle()) {
            pwColor = new Color[]{Color.BLACK};
            colors = pwColor;
            TEXT_COLOR = Color.WHITE;
            pieces.add(String.valueOf(state.getDefense()));
        } else if (state.isVehicle()) {
            Color[] vhColor = new Color[]{new Color(128, 96, 64)};
            colors = vhColor;
            TEXT_COLOR = Color.WHITE;
            pieces.add(String.valueOf(state.getPower()));
            pieces.add("/");
            pieces.add(String.valueOf(state.getToughness()));
        } else {
            return;
        }
        Font font = FCardImageRenderer.getFontBySize(PT_FONT, PT_SIZE);
        FontMetrics metrics = g2.getFontMetrics(font);
        int padding = PT_SIZE / 4;
        int totalPieceWidth = -padding;
        int[] pieceWidths = new int[pieces.size()];
        for (int i = 0; i < pieces.size(); ++i) {
            int pieceWidth;
            pieceWidths[i] = pieceWidth = metrics.stringWidth((String)pieces.get(i)) + padding;
            totalPieceWidth += pieceWidth;
        }
        x += w - PT_BOX_WIDTH;
        w = PT_BOX_WIDTH;
        int arcWidth = h2 / 3;
        FCardImageRenderer.fillRoundColorBackground(g2, colors, x, y, w, h2, arcWidth, h2);
        g2.setStroke(new BasicStroke(BOX_LINE_THICKNESS));
        g2.setColor(state.isPlaneswalker() || state.isBattle() ? Color.WHITE : Color.BLACK);
        g2.drawRoundRect(x, y, w, h2, arcWidth, h2);
        x += (PT_BOX_WIDTH - totalPieceWidth) / 2;
        for (int i = 0; i < pieces.size(); ++i) {
            FCardImageRenderer.drawVerticallyCenteredString(g2, (String)pieces.get(i), new Rectangle(x, y - 2, w, h2), PT_FONT, PT_SIZE);
            x += pieceWidths[i];
        }
        TEXT_COLOR = Color.BLACK;
    }

    private static void drawTextBoxText(Graphics2D g2, String text, int x, int y, int w, int h2, int flagPTBox) {
        int lineSpacing;
        int lineHeight;
        int paraSpacing;
        int totalLines;
        int totalHeight;
        boolean isLevelBox;
        boolean hasPTBox = (flagPTBox & 1) == 1;
        boolean isLevelup = (flagPTBox & 2) == 2;
        boolean bl = isLevelBox = (flagPTBox & 4) == 4;
        if (FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_CARD_IMAGE_RENDER_HIDE_REMINDER_TEXT)) {
            text = reminderHidePattern.matcher(text).replaceAll("");
        }
        String[] paragraphs = isLevelBox ? text.split(" ") : linebreakPattern.split(text);
        ArrayList<Paragraph> pgList = new ArrayList<Paragraph>();
        for (String pg : paragraphs) {
            pgList.add(new Paragraph(pg));
        }
        Font txFont = FCardImageRenderer.getFontBySize(TEXT_FONT, TEXT_SIZE);
        Font rmFont = FCardImageRenderer.getFontBySize(REMINDER_FONT, REMINDER_SIZE);
        FontMetrics txMetrics = g2.getFontMetrics(txFont);
        FontMetrics rmMetrics = g2.getFontMetrics(rmFont);
        int txFontSize = txFont.getSize();
        int rmFontSize = rmFont.getSize();
        do {
            int totalLineSpacings = 0;
            totalHeight = 0;
            totalLines = 0;
            paraSpacing = txMetrics.getLeading() + txMetrics.getDescent();
            lineHeight = txMetrics.getAscent() + txMetrics.getDescent();
            lineSpacing = -2;
            for (int i = 0; i < pgList.size(); ++i) {
                flagPTBox = i < pgList.size() - 1 ? 0 : (hasPTBox ? 1 : 0) + (i > 0 ? 2 : 0);
                Paragraph pg = (Paragraph)pgList.get(i);
                totalHeight += paraSpacing;
                int lines = pg.calculateLines(w, txMetrics, rmMetrics, flagPTBox);
                totalLines += lines;
                totalLineSpacings += lines - 1;
                totalHeight += lines * lineHeight + (lines - 1) * lineSpacing;
            }
            while (totalHeight > h2 && lineSpacing > -txMetrics.getDescent()) {
                --lineSpacing;
                totalHeight -= totalLineSpacings;
            }
            if (totalHeight <= h2) break;
            txFont = FCardImageRenderer.getFontBySize(TEXT_FONT, --txFontSize);
            txMetrics = g2.getFontMetrics(txFont);
            rmFont = FCardImageRenderer.getFontBySize(REMINDER_FONT, --rmFontSize);
            rmMetrics = g2.getFontMetrics(rmFont);
        } while (txFontSize >= 8 && rmFontSize >= 8);
        if (totalLines == 1 && !isLevelup) {
            Paragraph pg = (Paragraph)pgList.get(0);
            int width = pg.getTotalWidth(txMetrics, rmMetrics);
            x += (w - width) / 2;
        }
        y += (h2 - totalHeight - paraSpacing / 2) / 2;
        for (Paragraph pg : pgList) {
            int xoffset = isLevelBox ? (w - pg.getTotalWidth(txMetrics, rmMetrics)) / 2 : 0;
            y += pg.drawPieces(g2, x + xoffset, y, w, lineSpacing + lineHeight, txFont, txMetrics, rmFont, rmMetrics);
            y += paraSpacing - lineSpacing;
            if (!isLevelBox) continue;
            txFont = FCardImageRenderer.getFontBySize(TEXT_FONT, txFontSize + 10);
            txMetrics = g2.getFontMetrics(txFont);
            y -= paraSpacing;
        }
    }

    static {
        C_COMMON = FCardImageRenderer.fromDetailColor(CardDetailUtil.DetailColors.COMMON);
        C_UNCOMMON = FCardImageRenderer.fromDetailColor(CardDetailUtil.DetailColors.UNCOMMON);
        C_RARE = FCardImageRenderer.fromDetailColor(CardDetailUtil.DetailColors.RARE);
        C_MYTHIC = FCardImageRenderer.fromDetailColor(CardDetailUtil.DetailColors.MYTHIC);
        C_SPECIAL = FCardImageRenderer.fromDetailColor(CardDetailUtil.DetailColors.SPECIAL);
    }

    private static class Paragraph {
        private String text;
        private List<Piece> pieces;

        private void parseSymbols(String subtext, boolean isReminder) {
            ArrayList<String> symbols = new ArrayList<String>();
            Matcher sbMatcher = symbolPattern.matcher(subtext);
            int parsed = 0;
            while (sbMatcher.find()) {
                if (sbMatcher.start() > parsed) {
                    if (!symbols.isEmpty()) {
                        this.pieces.add(new SymbolPiece(symbols));
                        symbols = new ArrayList();
                    }
                    this.pieces.add(new TextPiece(subtext.substring(parsed, sbMatcher.start()), isReminder));
                }
                String symbol = sbMatcher.group(1) != null ? sbMatcher.group(1) : sbMatcher.group(2) + sbMatcher.group(3);
                symbols.add(symbol);
                parsed = sbMatcher.end();
            }
            if (!symbols.isEmpty()) {
                this.pieces.add(new SymbolPiece(symbols));
            }
            if (parsed < subtext.length()) {
                this.pieces.add(new TextPiece(subtext.substring(parsed, subtext.length()), isReminder));
            }
        }

        private void buildPieceList() {
            this.pieces = new ArrayList<Piece>();
            Matcher rmMatcher = reminderPattern.matcher(this.text);
            int parsed = 0;
            while (rmMatcher.find()) {
                if (rmMatcher.start() > parsed) {
                    this.parseSymbols(this.text.substring(parsed, rmMatcher.start()), false);
                }
                this.parseSymbols(this.text.substring(rmMatcher.start(), rmMatcher.end()), true);
                parsed = rmMatcher.end();
            }
            if (parsed < this.text.length()) {
                this.parseSymbols(this.text.substring(parsed, this.text.length()), false);
            }
        }

        public Paragraph(String text) {
            this.text = text;
            this.buildPieceList();
        }

        public int getTotalWidth(FontMetrics txMetrics, FontMetrics rmMetrics) {
            int width = 0;
            for (Piece p : this.pieces) {
                p.restart();
                int w = p.getNextWidth(txMetrics, rmMetrics);
                while (w != -1) {
                    width += w;
                    w = p.getNextWidth(txMetrics, rmMetrics);
                }
            }
            return width;
        }

        public int calculateLines(int width, FontMetrics txMetrics, FontMetrics rmMetrics, int flagPTBox) {
            boolean hasMultipleParagraph;
            int pos = 0;
            int lines = 1;
            for (Piece p : this.pieces) {
                p.restart();
                int w = p.getNextWidth(txMetrics, rmMetrics);
                while (w != -1) {
                    if (pos + w > width && pos > 0) {
                        ++lines;
                        pos = 0;
                    }
                    pos += w;
                    w = p.getNextWidth(txMetrics, rmMetrics);
                }
            }
            boolean hasPTBox = (flagPTBox & 1) == 1;
            boolean bl = hasMultipleParagraph = (flagPTBox & 2) == 2;
            if (hasPTBox && pos >= width - PT_BOX_WIDTH && (lines > 1 || hasMultipleParagraph)) {
                ++lines;
            }
            return lines;
        }

        public int drawPieces(Graphics2D g2, int x, int y, int width, int lineHeight, Font txFont, FontMetrics txMetrics, Font rmFont, FontMetrics rmMetrics) {
            int pos = 0;
            int lines = 1;
            for (Piece p : this.pieces) {
                p.restart();
                int w = p.getNextWidth(txMetrics, rmMetrics);
                while (w != -1) {
                    if (pos + w > width && pos > 0) {
                        ++lines;
                        pos = 0;
                        y += lineHeight;
                    }
                    p.drawCurrent(g2, x + pos, y, txFont, rmFont, txMetrics);
                    pos += w;
                    w = p.getNextWidth(txMetrics, rmMetrics);
                }
            }
            return lines * lineHeight;
        }
    }

    private static class SymbolPiece
    extends Piece {
        private List<String> symbols;
        private boolean restarted;

        public SymbolPiece(List<String> symbols) {
            super(false);
            this.symbols = symbols;
            this.restarted = false;
        }

        @Override
        public void restart() {
            this.restarted = true;
        }

        @Override
        public int getNextWidth(FontMetrics txMetrics, FontMetrics rmMetrics) {
            if (this.restarted) {
                int offset = Math.round((float)txMetrics.getAscent() * 0.8f);
                this.restarted = false;
                return offset * this.symbols.size();
            }
            return -1;
        }

        @Override
        public void drawCurrent(Graphics2D g2, int x, int y, Font txFont, Font rmFont, FontMetrics txMetrics) {
            int xoffset = Math.round((float)txMetrics.getAscent() * 0.8f);
            int yoffset = txMetrics.getAscent() - xoffset + 2;
            for (String s2 : this.symbols) {
                CardFaceSymbols.drawSymbol(s2, g2, x, y + yoffset, xoffset - 1);
                x += xoffset;
            }
        }
    }

    private static class TextPiece
    extends Piece {
        private String text;
        private int index;
        private List<Integer> boundaryList;

        private void buildBoundaryList() {
            this.boundaryList = new ArrayList<Integer>();
            boundary.setText(this.text);
            this.boundaryList.add(boundary.first());
            int next = boundary.next();
            while (next != -1) {
                this.boundaryList.add(next);
                next = boundary.next();
            }
        }

        public TextPiece(String text, boolean isReminder) {
            super(isReminder);
            this.text = text;
            this.buildBoundaryList();
        }

        @Override
        public void restart() {
            this.index = 0;
        }

        @Override
        public int getNextWidth(FontMetrics txMetrics, FontMetrics rmMetrics) {
            ++this.index;
            if (this.index == this.boundaryList.size()) {
                return -1;
            }
            String subtext = this.text.substring(this.boundaryList.get(this.index - 1), this.boundaryList.get(this.index));
            if (this.isReminder) {
                return rmMetrics.stringWidth(subtext);
            }
            return txMetrics.stringWidth(subtext);
        }

        @Override
        public void drawCurrent(Graphics2D g2, int x, int y, Font txFont, Font rmFont, FontMetrics txMetrics) {
            int ascent = txMetrics.getAscent();
            String subtext = this.text.substring(this.boundaryList.get(this.index - 1), this.boundaryList.get(this.index));
            if (this.isReminder) {
                g2.setFont(rmFont);
            } else {
                g2.setFont(txFont);
            }
            g2.drawString(subtext, x, y + ascent);
        }
    }

    private static abstract class Piece {
        protected final boolean isReminder;

        protected Piece(boolean isReminder) {
            this.isReminder = isReminder;
        }

        public abstract void restart();

        public abstract int getNextWidth(FontMetrics var1, FontMetrics var2);

        public abstract void drawCurrent(Graphics2D var1, int var2, int var3, Font var4, Font var5, FontMetrics var6);
    }
}

