/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import javax.swing.JComponent;

public final class LayoutHelper {
    private final int parentWidth;
    private final int parentHeight;
    private int x;
    private int y;
    private int lineBottom;
    private final int gapX;
    private final int gapY;

    public LayoutHelper(JComponent parent) {
        this(parent, 3, 3);
    }

    public LayoutHelper(JComponent parent, int gapX0, int gapY0) {
        this.parentWidth = parent.getWidth();
        this.parentHeight = parent.getHeight();
        this.gapX = gapX0;
        this.gapY = gapY0;
    }

    public void fill(JComponent comp) {
        this.newLine();
        this.include(comp, this.parentWidth, this.parentHeight - this.y);
    }

    public void fillLine(JComponent comp, int height) {
        this.fillLine(comp, height, 0);
    }

    public void fillLine(JComponent comp, int height, int rightPadding) {
        if (this.x >= this.parentWidth) {
            this.newLine();
        }
        this.include(comp, this.parentWidth - this.x - rightPadding, height);
    }

    public void include(JComponent comp, float widthPercent, int height) {
        this.include(comp, Math.round((float)this.parentWidth * widthPercent), height);
    }

    public void include(JComponent comp, int width, float heightPercent) {
        this.include(comp, width, Math.round((float)this.parentHeight * heightPercent));
    }

    public void include(JComponent comp, float widthPercent, float heightPercent) {
        this.include(comp, Math.round((float)this.parentWidth * widthPercent), Math.round((float)this.parentHeight * heightPercent));
    }

    public void include(JComponent comp, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        if (this.x + width > this.parentWidth) {
            this.newLine();
            if (width > this.parentWidth) {
                width = this.parentWidth;
            }
        }
        if (this.y + height > this.parentHeight) {
            this.y = this.parentHeight - height;
            if (this.y >= this.parentHeight) {
                return;
            }
        }
        comp.setBounds(this.x, this.y, width, height);
        this.x += width + this.gapX;
        if (this.y + height > this.lineBottom) {
            this.lineBottom = this.y + height;
        }
    }

    public void offset(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    public void newLine() {
        if (this.lineBottom == this.y) {
            return;
        }
        this.x = 0;
        this.lineBottom = this.y = this.lineBottom + this.gapY;
    }

    public void newLine(int dy) {
        this.x = 0;
        this.lineBottom = this.y = this.lineBottom + this.gapY + dy;
    }

    public int getParentWidth() {
        return this.parentWidth;
    }

    public int getParentHeight() {
        return this.parentHeight;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getGapX() {
        return this.gapX;
    }

    public int getGapY() {
        return this.gapY;
    }
}

