/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class FUndoManager
extends UndoManager
implements DocumentListener {
    private final UndoManager undoManager;
    private CompoundEdit compoundEdit;
    private final JTextComponent textComponent;
    private final UndoAction undoAction;
    private final RedoAction redoAction;
    private int lastOffset;
    private int lastLength;

    public FUndoManager(JTextComponent textComponent) {
        this.textComponent = textComponent;
        this.undoManager = this;
        this.undoAction = new UndoAction();
        this.redoAction = new RedoAction();
        textComponent.getDocument().addUndoableEditListener(this);
    }

    @Override
    public synchronized void undo() {
        if (this.canUndo()) {
            this.textComponent.getDocument().addDocumentListener(this);
            super.undo();
            this.textComponent.getDocument().removeDocumentListener(this);
        }
    }

    @Override
    public synchronized void redo() {
        if (this.canRedo()) {
            this.textComponent.getDocument().addDocumentListener(this);
            super.redo();
            this.textComponent.getDocument().removeDocumentListener(this);
        }
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        if (this.compoundEdit == null) {
            this.compoundEdit = this.startCompoundEdit(e.getEdit());
            return;
        }
        int offsetChange = this.textComponent.getCaretPosition() - this.lastOffset;
        int lengthChange = this.textComponent.getDocument().getLength() - this.lastLength;
        AbstractDocument.DefaultDocumentEvent event = (AbstractDocument.DefaultDocumentEvent)e.getEdit();
        if (event.getType().equals(DocumentEvent.EventType.CHANGE) && offsetChange == 0) {
            this.compoundEdit.addEdit(e.getEdit());
            return;
        }
        if (offsetChange == lengthChange && Math.abs(offsetChange) == 1) {
            this.compoundEdit.addEdit(e.getEdit());
            this.lastOffset = this.textComponent.getCaretPosition();
            this.lastLength = this.textComponent.getDocument().getLength();
            return;
        }
        this.compoundEdit.end();
        this.compoundEdit = this.startCompoundEdit(e.getEdit());
    }

    private CompoundEdit startCompoundEdit(UndoableEdit anEdit) {
        this.lastOffset = this.textComponent.getCaretPosition();
        this.lastLength = this.textComponent.getDocument().getLength();
        this.compoundEdit = new MyCompoundEdit();
        this.compoundEdit.addEdit(anEdit);
        this.addEdit(this.compoundEdit);
        this.undoAction.updateUndoState();
        this.redoAction.updateRedoState();
        return this.compoundEdit;
    }

    public Action getUndoAction() {
        return this.undoAction;
    }

    public Action getRedoAction() {
        return this.redoAction;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        int offset = e.getOffset() + e.getLength();
        offset = Math.min(offset, this.textComponent.getDocument().getLength());
        this.textComponent.setCaretPosition(offset);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.textComponent.setCaretPosition(e.getOffset());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private class RedoAction
    extends AbstractAction {
        public RedoAction() {
            this.putValue("Name", "Redo");
            this.putValue("ShortDescription", this.getValue("Name"));
            this.putValue("MnemonicKey", 82);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, 128));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                FUndoManager.this.undoManager.redo();
                FUndoManager.this.textComponent.requestFocusInWindow();
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
            this.updateRedoState();
            FUndoManager.this.undoAction.updateUndoState();
        }

        protected void updateRedoState() {
            this.setEnabled(FUndoManager.this.undoManager.canRedo());
        }
    }

    private class UndoAction
    extends AbstractAction {
        public UndoAction() {
            this.putValue("Name", "Undo");
            this.putValue("ShortDescription", this.getValue("Name"));
            this.putValue("MnemonicKey", 85);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, 128));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                FUndoManager.this.undoManager.undo();
                FUndoManager.this.textComponent.requestFocusInWindow();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
            this.updateUndoState();
            FUndoManager.this.redoAction.updateRedoState();
        }

        private void updateUndoState() {
            this.setEnabled(FUndoManager.this.undoManager.canUndo());
        }
    }

    private class MyCompoundEdit
    extends CompoundEdit {
        private MyCompoundEdit() {
        }

        @Override
        public boolean isInProgress() {
            return false;
        }

        @Override
        public void undo() throws CannotUndoException {
            if (FUndoManager.this.compoundEdit != null) {
                FUndoManager.this.compoundEdit.end();
            }
            super.undo();
            FUndoManager.this.compoundEdit = null;
        }
    }
}

