/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import forge.gui.MouseUtil;
import forge.gui.interfaces.ITextField;
import forge.toolbox.FSkin;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class FTextField
extends FSkin.SkinnedTextField
implements ITextField {
    public static final int HEIGHT = 25;
    private static final FSkin.SkinColor textColor = FSkin.getColor(FSkin.Colors.CLR_TEXT);
    private static final FSkin.SkinColor ghostTextColor = textColor.stepColor(20);
    private static final FSkin.SkinColor backColor = FSkin.getColor(FSkin.Colors.CLR_THEME2);
    private String ghostText;
    private boolean showGhostTextWithFocus;

    private FTextField(Builder builder) {
        this.setForeground(textColor);
        this.setBackground(backColor);
        this.setCaretColor(textColor);
        this.setMargin(new Insets(3, 3, 2, 3));
        this.setOpaque(true);
        if (builder.maxLength > 0) {
            this.setDocument(new _LengthLimitedDocument(builder.maxLength));
        }
        this.setEditable(!builder.readonly);
        this.setText(builder.text);
        this.setToolTipText(builder.toolTip);
        this.setFocusable(true);
        if (this.isEditable()) {
            MouseUtil.setComponentCursor((Component)this, 2);
        }
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                FTextField field = (FTextField)e.getSource();
                if (field.isEmpty()) {
                    if (field.ghostText != null && !field.showGhostTextWithFocus) {
                        field.repaint();
                    }
                } else {
                    SwingUtilities.invokeLater(field::selectAll);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                FTextField field = (FTextField)e.getSource();
                if (field.ghostText != null && field.isEmpty() && !field.showGhostTextWithFocus) {
                    field.repaint();
                }
            }
        });
        this.showGhostTextWithFocus = builder.showGhostTextWithFocus;
        this.ghostText = builder.ghostText;
        if ("".equals(this.ghostText)) {
            this.ghostText = null;
        }
    }

    public boolean isEmpty() {
        String text = this.getText();
        return text == null || text.isEmpty();
    }

    public int getAutoSizeWidth() {
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        return metrics.stringWidth(this.getText()) + 12;
    }

    @Override
    public void paint(Graphics g2) {
        super.paint(g2);
        if (this.ghostText != null && this.isEmpty() && (this.showGhostTextWithFocus || !this.hasFocus())) {
            Insets margin = this.getMargin();
            Graphics2D g2d = (Graphics2D)g2.create();
            g2d.setFont(this.getFont());
            FSkin.setGraphicsColor(g2d, ghostTextColor);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.drawString(this.ghostText, margin.left + 2, this.getBaseline(this.getWidth(), this.getHeight()));
            g2d.dispose();
        }
    }

    public String getGhostText() {
        return this.ghostText;
    }

    public void setGhostText(String ghostText0) {
        if ("".equals(this.ghostText)) {
            ghostText0 = null;
        }
        if (this.ghostText == ghostText0) {
            return;
        }
        this.ghostText = ghostText0;
        if (this.isEmpty()) {
            this.repaint();
        }
    }

    public boolean getShowGhostTextWithFocus() {
        return this.showGhostTextWithFocus;
    }

    public void setShowGhostTextWithFocus(boolean showGhostTextWithFocus0) {
        if (this.showGhostTextWithFocus == showGhostTextWithFocus0) {
            return;
        }
        this.showGhostTextWithFocus = showGhostTextWithFocus0;
        if (this.isEmpty() && this.hasFocus()) {
            this.repaint();
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.getDocument().addDocumentListener(listener);
    }

    public static abstract class ChangeListener
    implements DocumentListener {
        @Override
        public void changedUpdate(DocumentEvent e) {
            this.textChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.textChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.textChanged();
        }

        public abstract void textChanged();
    }

    private static class _LengthLimitedDocument
    extends PlainDocument {
        private final int _limit;

        _LengthLimitedDocument(int limit) {
            this._limit = limit;
        }

        @Override
        public void insertString(int offset, String s2, AttributeSet attributeSet) throws BadLocationException {
            if (this._limit <= this.getLength()) {
                return;
            }
            int newLen = this.getLength() + s2.length();
            if (this._limit < newLen) {
                s2 = s2.substring(0, this._limit - this.getLength());
            }
            super.insertString(offset, s2, attributeSet);
        }
    }

    public static class Builder {
        private int maxLength = 0;
        private boolean readonly = false;
        private String text;
        private String toolTip;
        private String ghostText;
        private boolean showGhostTextWithFocus;

        public FTextField build() {
            return new FTextField(this);
        }

        public Builder maxLength(int i0) {
            this.maxLength = i0;
            return this;
        }

        public Builder readonly(boolean b0) {
            this.readonly = b0;
            return this;
        }

        public Builder readonly() {
            return this.readonly(true);
        }

        public Builder text(String s0) {
            this.text = s0;
            return this;
        }

        public Builder tooltip(String s0) {
            this.toolTip = s0;
            return this;
        }

        public Builder ghostText(String s0) {
            this.ghostText = s0;
            return this;
        }

        public Builder showGhostTextWithFocus(boolean b0) {
            this.showGhostTextWithFocus = b0;
            return this;
        }

        public Builder showGhostTextWithFocus() {
            return this.showGhostTextWithFocus(true);
        }
    }
}

