/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import forge.gui.MouseUtil;
import forge.toolbox.FSkin;
import forge.toolbox.FUndoManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;

public class FTextEditor
extends FSkin.SkinnedScrollPane {
    private final FSkin.SkinnedTextArea tarEditor = new FSkin.SkinnedTextArea();
    private final FUndoManager undoManager;

    public FTextEditor() {
        this.tarEditor.setFont(FSkin.getRelativeFixedFont(16));
        this.tarEditor.setForeground(FSkin.getColor(FSkin.Colors.CLR_TEXT));
        this.tarEditor.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
        this.tarEditor.setCaretColor(FSkin.getColor(FSkin.Colors.CLR_TEXT));
        this.undoManager = new FUndoManager(this.tarEditor);
        this.tarEditor.setMargin(new Insets(3, 3, 3, 3));
        this.tarEditor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isControlDown() && !e.isMetaDown()) {
                    switch (e.getKeyCode()) {
                        case 90: {
                            if (e.isShiftDown()) {
                                FTextEditor.this.undoManager.redo();
                                break;
                            }
                            FTextEditor.this.undoManager.undo();
                            break;
                        }
                        case 89: {
                            if (e.isShiftDown()) break;
                            FTextEditor.this.undoManager.redo();
                        }
                    }
                }
            }
        });
        this.setViewportView(this.tarEditor);
        this.setBorder((Border)null);
        this.setOpaque(false);
        if (this.isEditable()) {
            MouseUtil.setComponentCursor((Component)this.tarEditor, 2);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.tarEditor.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.tarEditor.setEnabled(enabled);
    }

    public String getText() {
        return this.tarEditor.getText();
    }

    public void setText(String t2) {
        this.tarEditor.setText(t2);
        this.undoManager.discardAllEdits();
    }

    public boolean isEditable() {
        return this.tarEditor.isEditable();
    }

    public void setEditable(boolean b) {
        this.tarEditor.setEditable(b);
    }

    public int getCaretPosition() {
        return this.tarEditor.getCaretPosition();
    }

    public void setCaretPosition(int position) {
        this.tarEditor.setCaretPosition(position);
    }

    public void addDocumentListener(DocumentListener listener) {
        this.tarEditor.getDocument().addDocumentListener(listener);
    }
}

