/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import forge.toolbox.FSkin;
import java.awt.Insets;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.NumberFormatter;

public class FSpinner
extends FSkin.SkinnedSpinner {
    private FSpinner(Builder builder) {
        this.setOpaque(false);
        this.setModel(new SpinnerNumberModel(builder.initialValue, builder.minValue, builder.maxValue, 1));
        this.setEditor(new JSpinner.NumberEditor((JSpinner)this, "##"));
        JFormattedTextField txt = this.getTextField();
        ((NumberFormatter)txt.getFormatter()).setAllowsInvalid(false);
        this.setForeground(FSkin.getColor(FSkin.Colors.CLR_TEXT));
        this.setBackground(FSkin.getColor(FSkin.Colors.CLR_THEME2));
        this.setCaretColor(FSkin.getColor(FSkin.Colors.CLR_TEXT));
        txt.setMargin(new Insets(5, 5, 5, 5));
        txt.setOpaque(true);
        this.setToolTipText(builder.toolTip);
        this.setFocusable(true);
    }

    public static class Builder {
        private int initialValue = 0;
        private int minValue = 0;
        private int maxValue = Integer.MAX_VALUE;
        private String toolTip;

        public FSpinner build() {
            return new FSpinner(this);
        }

        public Builder initialValue(int i0) {
            this.initialValue = i0;
            return this;
        }

        public Builder minValue(int i0) {
            this.minValue = i0;
            return this;
        }

        public Builder maxValue(int i0) {
            this.maxValue = i0;
            return this;
        }
    }
}

